/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.formatting.FormatterTagHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentLineDataBuilder
extends CommentLineDataBuilder {
    private final PsiComment myComment;
    private final IElementType myLineCommentType;
    private static final String LINE_COMMENT_PREFIX = "//";
    private TextRange myCommentBlockRange;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
    @Nullable
    private final TextRange myEnabledRange;
    private int myLeadingTabs;

    public LineCommentLineDataBuilder(@NotNull PsiComment comment, IElementType lineCommentType, @NotNull CommonCodeStyleSettings settings, @Nullable TextRange enabledRange) {
        if (comment == null) {
            LineCommentLineDataBuilder.A(0);
        }
        if (settings == null) {
            LineCommentLineDataBuilder.A(1);
        }
        super(settings.getRootSettings());
        this.myComment = comment;
        this.myLineCommentType = lineCommentType;
        this.myIndentOptions = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
        this.myEnabledRange = enabledRange;
    }

    public boolean canMerge(@NotNull PsiComment comment) {
        if (comment == null) {
            LineCommentLineDataBuilder.A(2);
        }
        return this.getFormatterTag(comment) == FormatterTagHandler.FormatterTag.NONE;
    }

    public boolean isMergedWithPrevious(@NotNull PsiComment comment) {
        if (comment == null) {
            LineCommentLineDataBuilder.A(3);
        }
        if (this.isAfterNonEmptyLine(comment.getNode())) {
            return false;
        }
        PsiElement psiElement = comment.getPrevSibling();
        if (psiElement instanceof PsiWhiteSpace) {
            PsiElement psiElement2 = psiElement;
            if ((psiElement = psiElement.getPrevSibling()) != null && psiElement.getNode().getElementType() == this.myLineCommentType && LineCommentLineDataBuilder.countLineBreaks(psiElement2.getNode()) == 1) {
                int n2;
                if (this.myEnabledRange != null && psiElement.getTextRange().getEndOffset() < this.myEnabledRange.getStartOffset() || psiElement instanceof PsiComment && this.getFormatterTag((PsiComment)psiElement) != FormatterTagHandler.FormatterTag.NONE) {
                    return false;
                }
                int n3 = this.calcBlockLineIndent(comment.getNode());
                return n3 == (n2 = this.calcBlockLineIndent(psiElement.getNode()));
            }
        }
        return false;
    }

    @Override
    public List<CommentLineData> getLines() {
        ArrayList<CommentLineData> arrayList = new ArrayList<CommentLineData>();
        int n2 = this.myComment.getTextRange().getStartOffset();
        int n3 = this.myComment.getTextRange().getEndOffset();
        int n4 = this.calcBlockLineIndent(this.myComment.getNode());
        this.A(arrayList, (PsiElement)this.myComment, n4, true);
        for (PsiElement psiElement = this.myComment.getNextSibling(); psiElement != null && (this.myEnabledRange == null || psiElement.getTextRange().getStartOffset() <= this.myEnabledRange.getEndOffset()); psiElement = psiElement.getNextSibling()) {
            if (psiElement.getNode().getElementType() == this.myLineCommentType) {
                int n5;
                if (psiElement instanceof PsiComment && this.getFormatterTag((PsiComment)psiElement) != FormatterTagHandler.FormatterTag.NONE || (n5 = this.calcBlockLineIndent(psiElement.getNode())) != n4) break;
                n3 = psiElement.getTextRange().getEndOffset();
                this.A(arrayList, psiElement, n4, false);
                continue;
            }
            if (!(psiElement instanceof PsiWhiteSpace) || LineCommentLineDataBuilder.countLineBreaks(psiElement.getNode()) > 1) break;
        }
        this.myCommentBlockRange = new TextRange(n2, n3);
        return arrayList;
    }

    public TextRange getCommentBlockRange() {
        return this.myCommentBlockRange;
    }

    private void A(List<CommentLineData> list, @NotNull PsiElement psiElement, int n2, boolean bl) {
        if (psiElement == null) {
            LineCommentLineDataBuilder.A(4);
        }
        String string = new String(CharArrayUtil.fromSequence((CharSequence)psiElement.getNode().getChars()));
        LineCommentLineData lineCommentLineData = (LineCommentLineData)this.parseLine(string);
        lineCommentLineData.indent = n2;
        lineCommentLineData.isFirst = bl;
        list.add(lineCommentLineData);
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String line) {
        int n2;
        if (line == null) {
            LineCommentLineDataBuilder.A(5);
        }
        LineCommentLineData lineCommentLineData = new LineCommentLineData(line);
        lineCommentLineData.commentOffset = LineCommentLineDataBuilder.nextNonWhitespace(line, 0);
        if (lineCommentLineData.commentOffset >= 0 && (n2 = lineCommentLineData.commentOffset + LINE_COMMENT_PREFIX.length()) < line.length()) {
            lineCommentLineData.textStartOffset = LineCommentLineDataBuilder.nextNonWhitespace(line, n2);
        }
        LineCommentLineData lineCommentLineData2 = lineCommentLineData;
        if (lineCommentLineData2 == null) {
            LineCommentLineDataBuilder.A(6);
        }
        return lineCommentLineData2;
    }

    public boolean isAfterNonEmptyLine(@NotNull ASTNode node) {
        ASTNode aSTNode;
        if (node == null) {
            LineCommentLineDataBuilder.A(7);
        }
        if (node.getElementType() == this.myLineCommentType && (aSTNode = node.getTreePrev()) != null) {
            return !(aSTNode.getPsi() instanceof PsiWhiteSpace) || !aSTNode.textContains('\n');
        }
        return false;
    }

    public static int countLineBreaks(@NotNull ASTNode node) {
        if (node == null) {
            LineCommentLineDataBuilder.A(8);
        }
        CharSequence charSequence = node.getChars();
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) != '\n') continue;
            ++n2;
        }
        return n2;
    }

    public int calcBlockLineIndent(@NotNull ASTNode node) {
        ASTNode aSTNode;
        if (node == null) {
            LineCommentLineDataBuilder.A(9);
        }
        int n2 = 0;
        for (aSTNode = node.getTreePrev(); aSTNode != null && !aSTNode.textContains('\n'); aSTNode = aSTNode.getTreePrev()) {
            n2 += aSTNode.getTextLength();
        }
        if (aSTNode != null) {
            int n3 = 0;
            CharSequence charSequence = aSTNode.getChars();
            int n4 = CharArrayUtil.shiftBackwardUntil((CharSequence)charSequence, (int)(aSTNode.getTextLength() - 1), (String)"\r\n");
            if (n4 >= 0) {
                n3 += aSTNode.getTextLength() - n4 - 1;
            }
            char[] cArray = CharArrayUtil.fromSequence((CharSequence)charSequence, (int)(aSTNode.getTextLength() - n3), (int)aSTNode.getTextLength());
            this.myLeadingTabs = 0;
            boolean bl = cArray.length > 0 && cArray[0] == '\t';
            for (char c2 : cArray) {
                if (c2 == '\t' && bl) {
                    n2 += this.myIndentOptions.TAB_SIZE;
                    ++this.myLeadingTabs;
                    continue;
                }
                bl = false;
                ++n2;
            }
        }
        return n2;
    }

    private static /* synthetic */ void A(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canMerge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMergedWithPrevious";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLineDataFromComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAfterNonEmptyLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "countLineBreaks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockLineIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private class LineCommentLineData
    extends CommentLineData {
        private int indent;
        private boolean isFirst;

        LineCommentLineData(String line) {
            if (line == null) {
                LineCommentLineData.g(0);
            }
            super(line);
        }

        @Override
        public int getLineLength() {
            return this.indent + super.getLineLength();
        }

        @Override
        protected int calcWrapPos(int rightMargin) {
            if (this.indent < rightMargin) {
                return super.calcWrapPos(rightMargin - this.indent);
            }
            return -1;
        }

        public String getIndentString() {
            if (!LineCommentLineDataBuilder.this.myIndentOptions.USE_TAB_CHARACTER) {
                return StringUtil.repeatSymbol((char)' ', (int)this.indent);
            }
            int n2 = LineCommentLineDataBuilder.this.myIndentOptions.SMART_TABS ? LineCommentLineDataBuilder.this.myLeadingTabs : (LineCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE > 0 ? this.indent / LineCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE : 0);
            int n3 = this.indent - n2 * LineCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE;
            return StringUtil.repeatSymbol((char)'\t', (int)n2) + StringUtil.repeatSymbol((char)' ', (int)n3);
        }

        @Override
        @Nullable
        public Pair<String, String> splitLine(int rightMargin) {
            Pair<String, String> pair = super.splitLine(rightMargin);
            if (pair != null && !this.isFirst && this.indent > 0) {
                return Pair.create((Object)(this.getIndentString() + (String)pair.first), (Object)((String)pair.second));
            }
            return pair;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            String string = (this.indent > 0 ? this.getIndentString() : this.line.substring(0, this.commentOffset)) + LineCommentLineDataBuilder.LINE_COMMENT_PREFIX;
            if (string == null) {
                LineCommentLineData.g(1);
            }
            return string;
        }

        @Override
        protected int getTabSize() {
            return LineCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE;
        }

        @Override
        @NotNull
        public String getLine() {
            Object object = this.indent > 0 && !this.isFirst ? this.getIndentString() + this.line : this.line;
            if (object == null) {
                LineCommentLineData.g(2);
            }
            return object;
        }

        @Override
        public boolean canBeMergedWithPrevious() {
            return true;
        }

        private static /* synthetic */ void g(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLine";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

