/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSUndeclaredVariableInspection
extends JSInspection {
    public boolean myCheckGlobalDefinitions;

    @Nullable
    private static JSVarStatement findPreviousVarStatement(PsiElement anchor) {
        PsiElement prevSibling = anchor;
        while (prevSibling != null && !(prevSibling instanceof PsiFile)) {
            if ((prevSibling = prevSibling.getPrevSibling()) instanceof JSVarStatement) {
                return (JSVarStatement)prevSibling;
            }
            if (prevSibling != null) continue;
            prevSibling = anchor = anchor.getParent();
        }
        return null;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSUndeclaredVariableInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUndeclaredVariableInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSUndeclaredVariableInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                JSSourceElement element2;
                PsiElement parentElement;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((parentElement = node.getParent()) instanceof JSCallExpression) && node.shouldCheckReferences() && node.getQualifier() == null && parentElement instanceof JSDefinitionExpression && ((element2 = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSWithStatement.class, JSFunction.class, JSLoopStatement.class})) != null || JSUndeclaredVariableInspection.this.myCheckGlobalDefinitions) && !(element2 instanceof JSWithStatement)) {
                    PsiElement nameIdentifier;
                    ResolveResult[] resolveResults;
                    boolean varReferenceWithoutVar = true;
                    for (ResolveResult r : resolveResults = node.multiResolve(false)) {
                        PsiElement resolveResult = r.getElement();
                        if (resolveResult instanceof JSDefinitionExpression) continue;
                        varReferenceWithoutVar = false;
                        break;
                    }
                    if (varReferenceWithoutVar && (nameIdentifier = node.getReferenceNameElement()) != null) {
                        LinkedList<Object> fixes = new LinkedList<Object>();
                        if (JSUndeclaredVariableInspection.this.myOnTheFly) {
                            String prefix = JSChangeUtil.getVariablePrefix((PsiElement)holder.getFile());
                            fixes.add(new DeclareJSVariableIntentionAction(node.getReferenceName(), prefix));
                            PsiElement anchor = JSUtils.findStatementAnchor((PsiElement)node);
                            JSVarStatement varStatement = JSUndeclaredVariableInspection.findPreviousVarStatement(anchor);
                            if (varStatement != null) {
                                fixes.add(new DeclareJSVariableInPreviousVarStatementQuickFix(node.getReferenceName()));
                            }
                        }
                        holder.registerProblem(nameIdentifier, JavaScriptBundle.message("javascript.undeclared.variable.name.message", node.getReferenceName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, !fixes.isEmpty() ? fixes.toArray(LocalQuickFix.EMPTY_ARRAY) : null);
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$1", "visitJSReferenceExpression"));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myCheckGlobalDefinitions", (String)JavaScriptBundle.message("javascript.check.global.definitions", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSUndeclaredVariableInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    private static boolean isImplicitlyDeclared(JSReferenceExpression node, PsiElement parentElement) {
        if (parentElement instanceof JSForInStatement) {
            JSExpression varExpression = ((JSForInStatement)parentElement).getVariableExpression();
            if (varExpression == null) {
                return false;
            }
            return PsiTreeUtil.findCommonParent((PsiElement)varExpression, (PsiElement)node) == varExpression;
        }
        if (parentElement instanceof JSForStatement) {
            JSExpression varExpression = ((JSForStatement)parentElement).getInitialization();
            if (varExpression == null) {
                return false;
            }
            return PsiTreeUtil.findCommonParent((PsiElement)varExpression, (PsiElement)node) == varExpression;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static final class DeclareJSVariableInPreviousVarStatementQuickFix
    implements LocalQuickFix {
        private final String myVarName;

        private DeclareJSVariableInPreviousVarStatementQuickFix(String varName) {
            this.myVarName = varName;
        }

        @NotNull
        public String getName() {
            String string = JavaScriptBundle.message("javascript.declare.variable.in.previous.var.statement.intention.name", this.myVarName);
            if (string == null) {
                DeclareJSVariableInPreviousVarStatementQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("javascript.declare.variable.in.previous.var.statement.intention.family", new Object[0]);
            if (string == null) {
                DeclareJSVariableInPreviousVarStatementQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DeclareJSVariableInPreviousVarStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DeclareJSVariableInPreviousVarStatementQuickFix.$$$reportNull$$$0(3);
            }
            JSReferenceExpression referenceExpression = (JSReferenceExpression)descriptor.getPsiElement().getParent();
            PsiFile file = referenceExpression.getContainingFile();
            PsiElement anchor = JSUtils.findStatementAnchor((PsiElement)referenceExpression);
            JSVarStatement varStatement = JSUndeclaredVariableInspection.findPreviousVarStatement(anchor);
            if (varStatement == null) {
                return;
            }
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            boolean hasVars = !ArrayUtil.isEmpty((Object[])varStatement.getDeclarations());
            PsiElement lastChild = varStatement.getLastChild();
            int endOffset = lastChild != null && lastChild.getNode().getElementType() == JSTokenTypes.SEMICOLON ? lastChild.getPrevSibling().getTextRange().getEndOffset() : varStatement.getTextRange().getEndOffset();
            String declaration = (hasVars ? ", " : " ") + referenceExpression.getReferenceName();
            document.insertString(endOffset, (CharSequence)declaration);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).reformatText(file, varStatement.getTextRange().getStartOffset(), varStatement.getTextRange().getStartOffset() + declaration.length());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableInPreviousVarStatementQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableInPreviousVarStatementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DeclareJSVariableIntentionAction
    implements LocalQuickFix {
        private final String myVarName;
        private final String myPrefix;

        DeclareJSVariableIntentionAction(String varName, String prefix) {
            this.myVarName = varName;
            this.myPrefix = prefix;
        }

        @NotNull
        public String getName() {
            String string = JavaScriptBundle.message("javascript.declare.variable.intention.name", this.myPrefix, this.myVarName);
            if (string == null) {
                DeclareJSVariableIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("javascript.declare.variable.intention.family.name", new Object[0]);
            if (string == null) {
                DeclareJSVariableIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            JSExpression initialization;
            JSStatement statement;
            if (project == null) {
                DeclareJSVariableIntentionAction.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DeclareJSVariableIntentionAction.$$$reportNull$$$0(3);
            }
            JSReferenceExpression referenceExpression = (JSReferenceExpression)descriptor.getPsiElement().getParent();
            PsiFile file = referenceExpression.getContainingFile();
            Object anchor = JSUtils.findStatementAnchor((PsiElement)referenceExpression);
            boolean implicitlyDeclared = JSUndeclaredVariableInspection.isImplicitlyDeclared(referenceExpression, anchor);
            if (implicitlyDeclared && (statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)(anchor = referenceExpression), (Class[])new Class[]{JSForStatement.class, JSStatement.class})) instanceof JSForStatement && (initialization = ((JSForStatement)statement).getInitialization()) instanceof JSBinaryExpression && ((JSBinaryExpression)initialization).getOperationSign() == JSTokenTypes.COMMA) {
                JSExpression lOperand = ((JSBinaryExpression)initialization).getLOperand();
                JSExpression jSExpression = anchor = lOperand instanceof JSAssignmentExpression ? ((JSAssignmentExpression)lOperand).getLOperand() : null;
            }
            if (anchor != null) {
                Document document;
                JSExpression expr;
                boolean anchorChanged = false;
                if (!implicitlyDeclared) {
                    PsiElement parent = anchor.getParent();
                    while (parent instanceof JSBlockStatement || parent instanceof JSIfStatement || parent instanceof JSLoopStatement) {
                        PsiElement newAnchor = parent.getParent();
                        if (newAnchor instanceof JSIfStatement || newAnchor instanceof JSWithStatement || newAnchor instanceof JSLoopStatement || newAnchor instanceof JSTryStatement || newAnchor instanceof JSSwitchStatement) {
                            anchor = newAnchor;
                            parent = anchor.getParent();
                            anchorChanged = true;
                            continue;
                        }
                        if (!(newAnchor instanceof JSFile)) break;
                        anchor = parent;
                        anchorChanged = true;
                        break;
                    }
                }
                TextRange textRange = anchor.getTextRange();
                int startOffset = textRange.getStartOffset();
                @NonNls StringBuilder builder2 = new StringBuilder();
                builder2.append(this.myPrefix);
                builder2.append(" ");
                if (anchor instanceof JSExpressionStatement && (expr = ((JSExpressionStatement)anchor).getExpression()) instanceof JSAssignmentExpression && ((JSAssignmentExpression)expr).getOperationSign() != JSTokenTypes.EQ) {
                    anchorChanged = true;
                }
                if (!(!anchorChanged && anchor instanceof JSExpressionStatement || implicitlyDeclared)) {
                    builder2.append(referenceExpression.getReferenceName()).append(";\n");
                }
                if ((document = file.getViewProvider().getDocument()) == null) {
                    return;
                }
                document.replaceString(startOffset, startOffset, (CharSequence)builder2);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                CodeStyleManager.getInstance((Project)project).reformatText(file, startOffset, textRange.getEndOffset() + builder2.length());
                if (file.canNavigate()) {
                    file.navigate(true);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableIntentionAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUndeclaredVariableInspection$DeclareJSVariableIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

