/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.ECMAL4LanguageDialect;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class FlexSupportLoader {
    public static final JSLanguageDialect ECMA_SCRIPT_L4 = ECMAL4LanguageDialect.getInstance();
    @NonNls
    public static final String ECMA_SCRIPT_L4_FILE_EXTENSION = "as";
    @NonNls
    public static final String ECMA_SCRIPT_L4_FILE_EXTENSION2 = "js2";
    @NonNls
    public static final String ECMA_SCRIPT_L4_FILE_EXTENSION3 = "es";
    @NonNls
    public static final String FXG_FILE_EXTENSION = "fxg";
    @NonNls
    public static final String FXG_FILE_EXTENSION_DOT = ".fxg";
    @NonNls
    public static final String MXML_FILE_EXTENSION = "mxml";
    @NonNls
    public static final String MXML_FILE_EXTENSION_DOT = ".mxml";
    @NonNls
    public static final String MXML_URI = "http://www.adobe.com/2006/mxml";
    @NonNls
    public static final String MXML_URI3 = "http://ns.adobe.com/mxml/2009";
    @NonNls
    public static final String[] LANGUAGE_NAMESPACES = new String[]{"http://www.adobe.com/2006/mxml", "http://ns.adobe.com/mxml/2009"};

    public static FileType getMxmlFileType() {
        return MxmlFileTypeHolder.mxmlFileType;
    }

    public static boolean isFlexMxmFile(@NotNull PsiFile file) {
        if (file == null) {
            FlexSupportLoader.$$$reportNull$$$0(0);
        }
        return FlexSupportLoader.isFlexMxmFile(file.getViewProvider().getVirtualFile());
    }

    public static boolean isFlexMxmFile(@NotNull VirtualFile file) {
        if (file == null) {
            FlexSupportLoader.$$$reportNull$$$0(1);
        }
        return FlexSupportLoader.isMxmlFileType(file) && FlexSupportLoader.nameHasMxmlExtension(file.getName());
    }

    public static boolean isMxmlOrFxgFile(@NotNull PsiFile file) {
        if (file == null) {
            FlexSupportLoader.$$$reportNull$$$0(2);
        }
        return FlexSupportLoader.isMxmlOrFxgFile(file.getViewProvider().getVirtualFile());
    }

    public static boolean isMxmlOrFxgFile(@NotNull VirtualFile file) {
        if (file == null) {
            FlexSupportLoader.$$$reportNull$$$0(3);
        }
        return FlexSupportLoader.isMxmlFileType(file) && (FlexSupportLoader.nameHasMxmlExtension(file.getName()) || StringUtil.toLowerCase((String)file.getName()).endsWith(FXG_FILE_EXTENSION_DOT));
    }

    public static boolean isFxgFile(@NotNull VirtualFile file) {
        if (file == null) {
            FlexSupportLoader.$$$reportNull$$$0(4);
        }
        return FlexSupportLoader.isMxmlFileType(file) && StringUtil.toLowerCase((String)file.getName()).endsWith(FXG_FILE_EXTENSION_DOT);
    }

    private static boolean isMxmlFileType(@NotNull VirtualFile file) {
        FileType mxmlFileType;
        if (file == null) {
            FlexSupportLoader.$$$reportNull$$$0(5);
        }
        return (mxmlFileType = MxmlFileTypeHolder.mxmlFileType) != null && FileTypeRegistry.getInstance().isFileOfType(file, mxmlFileType);
    }

    private static boolean nameHasMxmlExtension(@NotNull String fileName) {
        if (fileName == null) {
            FlexSupportLoader.$$$reportNull$$$0(6);
        }
        String lowercaseName = StringUtil.toLowerCase((String)fileName);
        return lowercaseName.endsWith(MXML_FILE_EXTENSION_DOT);
    }

    public static boolean isFlexMxmFile(@NotNull String filename) {
        FileType fileType;
        if (filename == null) {
            FlexSupportLoader.$$$reportNull$$$0(7);
        }
        return (fileType = MxmlFileTypeHolder.mxmlFileType) != null && FileTypeRegistry.getInstance().getFileTypeByFileName(filename) == fileType && FlexSupportLoader.nameHasMxmlExtension(filename);
    }

    public static boolean isLanguageNamespace(String namespace) {
        return ArrayUtil.contains((String)namespace, (String[])LANGUAGE_NAMESPACES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/FlexSupportLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFlexMxmFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMxmlOrFxgFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFxgFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isMxmlFileType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "nameHasMxmlExtension";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MxmlFileTypeHolder {
        private static final FileType mxmlFileType;

        MxmlFileTypeHolder() {
        }

        static {
            FileType mxmlFileTypeL = FileTypeRegistry.getInstance().getFileTypeByExtension(FlexSupportLoader.MXML_FILE_EXTENSION);
            if (mxmlFileTypeL == UnknownFileType.INSTANCE) {
                mxmlFileTypeL = null;
            }
            mxmlFileType = mxmlFileTypeL;
        }
    }
}

