/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.utils;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class DockerDeleteConfirmation {
    @NlsContexts.DialogMessage
    @NotNull
    @Nls
    private static String getUserConfirmationText(int images2, int containers2) {
        if (images2 < 0 || containers2 < 0 || images2 + containers2 == 0) {
            throw new IllegalArgumentException("Request for deletion: Images: " + images2 + ", containers: " + containers2);
        }
        String imagesPiece = null;
        if (images2 > 0) {
            imagesPiece = images2 == 1 ? DockerBundle.message((String)"DockerDeleteProvider.confirmation.image.one", (Object[])new Object[0]) : DockerBundle.message((String)"DockerDeleteProvider.confirmation.image.many", (Object[])new Object[]{images2});
        }
        String containersPiece = null;
        if (containers2 > 0) {
            String string = containersPiece = containers2 == 1 ? DockerBundle.message((String)"DockerDeleteProvider.confirmation.container.one", (Object[])new Object[0]) : DockerBundle.message((String)"DockerDeleteProvider.confirmation.container.many", (Object[])new Object[]{containers2});
        }
        String string = containersPiece != null && imagesPiece != null ? DockerBundle.message((String)"DockerDeleteProvider.confirmation.text.both.types", (Object[])new Object[]{containersPiece, imagesPiece}) : DockerBundle.message((String)"DockerDeleteProvider.confirmation.text.single.type", (Object[])new Object[]{containersPiece != null ? containersPiece : imagesPiece});
        if (string == null) {
            DockerDeleteConfirmation.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static boolean getUserConfirmation(int unspecifiedItems) {
        @NlsContexts.DialogMessage String message = unspecifiedItems == 1 ? DockerBundle.message((String)"DockerDeleteProvider.confirmation.text.unspecified.type.one", (Object[])new Object[0]) : DockerBundle.message((String)"DockerDeleteProvider.confirmation.text.unspecified.type.many", (Object[])new Object[]{unspecifiedItems});
        return DockerDeleteConfirmation.getUserConfirmation(message);
    }

    public static boolean getUserConfirmation(int images2, int containers2) {
        return DockerDeleteConfirmation.getUserConfirmation(DockerDeleteConfirmation.getUserConfirmationText(images2, containers2));
    }

    public static boolean getUserConfirmation(@NlsContexts.DialogMessage String message) {
        int yesNo = Messages.showYesNoDialog((Project)null, (String)message, (String)DockerBundle.message((String)"DockerDeleteProvider.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        return yesNo == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/ui/utils/DockerDeleteConfirmation", "getUserConfirmationText"));
    }
}

