/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.SpecializationStatistics;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotThread;
import com.oracle.truffle.polyglot.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

final class PolyglotThreadInfo {
    static final PolyglotThreadInfo NULL = new PolyglotThreadInfo(null, null, false);
    private static final Object NULL_CLASS_LOADER = new Object();
    final PolyglotContextImpl context;
    @CompilerDirectives.CompilationFinal
    private final TruffleWeakReference<Thread> thread;
    final PolyglotContextImpl polyglotThreadOwnerContext;
    private volatile int enteredCount;
    private volatile TruffleSafepoint.Interrupter leaveAndEnterInterrupter;
    final LinkedList<Object[]> explicitContextStack = new LinkedList();
    volatile boolean cancelled;
    volatile boolean leaveAndEnterInterrupted;
    private Object originalContextClassLoader = NULL_CLASS_LOADER;
    private ClassLoaderEntry prevContextClassLoader;
    private SpecializationStatisticsEntry executionStatisticsEntry;
    private boolean safepointActive;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    Object[] contextThreadLocals;
    final Object[] fastThreadLocals;
    final EncapsulatingNodeReference encapsulatingNodeReference;
    private final BitSet initializedLanguageContexts;
    private boolean finalizationComplete;
    private final List<ProbeNode> probesEnterList;
    private static final boolean ASSERT_ENTER_RETURN_PARITY;

    PolyglotThreadInfo(PolyglotContextImpl context, Thread thread, boolean polyglotThreadFirstEnter) {
        this.context = context;
        this.thread = new TruffleWeakReference<Thread>(thread);
        if (thread instanceof PolyglotThread) {
            assert (!polyglotThreadFirstEnter || ((PolyglotThread)thread).getOwnerContext() == context);
            this.polyglotThreadOwnerContext = ((PolyglotThread)thread).getOwnerContext();
        } else {
            this.polyglotThreadOwnerContext = polyglotThreadFirstEnter ? context : null;
        }
        if (context == null) {
            this.encapsulatingNodeReference = null;
            this.fastThreadLocals = null;
        } else {
            this.encapsulatingNodeReference = EngineAccessor.NODES.createEncapsulatingNodeReference(thread);
            this.fastThreadLocals = PolyglotFastThreadLocals.createFastThreadLocals(this);
        }
        this.initializedLanguageContexts = context != null ? new BitSet(context.contexts.length) : null;
        this.probesEnterList = PolyglotThreadInfo.initProbesEnterList(context);
    }

    private static List<ProbeNode> initProbesEnterList(PolyglotContextImpl context) {
        boolean assertProbes;
        boolean bl = assertProbes = context != null && context.engine.probeAssertionsEnabled;
        if (assertProbes) {
            return new ArrayList<ProbeNode>();
        }
        return null;
    }

    Thread getThread() {
        return (Thread)this.thread.get();
    }

    boolean isLanguageContextInitialized(PolyglotLanguage language) {
        assert (Thread.holdsLock(this.context));
        return this.initializedLanguageContexts.get(language.engineIndex);
    }

    void initializeLanguageContext(PolyglotLanguageContext languageContext) {
        assert (Thread.holdsLock(this.context));
        assert (!this.finalizationComplete);
        EngineAccessor.LANGUAGE.initializeThread(languageContext.env, this.getThread());
        this.initializedLanguageContexts.set(languageContext.language.engineIndex);
    }

    void clearLanguageContextInitialized(PolyglotLanguage language) {
        assert (Thread.holdsLock(this.context));
        this.initializedLanguageContexts.clear(language.engineIndex);
    }

    int initializedLanguageContextsCount() {
        assert (Thread.holdsLock(this.context));
        return this.initializedLanguageContexts.cardinality();
    }

    boolean isFinalizationComplete() {
        assert (Thread.holdsLock(this.context));
        return this.finalizationComplete;
    }

    void setFinalizationComplete(PolyglotEngineImpl engine, boolean mustSucceed) {
        assert (Thread.holdsLock(this.context));
        this.finalizationComplete = true;
        if (ASSERT_ENTER_RETURN_PARITY && !mustSucceed && engine.probeAssertionsEnabled) {
            this.assertProbeThreadFinalized();
        }
    }

    boolean isSafepointActive() {
        assert (this.isCurrent());
        return this.safepointActive;
    }

    void setSafepointActive(boolean safepointActive) {
        assert (this.isCurrent());
        this.safepointActive = safepointActive;
    }

    public Object[] getContextThreadLocals() {
        assert (Thread.holdsLock(this.context));
        return this.contextThreadLocals;
    }

    public void setContextThreadLocals(Object[] contextThreadLocals) {
        assert (Thread.holdsLock(this.context));
        this.contextThreadLocals = contextThreadLocals;
        this.fastThreadLocals[1] = contextThreadLocals;
    }

    boolean isCurrent() {
        return this.getThread() == Thread.currentThread();
    }

    TruffleSafepoint.Interrupter getLeaveAndEnterInterrupter() {
        return this.leaveAndEnterInterrupter;
    }

    boolean isInLeaveAndEnter() {
        return this.leaveAndEnterInterrupter != null;
    }

    void setLeaveAndEnterInterrupter(TruffleSafepoint.Interrupter interrupter) {
        this.leaveAndEnterInterrupter = interrupter;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
    Object[] enterInternal() {
        Object[] prev = PolyglotFastThreadLocals.enter(this);
        assert (Thread.currentThread() == this.getThread()) : "Volatile increment is safe on a single thread only.";
        ++this.enteredCount;
        return prev;
    }

    int getEnteredCount() {
        assert (Thread.currentThread() == this.thread.get());
        return this.enteredCount;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
    void leaveInternal(Object[] prev) {
        assert (Thread.currentThread() == this.getThread()) : "Volatile decrement is safe on a single thread only.";
        --this.enteredCount;
        PolyglotFastThreadLocals.leave(prev);
    }

    void notifyEnter(PolyglotEngineImpl engine, PolyglotContextImpl profiledContext) {
        if (!engine.customHostClassLoader.isValid()) {
            this.setContextClassLoader();
        }
        EngineAccessor.INSTRUMENT.notifyEnter(engine.instrumentationHandler, profiledContext.creatorTruffleContext);
        if (engine.specializationStatistics != null) {
            this.enterStatistics(engine.specializationStatistics);
        }
    }

    boolean isPolyglotThread(PolyglotContextImpl c) {
        return this.polyglotThreadOwnerContext == c;
    }

    void notifyLeave(PolyglotEngineImpl engine, PolyglotContextImpl profiledContext) {
        assert (Thread.currentThread() == this.getThread());
        try {
            EngineAccessor.INSTRUMENT.notifyLeave(engine.instrumentationHandler, profiledContext.creatorTruffleContext);
        }
        finally {
            if (!engine.customHostClassLoader.isValid()) {
                this.restoreContextClassLoader();
            }
            if (engine.specializationStatistics != null) {
                this.leaveStatistics(engine.specializationStatistics);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void assertProbeThreadFinalized() {
        if (this.probesEnterList != null) assert (this.probesEnterList.isEmpty()) : PolyglotThreadInfo.getEnteredProbesMessage(this.probesEnterList);
    }

    private static String getEnteredProbesMessage(List<ProbeNode> probes) {
        StringBuilder sb = new StringBuilder("Found entered probes without return: ");
        sb.append(probes);
        sb.append("\nSpecifically, a call to ProbeNode.onEnter()/onResume() does not have a corresponding call to ProbeNode.onReturnValue()/onReturnExceptionalOrUnwind()/onYield().");
        for (ProbeNode probe : probes) {
            sb.append("\n  probe ");
            sb.append(probe);
            sb.append(" with parent node ");
            sb.append(probe.getParent().getClass());
        }
        sb.append('\n');
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary
    void assertProbeEntered(ProbeNode probe) {
        Objects.requireNonNull(probe);
        this.probesEnterList.add(probe);
    }

    @CompilerDirectives.TruffleBoundary
    void assertProbeReturned(ProbeNode probe) {
        assert (!this.probesEnterList.isEmpty()) : "ProbeNode " + String.valueOf(probe) + " with parent " + String.valueOf(probe.getParent().getClass()) + " exited without enter";
        ProbeNode lastProbe = this.probesEnterList.remove(this.probesEnterList.size() - 1);
        assert (probe == lastProbe) : "Entered probe " + String.valueOf(lastProbe) + " with parent " + String.valueOf(lastProbe.getParent().getClass()) + " differs from the returned probe " + String.valueOf(probe) + " with parent " + String.valueOf(probe.getParent().getClass()) + "\nSpecifically, a call to onEnter()/onResume() on " + String.valueOf(lastProbe) + " was not followed by a call to onReturnValue()/onReturnExceptionalOrUnwind()/onYield() on the same probe, but on " + String.valueOf(probe) + " instead.";
    }

    Object[] getThreadLocals(PolyglotEngineImpl e) {
        CompilerAsserts.partialEvaluationConstant(e);
        Object[] locals = this.contextThreadLocals;
        assert (locals != null) : "thread local not initialized.";
        if (CompilerDirectives.inCompiledCode()) {
            locals = EngineAccessor.RUNTIME.unsafeCast(locals, Object[].class, true, true, true);
        }
        return locals;
    }

    @CompilerDirectives.TruffleBoundary
    private void enterStatistics(SpecializationStatistics statistics) {
        SpecializationStatistics prev = statistics.enter();
        if (prev != null || this.executionStatisticsEntry != null) {
            this.executionStatisticsEntry = new SpecializationStatisticsEntry(prev, this.executionStatisticsEntry);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void leaveStatistics(SpecializationStatistics statistics) {
        SpecializationStatisticsEntry entry = this.executionStatisticsEntry;
        if (entry == null) {
            statistics.leave(null);
        } else {
            statistics.leave(entry.statistics);
            this.executionStatisticsEntry = entry.next;
        }
    }

    boolean isActiveNotCancelled() {
        return this.getThread() != null && this.enteredCount > 0 && !this.cancelled;
    }

    boolean isActive() {
        return this.getThread() != null && this.enteredCount > 0;
    }

    public String toString() {
        return super.toString() + "[thread=" + String.valueOf(this.getThread()) + ", enteredCount=" + this.enteredCount + ", cancelled=" + this.cancelled + ", leaveAndEnterInterrupted=" + this.leaveAndEnterInterrupted + "]";
    }

    @CompilerDirectives.TruffleBoundary
    private void setContextClassLoader() {
        ClassLoader hostClassLoader = this.context.config.hostClassLoader;
        if (hostClassLoader != null) {
            Thread t = this.getThread();
            ClassLoader original = t.getContextClassLoader();
            assert (this.originalContextClassLoader != NULL_CLASS_LOADER || this.prevContextClassLoader == null);
            if (this.originalContextClassLoader != NULL_CLASS_LOADER) {
                this.prevContextClassLoader = new ClassLoaderEntry((ClassLoader)this.originalContextClassLoader, this.prevContextClassLoader);
            }
            this.originalContextClassLoader = original;
            t.setContextClassLoader(hostClassLoader);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void restoreContextClassLoader() {
        if (this.originalContextClassLoader != NULL_CLASS_LOADER) {
            assert (this.context.config.hostClassLoader != null);
            Thread t = this.getThread();
            t.setContextClassLoader((ClassLoader)this.originalContextClassLoader);
            if (this.prevContextClassLoader != null) {
                this.originalContextClassLoader = this.prevContextClassLoader.classLoader;
                this.prevContextClassLoader = this.prevContextClassLoader.next;
            } else {
                this.originalContextClassLoader = NULL_CLASS_LOADER;
            }
        }
    }

    static {
        boolean assertsOn = false;
        if (!$assertionsDisabled) {
            assertsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT_ENTER_RETURN_PARITY = assertsOn;
    }

    private static final class SpecializationStatisticsEntry {
        final SpecializationStatistics statistics;
        final SpecializationStatisticsEntry next;

        SpecializationStatisticsEntry(SpecializationStatistics statistics, SpecializationStatisticsEntry next) {
            this.statistics = statistics;
            this.next = next;
        }
    }

    private static final class ClassLoaderEntry {
        final ClassLoader classLoader;
        final ClassLoaderEntry next;

        ClassLoaderEntry(ClassLoader classLoader, ClassLoaderEntry next) {
            this.classLoader = classLoader;
            this.next = next;
        }
    }
}

