/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.js.runtime.JSLanguageOptions;

public record JSParserOptions(boolean strict, boolean scripting, boolean shebang, int ecmaScriptVersion, boolean syntaxExtensions, boolean constAsVar, boolean functionStatementError, boolean dumpOnError, boolean emptyStatements, boolean annexB, boolean allowBigInt, boolean classFields, boolean importAttributes, boolean privateFieldsIn, boolean topLevelAwait, boolean v8Intrinsics) {
    public static JSParserOptions fromLanguageOptions(JSLanguageOptions options) {
        int ecmaScriptVersion = options.ecmaScriptVersion();
        boolean strict = options.strict();
        boolean scripting = options.scripting();
        boolean shebang = options.shebang();
        boolean syntaxExtensions = options.syntaxExtensions();
        boolean constAsVar = options.constAsVar();
        boolean functionStatementError = options.functionStatementError();
        boolean dumpOnError = false;
        boolean emptyStatements = false;
        boolean annexB = options.annexB();
        boolean allowBigInt = options.bigInt();
        boolean classFields = options.classFields();
        boolean importAttributes = options.importAttributes();
        boolean privateFieldsIn = options.privateFieldsIn();
        boolean topLevelAwait = options.topLevelAwait();
        boolean v8Intrinsics = options.v8Intrinsics();
        return new JSParserOptions(strict, scripting, shebang, ecmaScriptVersion, syntaxExtensions, constAsVar, functionStatementError, dumpOnError, emptyStatements, annexB, allowBigInt, classFields, importAttributes, privateFieldsIn, topLevelAwait, v8Intrinsics);
    }

    public JSParserOptions withStrict(boolean strict) {
        if (strict != this.strict) {
            return new JSParserOptions(strict, this.scripting, this.shebang, this.ecmaScriptVersion, this.syntaxExtensions, this.constAsVar, this.functionStatementError, this.dumpOnError, this.emptyStatements, this.annexB, this.allowBigInt, this.classFields, this.importAttributes, this.privateFieldsIn, this.topLevelAwait, this.v8Intrinsics);
        }
        return this;
    }
}

