/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.impl.ColumnAccessTracker;
import org.jetbrains.kotlinx.dataframe.io.StringKt;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0096\u0002J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0004H\u0096\u0002J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\"\u0010\u0012\u001a\u0002H\u0016\"\u0004\b\u0001\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J#\u0010\u001b\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0001\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/DataRowImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "index", "", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "(ILorg/jetbrains/kotlinx/dataframe/DataFrame;)V", "values", "", "", "getValues", "()Ljava/util/List;", "values$delegate", "Lkotlin/Lazy;", "equals", "", "other", "get", "columnIndex", "name", "", "R", "column", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;)Ljava/lang/Object;", "getOrNull", "getValueOrNull", "hashCode", "toString", "core"})
public class DataRowImpl<T>
implements DataRow<T> {
    private final int index;
    @NotNull
    private final DataFrame<T> df;
    @NotNull
    private final Lazy values$delegate;

    public DataRowImpl(int index, @NotNull DataFrame<? extends T> df2) {
        Intrinsics.checkNotNullParameter(df2, (String)"df");
        this.index = index;
        this.df = df2;
        this.values$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Object>>(this){
            final /* synthetic */ DataRowImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Object> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = DataRowImpl.access$getDf$p(this.this$0).columns();
                DataRowImpl<T> dataRowImpl = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DataColumn dataColumn = (DataColumn)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.get(DataRowImpl.access$getIndex$p(dataRowImpl)));
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @Override
    @NotNull
    public DataFrame<T> df() {
        return this.df;
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ColumnAccessTracker.Companion.registerColumnAccess(name);
        return this.df.get(name).get(this.index);
    }

    @Override
    public <R> R get(@NotNull ColumnReference<? extends R> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        ColumnAccessTracker.Companion.registerColumnAccess(column2.name());
        return column2.getValue(this);
    }

    @Override
    @Nullable
    public <R> R getValueOrNull(@NotNull ColumnReference<? extends R> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        ColumnAccessTracker.Companion.registerColumnAccess(column2.name());
        return column2.getValueOrNull(this);
    }

    @Override
    public int index() {
        return this.index;
    }

    private final List<Object> getValues() {
        Lazy lazy = this.values$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public List<Object> values() {
        return this.getValues();
    }

    @Override
    @Nullable
    public Object get(int columnIndex) {
        DataColumn<?> column2 = DataFrameGetKt.getColumn((ColumnsContainer)this.df, columnIndex);
        ColumnAccessTracker.Companion.registerColumnAccess(column2.name());
        return column2.get(this.index);
    }

    @NotNull
    public String toString() {
        return StringKt.renderToString(this);
    }

    public boolean equals(@Nullable Object other) {
        DataRowImpl dataRowImpl = other instanceof DataRowImpl ? (DataRowImpl)other : null;
        if (dataRowImpl == null) {
            return false;
        }
        DataRowImpl o = dataRowImpl;
        return ((Object)this.getValues()).equals(o.getValues());
    }

    public int hashCode() {
        return ((Object)this.getValues()).hashCode();
    }

    @Override
    @Nullable
    public Object getOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ColumnAccessTracker.Companion.registerColumnAccess(name);
        DataColumn<?> dataColumn = this.df.getColumnOrNull(name);
        return dataColumn != null ? dataColumn.get(this.index) : null;
    }

    @Override
    public <R> R get(@NotNull Function2<? super DataRow<? extends T>, ? super DataRow<? extends T>, ? extends R> expression) {
        return DataRow.DefaultImpls.get(this, expression);
    }

    @Override
    @NotNull
    public <R> List<R> get(@NotNull List<? extends ColumnReference<? extends R>> columns2) {
        return DataRow.DefaultImpls.get(this, columns2);
    }

    @Override
    public <R> R get(@NotNull KProperty<? extends R> property) {
        return DataRow.DefaultImpls.get(this, property);
    }

    @Override
    @NotNull
    public DataRow<T> get(@NotNull ColumnReference<?> first2, ColumnReference<?> ... other) {
        return DataRow.DefaultImpls.get(this, first2, other);
    }

    @Override
    @NotNull
    public DataRow<T> get(@NotNull String first2, String ... other) {
        return DataRow.DefaultImpls.get(this, first2, other);
    }

    @Override
    @Nullable
    public Object get(@NotNull ColumnPath path) {
        return DataRow.DefaultImpls.get(this, path);
    }

    @Override
    @NotNull
    public ColumnPath get(@NotNull String $this$get, String ... path) {
        return DataRow.DefaultImpls.get(this, $this$get, path);
    }

    @Override
    @NotNull
    public DataRow<?> getColumnGroup(@NotNull String columnName) {
        return DataRow.DefaultImpls.getColumnGroup(this, columnName);
    }

    @Override
    public <R> R invoke(@NotNull ColumnReference<? extends R> $this$invoke) {
        return DataRow.DefaultImpls.invoke(this, $this$invoke);
    }

    @Override
    public <R> R invoke(@NotNull String $this$invoke) {
        return DataRow.DefaultImpls.invoke(this, $this$invoke);
    }

    @Override
    public <R> R invoke(@NotNull ColumnPath $this$invoke) {
        return DataRow.DefaultImpls.invoke(this, $this$invoke);
    }

    @Override
    @NotNull
    public Iterable<DataRow<T>> forwardIterable() {
        return DataRow.DefaultImpls.forwardIterable(this);
    }

    @Override
    @NotNull
    public Iterable<DataRow<T>> backwardIterable() {
        return DataRow.DefaultImpls.backwardIterable(this);
    }

    @Override
    public <R extends Comparable<? super R>> int compareTo(@NotNull ColumnReference<? extends R> $this$compareTo, @NotNull R other) {
        return DataRow.DefaultImpls.compareTo(this, $this$compareTo, other);
    }

    @Override
    public int plus(@NotNull ColumnReference<Integer> $this$plus, int a) {
        return DataRow.DefaultImpls.plus(this, $this$plus, a);
    }

    @Override
    public long plus(@NotNull ColumnReference<Long> $this$plus, long a) {
        return DataRow.DefaultImpls.plus(this, $this$plus, a);
    }

    @Override
    public double plus(@NotNull ColumnReference<Double> $this$plus, double a) {
        return DataRow.DefaultImpls.plus(this, $this$plus, a);
    }

    @Override
    @NotNull
    public String plus(@NotNull ColumnReference<String> $this$plus, @NotNull String a) {
        return DataRow.DefaultImpls.plus(this, $this$plus, a);
    }

    @Override
    public int plus(int $this$plus, @NotNull ColumnReference<Integer> col2) {
        return DataRow.DefaultImpls.plus(this, $this$plus, col2);
    }

    @Override
    public long plus(long $this$plus, @NotNull ColumnReference<Long> col2) {
        return DataRow.DefaultImpls.plus(this, $this$plus, col2);
    }

    @Override
    public double plus(double $this$plus, @NotNull ColumnReference<Double> col2) {
        return DataRow.DefaultImpls.plus(this, $this$plus, col2);
    }

    @Override
    public int minus(@NotNull ColumnReference<Integer> $this$minus, int a) {
        return DataRow.DefaultImpls.minus(this, $this$minus, a);
    }

    @Override
    public long minus(@NotNull ColumnReference<Long> $this$minus, long a) {
        return DataRow.DefaultImpls.minus(this, $this$minus, a);
    }

    @Override
    public double minus(@NotNull ColumnReference<Double> $this$minus, double a) {
        return DataRow.DefaultImpls.minus(this, $this$minus, a);
    }

    @Override
    public int minus(int $this$minus, @NotNull ColumnReference<Integer> col2) {
        return DataRow.DefaultImpls.minus(this, $this$minus, col2);
    }

    @Override
    public long minus(long $this$minus, @NotNull ColumnReference<Long> col2) {
        return DataRow.DefaultImpls.minus(this, $this$minus, col2);
    }

    @Override
    public double minus(double $this$minus, @NotNull ColumnReference<Double> col2) {
        return DataRow.DefaultImpls.minus(this, $this$minus, col2);
    }

    @Override
    public int times(@NotNull ColumnReference<Integer> $this$times, int a) {
        return DataRow.DefaultImpls.times(this, $this$times, a);
    }

    @Override
    public long times(@NotNull ColumnReference<Long> $this$times, long a) {
        return DataRow.DefaultImpls.times(this, $this$times, a);
    }

    @Override
    public double times(@NotNull ColumnReference<Double> $this$times, double a) {
        return DataRow.DefaultImpls.times(this, $this$times, a);
    }

    @Override
    public double times(@NotNull ColumnReference<Double> $this$times, int a) {
        return DataRow.DefaultImpls.times(this, $this$times, a);
    }

    @Override
    public long times(@NotNull ColumnReference<Long> $this$times, int a) {
        return DataRow.DefaultImpls.times(this, $this$times, a);
    }

    @Override
    public double times(@NotNull ColumnReference<Double> $this$times, long a) {
        return DataRow.DefaultImpls.times(this, $this$times, a);
    }

    @Override
    public int div(@NotNull ColumnReference<Integer> $this$div, int a) {
        return DataRow.DefaultImpls.div(this, $this$div, a);
    }

    @Override
    public long div(@NotNull ColumnReference<Long> $this$div, long a) {
        return DataRow.DefaultImpls.div(this, $this$div, a);
    }

    @Override
    public double div(@NotNull ColumnReference<Double> $this$div, double a) {
        return DataRow.DefaultImpls.div(this, $this$div, a);
    }

    @Override
    public double div(@NotNull ColumnReference<Double> $this$div, int a) {
        return DataRow.DefaultImpls.div(this, $this$div, a);
    }

    @Override
    public long div(@NotNull ColumnReference<Long> $this$div, int a) {
        return DataRow.DefaultImpls.div(this, $this$div, a);
    }

    @Override
    public double div(@NotNull ColumnReference<Double> $this$div, long a) {
        return DataRow.DefaultImpls.div(this, $this$div, a);
    }

    public static final /* synthetic */ DataFrame access$getDf$p(DataRowImpl $this) {
        return $this.df;
    }

    public static final /* synthetic */ int access$getIndex$p(DataRowImpl $this) {
        return $this.index;
    }
}

