/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.aggregation.AggregateGroupedDsl;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnReferenceApiKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumnKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.exceptions.DuplicateColumnNamesException;
import org.jetbrains.kotlinx.dataframe.exceptions.UnequalColumnSizesException;
import org.jetbrains.kotlinx.dataframe.impl.ColumnNameGenerator;
import org.jetbrains.kotlinx.dataframe.impl.DataFrameImpl;
import org.jetbrains.kotlinx.dataframe.impl.DataRowImpl;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.AggregatableInternal;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.GroupByReceiverImpl;
import org.jetbrains.kotlinx.dataframe.io.StringKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ^\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\"\u0004\b\u0001\u0010\u00152H\u0010\u0016\u001aD\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0018\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u0002H\u00150\u0017j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u0015`\u001c\u00a2\u0006\u0002\b\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0005H\u0016J\u0016\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u00070\u0005H\u0016J\b\u0010!\u001a\u00020\tH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0013\u0010&\u001a\u00020#2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010*\u001a\u00020\tH\u0096\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0016\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010*\u001a\u00020\tH\u0016J\u001c\u0010,\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J$\u0010,\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010\u0006\"\u0004\b\u0001\u0010\u00152\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00150.H\u0016Jf\u0010,\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010\u0006\"\u0004\b\u0001\u0010\u00152N\u0010-\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000/\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000/\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u0015000\u0017j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u0015`1\u00a2\u0006\u0002\b\u001dH\u0016J\u001c\u0010,\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u0006\u0010$\u001a\u00020%H\u0016J$\u0010,\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010\u0006\"\u0004\b\u0001\u0010\u00152\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001502H\u0016J\b\u00103\u001a\u00020\tH\u0016JF\u00104\u001a@\u0012\b\u0012\u0006\u0012\u0002\b\u00030/\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030/\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u0003050\u0017j\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003`6\u00a2\u0006\u0002\b\u001dH\u0016J\b\u00107\u001a\u00020\tH\u0016J\b\u00108\u001a\u00020\u0010H\u0016R\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/DataFrameImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/AggregatableInternal;", "cols", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "nrow", "", "(Ljava/util/List;I)V", "columns", "getColumns", "()Ljava/util/List;", "columnsMap", "", "", "getNrow", "()I", "aggregate", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "R", "body", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/aggregation/AggregateGroupedDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/aggregation/AggregateGroupedBody;", "Lkotlin/ExtensionFunctionType;", "columnNames", "columnTypes", "Lkotlin/reflect/KType;", "columnsCount", "containsColumn", "", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "equals", "other", "", "get", "index", "getColumnIndex", "getColumnOrNull", "column", "Lkotlin/reflect/KProperty;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lorg/jetbrains/kotlinx/dataframe/columns/SingleColumn;", "Lorg/jetbrains/kotlinx/dataframe/ColumnSelector;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "hashCode", "remainingColumnsSelector", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "rowsCount", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nDataFrameImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/DataFrameImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1747#2,3:154\n1549#2:157\n1620#2,3:158\n1864#2,2:161\n1549#2:163\n1620#2,3:164\n1866#2:167\n1549#2:168\n1620#2,3:169\n1559#2:172\n1590#2,4:173\n1549#2:177\n1620#2,3:178\n1549#2:181\n1620#2,3:182\n1789#2,3:186\n1#3:185\n*S KotlinDebug\n*F\n+ 1 DataFrameImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/DataFrameImpl\n*L\n42#1:154,3\n43#1:157\n43#1:158,3\n48#1:161,2\n53#1:163\n53#1:164,3\n48#1:167\n61#1:168\n61#1:169,3\n62#1:172\n62#1:173,4\n89#1:177\n89#1:178,3\n91#1:181\n91#1:182,3\n127#1:186,3\n*E\n"})
public class DataFrameImpl<T>
implements DataFrame<T>,
AggregatableInternal<T> {
    private final int nrow;
    @NotNull
    private final Map<String, Integer> columnsMap;
    @NotNull
    private final List<DataColumn<?>> columns;

    /*
     * WARNING - void declaration
     */
    public DataFrameImpl(@NotNull List<? extends DataColumn<?>> cols2, int nrow) {
        boolean bl;
        Iterable $this$any$iv;
        block17: {
            Intrinsics.checkNotNullParameter(cols2, (String)"cols");
            this.nrow = nrow;
            this.columnsMap = new LinkedHashMap();
            $this$any$iv = cols2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DataColumn it = (DataColumn)element$iv;
                    boolean bl2 = false;
                    if (!(BaseColumnKt.getSize(it) != this.nrow)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$any$iv = cols2;
            int n = this.nrow;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataColumn dataColumn = (DataColumn)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(TuplesKt.to((Object)ColumnReferenceApiKt.getName((ColumnReference)it), (Object)BaseColumnKt.getSize((BaseColumn)it)));
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            int n2 = n;
            throw new UnequalColumnSizesException(n2, list);
        }
        boolean hasUnnamedColumns = false;
        Iterable $this$forEachIndexed$iv = cols2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Iterator col2;
            int item$iv$iv;
            if ((item$iv$iv = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataColumn it = (DataColumn)item$iv;
            int i = item$iv$iv;
            boolean bl4 = false;
            String name = ColumnReferenceApiKt.getName((ColumnReference)((Object)col2));
            if (((CharSequence)name).length() == 0) {
                hasUnnamedColumns = true;
                continue;
            }
            if (this.columnsMap.containsKey(name)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv2 = cols2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it2;
                    DataColumn dataColumn = (DataColumn)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(ColumnReferenceApiKt.getName((ColumnReference)it2));
                }
                List list = (List)destination$iv$iv;
                throw new DuplicateColumnNamesException(list);
            }
            Integer $i$f$map = i;
            this.columnsMap.put(name, $i$f$map);
        }
        if (hasUnnamedColumns) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = cols2;
            boolean $i$f$map = false;
            Iterable $i$f$mapTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataColumn bl4 = (DataColumn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(ColumnReferenceApiKt.getName((ColumnReference)it));
            }
            List list = (List)destination$iv$iv;
            ColumnNameGenerator nameGenerator = new ColumnNameGenerator(list);
            $this$map$iv = cols2;
            DataFrameImpl dataFrameImpl = this;
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                DataColumn dataColumn;
                void col3;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DataColumn $this$map$iv2 = (DataColumn)item$iv$iv;
                int n3 = n;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                String name = ColumnReferenceApiKt.getName((ColumnReference)col3);
                if (((CharSequence)name).length() == 0) {
                    void i;
                    String uniqueName = nameGenerator.addUnique("untitled");
                    DataColumn renamed = col3.rename(uniqueName);
                    Integer n4 = (int)i;
                    this.columnsMap.put(uniqueName, n4);
                    dataColumn = renamed;
                } else {
                    dataColumn = col3;
                }
                collection.add(dataColumn);
            }
            dataFrameImpl.columns = (List)destination$iv$iv;
        } else {
            this.columns = cols2;
        }
    }

    public final int getNrow() {
        return this.nrow;
    }

    @NotNull
    protected final List<DataColumn<?>> getColumns() {
        return this.columns;
    }

    @Override
    public int rowsCount() {
        return this.nrow;
    }

    @Override
    public int getColumnIndex(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.columnsMap.get(name);
        return n != null ? n : -1;
    }

    public boolean equals(@Nullable Object other) {
        DataFrame dataFrame = other instanceof DataFrame ? (DataFrame)other : null;
        if (dataFrame == null) {
            return false;
        }
        DataFrame df2 = dataFrame;
        return Intrinsics.areEqual(this.columns, df2.columns());
    }

    public int hashCode() {
        return ((Object)this.columns).hashCode();
    }

    @NotNull
    public String toString() {
        return StringKt.renderToString$default(this, 0, 0, false, false, false, false, false, 127, null);
    }

    @Override
    @NotNull
    public List<DataColumn<?>> columns() {
        return this.columns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> columnNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.columns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KType> columnTypes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.columns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.type());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public int columnsCount() {
        return this.columns.size();
    }

    @Override
    @NotNull
    public DataRow<T> get(int index) {
        if (index < 0 || index >= this.nrow) {
            throw new IndexOutOfBoundsException("index: " + index + ", rowsCount: " + this.nrow);
        }
        return new DataRowImpl(index, this);
    }

    @Override
    @NotNull
    public Function2<ColumnsSelectionDsl<?>, ColumnsSelectionDsl<?>, ColumnsResolver<?>> remainingColumnsSelector() {
        return remainingColumnsSelector.1.INSTANCE;
    }

    @Override
    @NotNull
    public <R> DataRow<T> aggregate(@NotNull Function2<? super AggregateGroupedDsl<? extends T>, ? super AggregateGroupedDsl<? extends T>, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        GroupByReceiverImpl receiver2 = new GroupByReceiverImpl(this, false);
        body.invoke(receiver2, receiver2);
        DataRow<?> dataRow = receiver2.compute$core();
        if (dataRow == null) {
            dataRow = DataFrame.Companion.empty(1).get(0);
        }
        DataRow<?> row = dataRow;
        return CastKt.cast(row);
    }

    @Override
    @Nullable
    public DataColumn<?> getColumnOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int it = this.getColumnIndex(name);
        boolean bl = false;
        return it != -1 ? DataFrameGetKt.getColumn((ColumnsContainer)this, it) : null;
    }

    @Override
    @Nullable
    public DataColumn<?> getColumnOrNull(int index) {
        return index >= 0 && index < this.columns.size() ? this.columns.get(index) : null;
    }

    @Override
    @Nullable
    public <R> DataColumn<R> getColumnOrNull(@NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends SingleColumn<? extends R>> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return (DataColumn)CollectionsKt.singleOrNull(UtilsKt.getColumnsImpl(this, UnresolvedColumnsPolicy.Skip, column2));
    }

    @Override
    @Nullable
    public <R> DataColumn<R> getColumnOrNull(@NotNull ColumnReference<? extends R> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        ColumnWithPath columnWithPath = org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.resolveSingle((SingleColumn)column2, this, UnresolvedColumnsPolicy.Skip);
        return columnWithPath != null ? columnWithPath.getData() : null;
    }

    @Override
    @Nullable
    public <R> DataColumn<R> getColumnOrNull(@NotNull KProperty<? extends R> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return this.getColumnOrNull((ColumnReference)TypeConversionsKt.toColumnAccessor(column2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DataColumn<?> getColumnOrNull(@NotNull ColumnPath path) {
        DataColumn<Object> dataColumn;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        switch (path.size()) {
            case 0: {
                dataColumn = TypeConversionsKt.asDataColumn(TypeConversionsKt.asColumnGroup$default(this, null, 1, null));
                break;
            }
            case 1: {
                dataColumn = this.getColumnOrNull(path.get(0));
                break;
            }
            default: {
                void $this$fold$iv;
                Iterable iterable = path.dropLast(1);
                DataFrame initial$iv = this;
                boolean $i$f$fold = false;
                DataFrame accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void name;
                    String string = (String)element$iv;
                    DataFrame df2 = accumulator$iv;
                    boolean bl = false;
                    DataFrame dataFrame = df2;
                    DataColumn<?> dataColumn2 = dataFrame != null ? dataFrame.getColumnOrNull((String)name) : null;
                    accumulator$iv = dataColumn2 instanceof DataFrame ? (DataFrame)((Object)dataColumn2) : null;
                }
                DataFrame dataFrame = accumulator$iv;
                dataColumn = dataFrame != null ? dataFrame.getColumnOrNull((String)CollectionsKt.last((List)path)) : null;
            }
        }
        return dataColumn;
    }

    @Override
    public boolean containsColumn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.columnsMap.containsKey(name);
    }

    @Override
    public boolean containsColumn(@NotNull ColumnPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getColumnOrNull(path) != null;
    }

    @Override
    @NotNull
    public <C> List<DataColumn<C>> get(@NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> columns2) {
        return DataFrame.DefaultImpls.get(this, columns2);
    }

    @Override
    @NotNull
    public DataFrame<T> get(@NotNull Iterable<Integer> indices) {
        return DataFrame.DefaultImpls.get(this, indices);
    }

    @Override
    @NotNull
    public DataFrame<T> get(@NotNull IntRange range) {
        return DataFrame.DefaultImpls.get(this, range);
    }

    @Override
    @NotNull
    public DataFrame<T> get(@NotNull IntRange first2, IntRange ... ranges) {
        return DataFrame.DefaultImpls.get(this, first2, ranges);
    }

    @Override
    @NotNull
    public DataFrame<T> get(int firstIndex, int ... otherIndices) {
        return DataFrame.DefaultImpls.get(this, firstIndex, otherIndices);
    }

    @Override
    @NotNull
    public DataColumn<?> get(@NotNull String columnName) {
        return DataFrame.DefaultImpls.get(this, columnName);
    }

    @Override
    @NotNull
    public DataColumn<?> get(@NotNull ColumnPath columnPath) {
        return DataFrame.DefaultImpls.get(this, columnPath);
    }

    @Override
    @NotNull
    public <R> DataColumn<R> get(@NotNull DataColumn<? extends R> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <R> ColumnGroup<R> get(@NotNull DataColumn<? extends DataRow<? extends R>> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <R> FrameColumn<R> get(@NotNull DataColumn<? extends DataFrame<? extends R>> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <R> DataColumn<R> get(@NotNull ColumnReference<? extends R> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <R> ColumnGroup<R> get(@NotNull ColumnReference<? extends DataRow<? extends R>> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <R> FrameColumn<R> get(@NotNull ColumnReference<? extends DataFrame<? extends R>> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <R> DataColumn<R> get(@NotNull KProperty<? extends R> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <R> ColumnGroup<R> get(@NotNull KProperty<? extends DataRow<? extends R>> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <R> FrameColumn<R> get(@NotNull KProperty<? extends DataFrame<? extends R>> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public <C> DataColumn<C> get(@NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends SingleColumn<? extends C>> column2) {
        return DataFrame.DefaultImpls.get(this, column2);
    }

    @Override
    @NotNull
    public Iterator<DataRow<T>> iterator() {
        return DataFrame.DefaultImpls.iterator(this);
    }

    @Override
    @NotNull
    public DataFrame<T> plus(@NotNull BaseColumn<?> col2) {
        return DataFrame.DefaultImpls.plus(this, col2);
    }

    @Override
    @NotNull
    public DataFrame<T> plus(@NotNull Iterable<? extends BaseColumn<?>> cols2) {
        return DataFrame.DefaultImpls.plus(this, cols2);
    }
}

