/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stunclient;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.XorMappedAddressAttribute;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Response;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.StunStack;
import org.ice4j.stunclient.BlockingRequestSender;

public class SimpleAddressDetector {
    private static final Logger logger = Logger.getLogger(SimpleAddressDetector.class.getName());
    private StunStack stunStack = null;
    private TransportAddress serverAddress = null;
    private BlockingRequestSender requestSender = null;

    public SimpleAddressDetector(TransportAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    public TransportAddress getServerAddress() {
        return this.serverAddress;
    }

    public void shutDown() {
        this.stunStack = null;
        this.requestSender = null;
    }

    public void start() {
        this.stunStack = new StunStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportAddress getMappingFor(IceSocketWrapper socket) throws IOException, BindException {
        TransportAddress localAddress = new TransportAddress((InetSocketAddress)socket.getLocalSocketAddress(), Transport.UDP);
        this.stunStack.addSocket(socket);
        this.requestSender = new BlockingRequestSender(this.stunStack, localAddress);
        StunMessageEvent evt = null;
        try {
            evt = this.requestSender.sendRequestAndWaitForResponse(MessageFactory.createBindingRequest(), this.serverAddress);
        }
        catch (StunException exc) {
            logger.log(Level.SEVERE, "Internal Error. We apparently constructed a faulty request.", exc);
            TransportAddress transportAddress = null;
            return transportAddress;
        }
        finally {
            this.stunStack.removeSocket(localAddress);
        }
        if (evt != null) {
            Response res = (Response)evt.getMessage();
            MappedAddressAttribute maAtt = (MappedAddressAttribute)res.getAttribute('\u0001');
            if (maAtt != null) {
                return maAtt.getAddress();
            }
            XorMappedAddressAttribute xorAtt = (XorMappedAddressAttribute)res.getAttribute(' ');
            if (xorAtt != null) {
                byte[] xoring = new byte[16];
                System.arraycopy(Message.MAGIC_COOKIE, 0, xoring, 0, 4);
                System.arraycopy(res.getTransactionID(), 0, xoring, 4, 12);
                return xorAtt.applyXor(xoring);
            }
        }
        return null;
    }
}

