/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.packageChecker.python.utils.SdkUtils;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0000\u001a$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\u000e*\u00020\u0011H\u0000\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006\u0013"}, d2={"poetryLock", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/module/Module;", "getPoetryLock", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/vfs/VirtualFile;", "pipFile", "getPipFile", "pyProjectToml", "getPyProjectToml", "sourceRootDirectories", "", "module", "sourceDirectories", "pkg", "Lorg/jetbrains/security/package/Package;", "declaredVersion", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "toPackage", "intellij.packageChecker.python"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/packageChecker/python/utils/UtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n3829#2:99\n4344#2,2:100\n1611#3,9:102\n1863#3:111\n1611#3,9:114\n1863#3:123\n1864#3:125\n1620#3:126\n1864#3:128\n1620#3:129\n57#4:112\n1#5:113\n1#5:124\n1#5:127\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/intellij/packageChecker/python/utils/UtilsKt\n*L\n36#1:99\n36#1:100,2\n51#1:102,9\n51#1:111\n64#1:114,9\n64#1:123\n64#1:125\n64#1:126\n51#1:128\n51#1:129\n59#1:112\n59#1:113\n64#1:124\n51#1:127\n*E\n"})
public final class UtilsKt {
    @Nullable
    public static final VirtualFile getPoetryLock(@NotNull Module $this$poetryLock) {
        Intrinsics.checkNotNullParameter((Object)$this$poetryLock, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir((Module)$this$poetryLock);
        return virtualFile != null ? virtualFile.findChild("poetry.lock") : null;
    }

    @Nullable
    public static final VirtualFile getPipFile(@NotNull Module $this$pipFile) {
        Intrinsics.checkNotNullParameter((Object)$this$pipFile, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir((Module)$this$pipFile);
        return virtualFile != null ? virtualFile.findChild("Pipfile") : null;
    }

    @Nullable
    public static final VirtualFile getPyProjectToml(@NotNull Module $this$pyProjectToml) {
        Intrinsics.checkNotNullParameter((Object)$this$pyProjectToml, (String)"<this>");
        VirtualFile virtualFile = BasePySdkExtKt.getBaseDir((Module)$this$pyProjectToml);
        return virtualFile != null ? virtualFile.findChild("pyproject.toml") : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> sourceRootDirectories(@NotNull Module module) {
        List list;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Sdk sdk = SdkUtils.INSTANCE.getSdk(module);
        if (sdk != null) {
            void $this$filterTo$iv$iv;
            Sdk sdk2 = sdk;
            boolean bl = false;
            VirtualFile[] virtualFileArray = sdk2.getRootProvider().getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"site-packages")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<VirtualFile> sourceDirectories(@NotNull List<? extends VirtualFile> sourceDirectories, @NotNull Package pkg) {
        Intrinsics.checkNotNullParameter(sourceDirectories, (String)"sourceDirectories");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        if (sourceDirectories.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Object object = ApplicationManager.getApplication().runReadAction(() -> UtilsKt.sourceDirectories$lambda$7(sourceDirectories, pkg));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (List)object;
    }

    @NotNull
    public static final String declaredVersion(@NotNull PyRequirement $this$declaredVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$declaredVersion, (String)"<this>");
        List list = $this$declaredVersion.getVersionSpecs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVersionSpecs(...)");
        List specs = list;
        if (specs.size() > 1) {
            return "0.0.0-ANY";
        }
        PyRequirementVersionSpec pyRequirementVersionSpec = (PyRequirementVersionSpec)CollectionsKt.firstOrNull((List)specs);
        if (pyRequirementVersionSpec == null) {
            return "0.0.0-ANY";
        }
        PyRequirementVersionSpec versionSpec = pyRequirementVersionSpec;
        if (versionSpec.getRelation() == PyRequirementRelation.EQ) {
            String string = versionSpec.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
            return string;
        }
        return "0.0.0-ANY";
    }

    @NotNull
    public static final Package toPackage(@NotNull PyRequirement $this$toPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        String string = $this$toPackage.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new Package(PackageType.pypi, null, string, UtilsKt.declaredVersion($this$toPackage), null, null, null, 112, null);
    }

    private static final boolean sourceDirectories$lambda$7$lambda$6$lambda$3$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.isBlank((CharSequence)it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List sourceDirectories$lambda$7(List $sourceDirectories, Package $pkg) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $sourceDirectories;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            List list;
            VirtualFile topLevelFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile sourceRoot = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            String possibleFolderName = StringsKt.replace$default((String)$pkg.getName(), (String)"-", (String)"_", (boolean)false, (int)4, null) + "-" + $pkg.getVersion() + ".dist-info";
            VirtualFile metadataDirectory = VirtualFileUtil.findDirectory((VirtualFile)sourceRoot, (String)possibleFolderName);
            if (metadataDirectory != null && (topLevelFile = metadataDirectory.findChild("top_level.txt")) != null && topLevelFile.exists()) {
                void $this$mapNotNullTo$iv$iv2;
                Object it$iv;
                void $this$useLines$iv;
                InputStream inputStream = topLevelFile.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Closeable closeable = inputStream;
                Charset charset = Charsets.UTF_8;
                Object object = new InputStreamReader((InputStream)closeable, charset);
                int n = 8192;
                closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                boolean $i$f$useLines = false;
                object = $this$useLines$iv;
                n = 8192;
                object = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                Throwable throwable = null;
                try {
                    it$iv = (BufferedReader)object;
                    boolean bl3 = false;
                    Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                    boolean bl4 = false;
                    it$iv = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)lines, UtilsKt::sourceDirectories$lambda$7$lambda$6$lambda$3$lambda$2));
                }
                catch (Throwable bl3) {
                    throwable = bl3;
                    throw bl3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                Object directoryNames = it$iv;
                Iterable $this$mapNotNull$iv2 = (Iterable)directoryNames;
                boolean $i$f$mapNotNull2 = false;
                object = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    VirtualFile it$iv$iv;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator2.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    String name = (String)element$iv$iv2;
                    boolean bl5 = false;
                    if (VirtualFileUtil.findDirectory((VirtualFile)sourceRoot, (String)name) == null) continue;
                    boolean bl6 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else if (VirtualFileUtil.findDirectory((VirtualFile)sourceRoot, (String)$pkg.getName()) != null) {
                VirtualFile it;
                boolean bl7 = false;
                list = CollectionsKt.listOf((Object)it);
            } else {
                list = null;
            }
            if (list == null) continue;
            List it$iv$iv = list;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }
}

