/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.NotebookLanguageDetector;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/jupyter/helper/NotebookLanguageMatcher;", "", "myLanguage", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "getMyLanguage", "()Lcom/intellij/lang/Language;", "matches", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "backedFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
public final class NotebookLanguageMatcher {
    @NotNull
    private final Language myLanguage;

    public NotebookLanguageMatcher(@NotNull Language myLanguage) {
        Intrinsics.checkNotNullParameter((Object)myLanguage, (String)"myLanguage");
        this.myLanguage = myLanguage;
    }

    @NotNull
    public final Language getMyLanguage() {
        return this.myLanguage;
    }

    public final boolean matches(@Nullable VirtualFile virtualFile2) {
        return NotebookLanguageDetector.INSTANCE.detectLanguage(virtualFile2) == this.myLanguage;
    }

    public final boolean matches(@NotNull BackedNotebookVirtualFile backedFile) {
        Intrinsics.checkNotNullParameter((Object)backedFile, (String)"backedFile");
        return NotebookLanguageDetector.INSTANCE.detectLanguage(backedFile) == this.myLanguage;
    }

    public final boolean matches(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        return NotebookLanguageDetector.INSTANCE.detectLanguage(notebook) == this.myLanguage;
    }

    public final boolean matches(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return NotebookLanguageDetector.INSTANCE.detectLanguage(dataContext) == this.myLanguage;
    }

    public final boolean matches(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return NotebookLanguageDetector.INSTANCE.detectLanguage(editor) == this.myLanguage;
    }
}

