/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.interaction;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.interaction.SshPasswordProvider;
import java.nio.file.Path;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004JE\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0001J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ssh/interaction/InteractiveRedirectingSshPasswordProvider;", "Lcom/intellij/ssh/interaction/SshPasswordProvider;", "delegate", "<init>", "(Lcom/intellij/ssh/interaction/SshPasswordProvider;)V", "getKeyboardInteractive", "", "", "name", "instruction", "prompt", "echo", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;[ZLcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "getKeyPassphrase", "privateKeyPath", "Ljava/nio/file/Path;", "getUnixPassword", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nInteractiveRedirectingSshPasswordProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractiveRedirectingSshPasswordProvider.kt\ncom/intellij/ssh/interaction/InteractiveRedirectingSshPasswordProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n62#2,5:60\n15#2:66\n1#3:65\n*S KotlinDebug\n*F\n+ 1 InteractiveRedirectingSshPasswordProvider.kt\ncom/intellij/ssh/interaction/InteractiveRedirectingSshPasswordProvider\n*L\n42#1:60,5\n57#1:66\n*E\n"})
public final class InteractiveRedirectingSshPasswordProvider
implements SshPasswordProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SshPasswordProvider delegate;
    @NotNull
    private static final Logger LOG;

    public InteractiveRedirectingSshPasswordProvider(@NotNull SshPasswordProvider delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public String[] getKeyboardInteractive(@NotNull String name, @NotNull String instruction, @NotNull String[] prompt, @NotNull boolean[] echo, @Nullable ProgressIndicator progressIndicator2) {
        String[] stringArray;
        boolean isUnixPassword;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Intrinsics.checkNotNullParameter((Object)echo, (String)"echo");
        String string = (String)ArraysKt.singleOrNull((Object[])prompt);
        if (string != null) {
            String it = string;
            boolean bl = false;
            boolean isUnixPassword2 = SshConnectionUtil.isPamUnixPasswordPrompted(it);
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                Base64.Encoder encoder = Base64.getEncoder();
                byte[] byArray = it.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                String base64prompt = encoder.encodeToString(byArray);
                String treated = isUnixPassword2 ? "treated" : "NOT treated";
                logger.debug("Password prompt `" + it + "` (base64 utf8 " + base64prompt + ") is " + treated + " as unix password", e$iv);
            }
            v2 = isUnixPassword2;
        } else {
            v2 = isUnixPassword = false;
        }
        if (isUnixPassword) {
            String string2 = this.delegate.getUnixPassword(progressIndicator2);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                String[] stringArray2 = new String[]{it};
                stringArray = stringArray2;
            } else {
                stringArray = null;
            }
        } else {
            stringArray = this.delegate.getKeyboardInteractive(name, instruction, prompt, echo, progressIndicator2);
        }
        return stringArray;
    }

    @Override
    @Nullable
    public String getKeyPassphrase(@NotNull Path privateKeyPath, @Nullable ProgressIndicator progressIndicator2) {
        Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
        return this.delegate.getKeyPassphrase(privateKeyPath, progressIndicator2);
    }

    @Override
    @Nullable
    public String getUnixPassword(@Nullable ProgressIndicator progressIndicator2) {
        return this.delegate.getUnixPassword(progressIndicator2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InteractiveRedirectingSshPasswordProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ssh/interaction/InteractiveRedirectingSshPasswordProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

