/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.PromiscuousSshHostKeyVerifier;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.config.ServerAlive;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshIdeGlobalProxyGetter;
import com.intellij.ssh.config.SshProxyConfig;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"changeSshConnectionConfig", "Lcom/intellij/ssh/config/SshConnectionConfig;", "Lcom/intellij/remote/RemoteCredentials;", "source", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
@JvmName(name="RemoteCredentialsSshConnectionConfig")
@SourceDebugExtension(value={"SMAP\nRemoteCredentialsSshConnectionConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteCredentialsSshConnectionConfig.kt\ncom/intellij/ssh/config/RemoteCredentialsSshConnectionConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n1#2:104\n1557#3:105\n1628#3,3:106\n15#4:109\n*S KotlinDebug\n*F\n+ 1 RemoteCredentialsSshConnectionConfig.kt\ncom/intellij/ssh/config/RemoteCredentialsSshConnectionConfig\n*L\n63#1:105\n63#1:106,3\n102#1:109\n*E\n"})
public final class RemoteCredentialsSshConnectionConfig {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SshConnectionConfig changeSshConnectionConfig(@NotNull RemoteCredentials $this$changeSshConnectionConfig, @NotNull SshConnectionConfig source) {
        ServerAlive serverAlive;
        SshHostKeyVerifier sshHostKeyVerifier;
        PromiscuousSshHostKeyVerifier p0;
        Object it;
        Object object;
        int n;
        Object object2;
        Object object3;
        block38: {
            block37: {
                Credentials credentials;
                Object object4;
                block36: {
                    block35: {
                        Intrinsics.checkNotNullParameter((Object)$this$changeSshConnectionConfig, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        object4 = $this$changeSshConnectionConfig.getUserName();
                        if (object4 == null) break block35;
                        object3 = object4;
                        String it2 = object3;
                        boolean bl = false;
                        object4 = ((CharSequence)it2).length() > 0 ? object3 : null;
                        if (object4 != null) break block36;
                    }
                    object4 = source.getUser();
                }
                object2 = object4;
                n = $this$changeSshConnectionConfig.getPort();
                object = $this$changeSshConnectionConfig.getConnectionConfigPatch();
                if (object == null || (object = object.getProxyParams()) == null) break block37;
                it = object;
                boolean bl = false;
                SshConnectionConfigPatch.ProxyParams.ProxyAuthData proxyAuthData = it.getAuthData();
                if (proxyAuthData != null) {
                    SshConnectionConfigPatch.ProxyParams.ProxyAuthData authData = proxyAuthData;
                    boolean bl2 = false;
                    credentials = authData.getAuthType() != SshConnectionConfigPatch.ProxyParams.ProxyAuthData.ProxyAuthType.NO_AUTHORIZATION ? new Credentials(authData.getUsername(), authData.getPassword()) : null;
                } else {
                    credentials = null;
                }
                Credentials credentials2 = credentials;
                SshProxyConfig sshProxyConfig = switch (WhenMappings.$EnumSwitchMapping$0[it.getProxyType().ordinal()]) {
                    case 1 -> new SshProxyConfig.HTTP(it.getProxyHost(), it.getProxyPort(), credentials2);
                    case 2 -> new SshProxyConfig.SOCKS(it.getProxyHost(), it.getProxyPort(), credentials2);
                    case 3 -> source.getProxyConfig();
                    case 4 -> {
                        SshIdeGlobalProxyGetter v5 = SshIdeGlobalProxyGetter.Companion.getInstance();
                        String v6 = $this$changeSshConnectionConfig.getHost();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getHost(...)");
                        yield v5.getIdeWideProxy(v6, $this$changeSshConnectionConfig.getPort());
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                object = sshProxyConfig;
                if (sshProxyConfig != null) break block38;
            }
            object = source.getProxyConfig();
        }
        Object object5 = object;
        RemoteCredentials $this$changeSshConnectionConfig_u24lambda_u244 = $this$changeSshConnectionConfig;
        boolean bl = false;
        AuthMethods head = switch (WhenMappings.$EnumSwitchMapping$1[$this$changeSshConnectionConfig_u24lambda_u244.getAuthType().ordinal()]) {
            case 1 -> AuthMethod.Password.INSTANCE.plus(AuthMethod.KeyboardInteractive.INSTANCE).plus(new AuthMethod.PublicKey(new Path[0], AuthMethod.PublicKey.Agent.NO));
            case 2 -> {
                Path v9;
                Object it = it = $this$changeSshConnectionConfig_u24lambda_u244.getPrivateKeyFile();
                boolean $i$a$-takeIf-RemoteCredentialsSshConnectionConfig$changeSshConnectionConfig$3$head$1 = false;
                Intrinsics.checkNotNull((Object)it);
                Object v8 = ((CharSequence)it).length() > 0 ? it : null;
                if (v8 != null) {
                    Object p0 = v8;
                    boolean $i$a$-let-RemoteCredentialsSshConnectionConfig$changeSshConnectionConfig$3$head$2 = false;
                    v9 = Paths.get((String)p0, new String[0]);
                } else {
                    v9 = null;
                }
                AuthMethod.PublicKey.Agent var27_24 = AuthMethod.PublicKey.Agent.NO;
                List var28_25 = CollectionsKt.listOfNotNull(v9);
                yield new AuthMethod.PublicKey(var28_25, var27_24).toAuthMethods();
            }
            case 3 -> AuthMethods.empty;
            default -> throw new NoWhenBranchMatchedException();
        };
        object3 = head.plus(source.getAuthMethods());
        RemoteCredentials $this$changeSshConnectionConfig_u24lambda_u248 = $this$changeSshConnectionConfig;
        boolean bl3 = false;
        PromiscuousSshHostKeyVerifier it3 = p0 = PromiscuousSshHostKeyVerifier.INSTANCE;
        boolean bl4 = false;
        PromiscuousSshHostKeyVerifier promiscuousSshHostKeyVerifier = $this$changeSshConnectionConfig_u24lambda_u248.isSkippingHostKeyVerification() ? p0 : null;
        if (promiscuousSshHostKeyVerifier != null) {
            sshHostKeyVerifier = promiscuousSshHostKeyVerifier;
        } else {
            OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier;
            SshConnectionConfigPatch sshConnectionConfigPatch = $this$changeSshConnectionConfig_u24lambda_u248.getConnectionConfigPatch();
            if (sshConnectionConfigPatch != null && (sshConnectionConfigPatch = sshConnectionConfigPatch.getHostKeyVerifier()) != null) {
                boolean bl5;
                Object object6;
                SshConnectionConfigPatch patch = sshConnectionConfigPatch;
                boolean bl6 = false;
                SshHostKeyVerifier sshHostKeyVerifier2 = source.getHostKeyVerifier();
                OpenSshLikeHostKeyVerifier oldOpenSsh = sshHostKeyVerifier2 instanceof OpenSshLikeHostKeyVerifier ? (OpenSshLikeHostKeyVerifier)sshHostKeyVerifier2 : null;
                Object object7 = oldOpenSsh;
                if (object7 == null || (object7 = ((OpenSshLikeHostKeyVerifier)object7).getKnownHostsFiles()) == null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = OpenSSHConfigUtil.getDefaultKnownHostsFiles();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it4;
                        Path path = (Path)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl7 = false;
                        collection.add(it4.toFile());
                    }
                    object7 = (List)destination$iv$iv;
                }
                if ((object6 = patch.getStrictHostKeyChecking()) == null) {
                    OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier2 = oldOpenSsh;
                    object6 = openSshLikeHostKeyVerifier2 != null ? openSshLikeHostKeyVerifier2.getStrictHostKeyChecking() : null;
                    if (object6 == null) {
                        object6 = SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK;
                    }
                }
                Boolean bl8 = patch.getHashKnownHosts();
                if (bl8 != null) {
                    bl5 = bl8;
                } else {
                    OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier3 = oldOpenSsh;
                    Boolean bl9 = openSshLikeHostKeyVerifier3 != null ? Boolean.valueOf(openSshLikeHostKeyVerifier3.getHashKnownHosts()) : null;
                    bl5 = bl9 != null ? bl9 : false;
                }
                OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier4 = oldOpenSsh;
                boolean bl10 = openSshLikeHostKeyVerifier4 != null ? openSshLikeHostKeyVerifier4.getAllowDialogs() : true;
                boolean bl11 = bl5;
                SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking strictHostKeyChecking = object6;
                Object object8 = object7;
                openSshLikeHostKeyVerifier = new OpenSshLikeHostKeyVerifier((List<? extends File>)object8, strictHostKeyChecking, bl11, bl10);
            } else {
                openSshLikeHostKeyVerifier = null;
            }
            sshHostKeyVerifier = openSshLikeHostKeyVerifier != null ? (SshHostKeyVerifier)openSshLikeHostKeyVerifier : source.getHostKeyVerifier();
        }
        SshHostKeyVerifier sshHostKeyVerifier3 = sshHostKeyVerifier;
        RemoteCredentials $this$changeSshConnectionConfig_u24lambda_u2410 = $this$changeSshConnectionConfig;
        boolean bl12 = false;
        Object object9 = $this$changeSshConnectionConfig_u24lambda_u2410.getConnectionConfigPatch();
        if (object9 != null && (object9 = object9.getServerAliveInterval()) != null) {
            it3 = object9;
            boolean bl13 = false;
            serverAlive = new ServerAlive((Duration)((Object)it3), 3);
        } else {
            serverAlive = source.getServerAlive();
        }
        ServerAlive serverAlive2 = serverAlive;
        Object it5 = object2 = SshConnectionConfig.copy$default(source, (AuthMethods)object3, null, false, null, false, null, null, null, sshHostKeyVerifier3, null, null, null, null, null, n, (SshProxyConfig)object5, serverAlive2, (String)object2, null, 278270, null);
        boolean bl14 = false;
        String diff = CollectionsKt.joinToString$default((Iterable)SshConnectionConfigKt.sshConnectionConfigDiff(source, (SshConnectionConfig)it5), (CharSequence)"\n", null, null, (int)0, null, RemoteCredentialsSshConnectionConfig::changeSshConnectionConfig$lambda$12$lambda$11, (int)30, null);
        if (((CharSequence)diff).length() > 0) {
            LOG.debug("Change after applying remote credentials for host " + $this$changeSshConnectionConfig.getHost() + ":\n" + diff);
        } else {
            LOG.debug("No changes after applying remote credentials for host " + $this$changeSshConnectionConfig.getHost() + ".");
        }
        return object2;
    }

    private static final CharSequence changeSshConnectionConfig$lambda$12$lambda$11(Triple triple) {
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        String key = (String)triple.component1();
        Object oldValue = triple.component2();
        Object newValue = triple.component3();
        return "  " + key + ": " + oldValue + "\n" + StringsKt.repeat((CharSequence)" ", (int)(key.length() + 1)) + "-> " + newValue;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshConnectionConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SshConnectionConfigPatch.ProxyParams.Type.values().length];
            try {
                nArray[SshConnectionConfigPatch.ProxyParams.Type.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.ProxyParams.Type.SOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.ProxyParams.Type.NO_PROXY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.ProxyParams.Type.IDE_WIDE_PROXY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AuthType.values().length];
            try {
                nArray[AuthType.PASSWORD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthType.KEY_PAIR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthType.OPEN_SSH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

