/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split.diff;

import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.platform.vcs.frontend.split.diff.DiffControlTraversalPolicy;
import com.intellij.platform.vcs.frontend.split.diff.SideBySideHighlightingTracker;
import com.intellij.platform.vcs.frontend.split.diff.UtilKt;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.ide.model.BeSideBySideDiffViewer;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/SideBySideDiffViewerControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/rd/ide/model/BeSideBySideDiffViewer;", "<init>", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.platform.vcs.frontend.split"})
@SourceDebugExtension(value={"SMAP\nSideBySideDiffViewerControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SideBySideDiffViewerControl.kt\ncom/intellij/platform/vcs/frontend/split/diff/SideBySideDiffViewerControl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,254:1\n25#2:255\n*S KotlinDebug\n*F\n+ 1 SideBySideDiffViewerControl.kt\ncom/intellij/platform/vcs/frontend/split/diff/SideBySideDiffViewerControl\n*L\n51#1:255\n*E\n"})
public final class SideBySideDiffViewerControl
implements ViewBinder<BeSideBySideDiffViewer> {
    @NotNull
    public JComponent bind(@NotNull BeSideBySideDiffViewer viewModel, @NotNull Lifetime lifetime) {
        EditorEx editor2;
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JComponent component = ViewRegistryKt.getView((BeControl)viewModel.getContent(), (Lifetime)lifetime);
        Editor editor = FrontendTextControlHostKt.toEditorOrNull((TextControlId)viewModel.getEditorId1());
        EditorEx editor1 = editor instanceof EditorEx ? (EditorEx)editor : null;
        Editor editor3 = FrontendTextControlHostKt.toEditorOrNull((TextControlId)viewModel.getEditorId2());
        EditorEx editorEx = editor2 = editor3 instanceof EditorEx ? (EditorEx)editor3 : null;
        if (editor1 == null || editor2 == null) {
            SideBySideDiffViewerControl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SideBySideDiffViewerControl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to create diff viewer editors: " + editor1 + " " + editor2 + " - " + viewModel.getEditorId1() + " " + viewModel.getEditorId2());
            return component;
        }
        UtilKt.setupDiffEditor(editor1, viewModel.getGroup1());
        UtilKt.setupDiffEditor(editor2, viewModel.getGroup2());
        editor1.setVerticalScrollbarOrientation(0);
        new SideBySideHighlightingTracker(viewModel, component, editor1, editor2, lifetime);
        Project project = editor1.getProject();
        JComponent jComponent = editor2.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        DiffControlTraversalPolicy.Companion.installDiffPreferredFocusedComponent(project, component, jComponent);
        boolean editable1 = editor1.getDocument().isWritable();
        boolean editable2 = editor2.getDocument().isWritable();
        if (editable1 ^ editable2) {
            ProxyUndoRedoAction.register((Project)editor1.getProject(), (Editor)((Editor)(editable1 ? editor1 : editor2)), (JComponent)component);
        }
        return component;
    }
}

