/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRendererWithPopup;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.platform.vcs.frontend.split.FrontendVcsGutterMarkRenderer;
import com.intellij.platform.vcs.frontend.split.FrontendVcsGutterMarkersHostKt;
import com.intellij.platform.vcs.frontend.split.VcsLineRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H$J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/vcs/frontend/split/FrontendShowChangeMarkerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "shouldScroll", "", "<init>", "(Z)V", "getTargetRange", "Lcom/intellij/platform/vcs/frontend/split/VcsLineRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ranges", "", "selectedRange", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Next", "Prev", "Current", "intellij.platform.vcs.frontend.split"})
public abstract class FrontendShowChangeMarkerAction
extends DumbAwareAction {
    private final boolean shouldScroll;

    public FrontendShowChangeMarkerAction(boolean shouldScroll) {
        this.shouldScroll = shouldScroll;
    }

    @Nullable
    protected abstract VcsLineRange getTargetRange(@NotNull Editor var1, @NotNull List<VcsLineRange> var2, @Nullable VcsLineRange var3);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Editor editor;
        Editor editor2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor3 = (Editor)e.getData(FrontendVcsGutterMarkersHostKt.access$getVCS_EDITOR_KEY$p());
        if (editor3 == null) {
            editor3 = (Editor)e.getData(CommonDataKeys.EDITOR);
        }
        FrontendVcsGutterMarkRenderer renderer = (editor2 = (editor = editor3)) != null && (editor2 = editor2.getDocument()) != null ? (FrontendVcsGutterMarkRenderer)editor2.getUserData(FrontendVcsGutterMarkRenderer.Companion.getKEY()) : null;
        VcsLineRange selectedRange = (VcsLineRange)((Object)e.getData(FrontendVcsGutterMarkersHostKt.access$getVCS_RANGE_KEY$p()));
        FrontendVcsGutterMarkRenderer frontendVcsGutterMarkRenderer = renderer;
        List<VcsLineRange> ranges = frontendVcsGutterMarkRenderer != null ? frontendVcsGutterMarkRenderer.getRanges() : null;
        e.getPresentation().setEnabled(renderer != null && ranges != null && this.getTargetRange(editor, ranges, selectedRange) != null);
        e.getPresentation().setVisible(renderer != null || e.isFromActionToolbar());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(FrontendVcsGutterMarkersHostKt.access$getVCS_EDITOR_KEY$p());
        if (editor == null && (editor = (Editor)e.getData(CommonDataKeys.EDITOR)) == null) {
            return;
        }
        Editor editor2 = editor;
        Object object = editor2.getDocument().getUserData(FrontendVcsGutterMarkRenderer.Companion.getKEY());
        Intrinsics.checkNotNull((Object)object);
        FrontendVcsGutterMarkRenderer renderer = (FrontendVcsGutterMarkRenderer)object;
        VcsLineRange selectedRange = (VcsLineRange)((Object)e.getData(FrontendVcsGutterMarkersHostKt.access$getVCS_RANGE_KEY$p()));
        VcsLineRange vcsLineRange = this.getTargetRange(editor2, renderer.getRanges(), selectedRange);
        if (vcsLineRange == null) {
            return;
        }
        VcsLineRange targetRange = vcsLineRange;
        if (this.shouldScroll) {
            LineStatusMarkerRendererWithPopup.Companion.moveToRange(editor2, (Range)targetRange);
            editor2.getScrollingModel().runActionOnScrollingFinished(() -> FrontendShowChangeMarkerAction.actionPerformed$lambda$0(renderer, editor2, targetRange));
        } else {
            renderer.showHintAt(editor2, targetRange, null);
        }
    }

    private static final void actionPerformed$lambda$0(FrontendVcsGutterMarkRenderer $renderer, Editor $editor, VcsLineRange $targetRange) {
        $renderer.showHintAt($editor, $targetRange, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/vcs/frontend/split/FrontendShowChangeMarkerAction$Current;", "Lcom/intellij/platform/vcs/frontend/split/FrontendShowChangeMarkerAction;", "<init>", "()V", "getTargetRange", "Lcom/intellij/platform/vcs/frontend/split/VcsLineRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ranges", "", "selectedRange", "intellij.platform.vcs.frontend.split"})
    public static final class Current
    extends FrontendShowChangeMarkerAction {
        public Current() {
            super(false);
        }

        @Override
        @Nullable
        protected VcsLineRange getTargetRange(@NotNull Editor editor, @NotNull List<VcsLineRange> ranges, @Nullable VcsLineRange selectedRange) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            VcsLineRange vcsLineRange = selectedRange;
            int line = vcsLineRange != null ? vcsLineRange.getLine1() : editor.getCaretModel().getLogicalPosition().line;
            for (VcsLineRange range : ranges) {
                if (!DiffUtil.isSelectedByLine((int)line, (int)range.getLine1(), (int)range.getLine2())) continue;
                return range;
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/vcs/frontend/split/FrontendShowChangeMarkerAction$Next;", "Lcom/intellij/platform/vcs/frontend/split/FrontendShowChangeMarkerAction;", "<init>", "()V", "getTargetRange", "Lcom/intellij/platform/vcs/frontend/split/VcsLineRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ranges", "", "selectedRange", "intellij.platform.vcs.frontend.split"})
    public static final class Next
    extends FrontendShowChangeMarkerAction {
        public Next() {
            super(true);
        }

        @Override
        @Nullable
        protected VcsLineRange getTargetRange(@NotNull Editor editor, @NotNull List<VcsLineRange> ranges, @Nullable VcsLineRange selectedRange) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            VcsLineRange vcsLineRange = selectedRange;
            int line = vcsLineRange != null ? vcsLineRange.getLine2() : editor.getCaretModel().getLogicalPosition().line;
            for (VcsLineRange range : ranges) {
                if (line >= range.getLine2() || DiffUtil.isSelectedByLine((int)line, (int)range.getLine1(), (int)range.getLine2())) continue;
                return range;
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/vcs/frontend/split/FrontendShowChangeMarkerAction$Prev;", "Lcom/intellij/platform/vcs/frontend/split/FrontendShowChangeMarkerAction;", "<init>", "()V", "getTargetRange", "Lcom/intellij/platform/vcs/frontend/split/VcsLineRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ranges", "", "selectedRange", "intellij.platform.vcs.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nFrontendVcsGutterMarkersHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendVcsGutterMarkersHost.kt\ncom/intellij/platform/vcs/frontend/split/FrontendShowChangeMarkerAction$Prev\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n1#2:400\n*E\n"})
    public static final class Prev
    extends FrontendShowChangeMarkerAction {
        public Prev() {
            super(true);
        }

        @Override
        @Nullable
        protected VcsLineRange getTargetRange(@NotNull Editor editor, @NotNull List<VcsLineRange> ranges, @Nullable VcsLineRange selectedRange) {
            int n;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            VcsLineRange vcsLineRange = selectedRange;
            if (vcsLineRange != null) {
                VcsLineRange it = vcsLineRange;
                boolean bl = false;
                n = it.getLine1() - 1;
            } else {
                n = editor.getCaretModel().getLogicalPosition().line;
            }
            int line = n;
            for (VcsLineRange range : CollectionsKt.reversed((Iterable)ranges)) {
                if (line <= range.getLine1() || DiffUtil.isSelectedByLine((int)line, (int)range.getLine1(), (int)range.getLine2())) continue;
                return range;
            }
            return null;
        }
    }
}

