/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import com.intellij.xml.breadcrumbs.PsiFileBreadcrumbsCollector;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagTreeHighlightingPass
extends TextEditorHighlightingPass {
    private static final Key<List<RangeHighlighter>> TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY = Key.create((String)"TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY");
    public static final TextAttributesKey TAG_TREE_HIGHLIGHTING_KEY = TextAttributesKey.createTextAttributesKey((String)"TAG_TREE_HIGHLIGHTING_KEY");
    private static final HighlightInfoType TYPE = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, TAG_TREE_HIGHLIGHTING_KEY);
    private final PsiFile myFile;
    private final EditorEx myEditor;
    private final BreadcrumbsProvider myInfoProvider;
    private final List<Pair<TextRange, TextRange>> myPairsToHighlight;

    XmlTagTreeHighlightingPass(@NotNull PsiFile file, @NotNull EditorEx editor) {
        if (file == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(1);
        }
        super(file.getProject(), (Document)editor.getDocument(), true);
        this.myPairsToHighlight = new ArrayList<Pair<TextRange, TextRange>>();
        this.myFile = file;
        this.myEditor = editor;
        FileViewProvider viewProvider = file.getManager().findViewProvider(file.getVirtualFile());
        this.myInfoProvider = BreadcrumbsUtilEx.findProvider((boolean)false, (FileViewProvider)viewProvider);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!WebEditorOptions.getInstance().isTagTreeHighlightingEnabled()) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        PsiElement[] elements = PsiFileBreadcrumbsCollector.getLinePsiElements((Document)this.myEditor.getDocument(), (int)offset, (VirtualFile)this.myFile.getVirtualFile(), (Project)this.myProject, (BreadcrumbsProvider)this.myInfoProvider);
        if (elements == null || elements.length == 0 || !XmlTagTreeHighlightingUtil.containsTagsWithSameName(elements)) {
            elements = PsiElement.EMPTY_ARRAY;
            FileViewProvider provider = this.myFile.getViewProvider();
            for (Language language : provider.getLanguages()) {
                XmlTag tag;
                PsiElement element = provider.findElementAt(offset, language);
                if (!XmlTagTreeHighlightingPass.isTagStartOrEnd(element)) {
                    element = null;
                }
                if (element == null && offset > 0 && !XmlTagTreeHighlightingPass.isTagStartOrEnd(element = provider.findElementAt(offset - 1, language))) {
                    element = null;
                }
                if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) == null) continue;
                elements = new PsiElement[]{tag};
            }
        }
        for (int i = elements.length - 1; i >= 0; --i) {
            if (!(elements[i] instanceof XmlTag)) continue;
            this.myPairsToHighlight.add(XmlTagTreeHighlightingPass.getTagRanges((XmlTag)elements[i]));
        }
    }

    private static boolean isTagStartOrEnd(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        IElementType type = element.getNode().getElementType();
        if (type == XmlTokenType.XML_NAME || type == XmlTokenType.XML_TAG_NAME) {
            return XmlTagTreeHighlightingPass.isTagStartOrEnd(element.getNextSibling()) || XmlTagTreeHighlightingPass.isTagStartOrEnd(element.getPrevSibling());
        }
        return type == XmlTokenType.XML_START_TAG_START || type == XmlTokenType.XML_END_TAG_START || type == XmlTokenType.XML_TAG_END;
    }

    @NotNull
    private static Pair<TextRange, TextRange> getTagRanges(XmlTag tag) {
        ASTNode tagNode = tag.getNode();
        Pair pair = Pair.create((Object)XmlTagTreeHighlightingPass.getStartTagRange(tagNode), (Object)XmlTagTreeHighlightingPass.getEndTagRange(tagNode));
        if (pair == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Nullable
    private static TextRange getStartTagRange(ASTNode tagNode) {
        ASTNode startTagStart = XmlChildRole.START_TAG_START_FINDER.findChild(tagNode);
        if (startTagStart == null) {
            return null;
        }
        ASTNode tagName = TemplateLanguageUtil.getSameLanguageTreeNext((ASTNode)startTagStart);
        if (tagName == null || tagName.getElementType() != XmlTokenType.XML_NAME && tagName.getElementType() != XmlTokenType.XML_TAG_NAME) {
            return null;
        }
        ASTNode next = TemplateLanguageUtil.getSameLanguageTreeNext((ASTNode)tagName);
        if (next != null && next.getElementType() == XmlTokenType.XML_TAG_END) {
            tagName = next;
        }
        return new TextRange(startTagStart.getStartOffset(), tagName.getTextRange().getEndOffset());
    }

    @Nullable
    private static TextRange getEndTagRange(ASTNode tagNode) {
        ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tagNode);
        if (endTagStart == null) {
            return null;
        }
        ASTNode endTagEnd = endTagStart;
        while (endTagEnd != null && endTagEnd.getElementType() != XmlTokenType.XML_TAG_END) {
            endTagEnd = TemplateLanguageUtil.getSameLanguageTreeNext((ASTNode)endTagEnd);
        }
        if (endTagEnd == null) {
            return null;
        }
        return new TextRange(endTagStart.getStartOffset(), endTagEnd.getTextRange().getEndOffset());
    }

    public void doApplyInformationToEditor() {
        List<HighlightInfo> infos = this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToSingleEditor((Project)this.myProject, (Editor)this.myEditor, (int)0, (int)this.myFile.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    public List<HighlightInfo> getHighlights() {
        Color[] colorArray;
        XmlTagTreeHighlightingPass.clearLineMarkers((Editor)this.myEditor);
        int count = this.myPairsToHighlight.size();
        ArrayList<HighlightInfo> highlightInfos = new ArrayList<HighlightInfo>(count * 2);
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        Color[] baseColors = XmlTagTreeHighlightingUtil.getBaseColors();
        if (count > 1) {
            colorArray = this.toColorsForEditor(baseColors);
        } else {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = this.myEditor.getColorsScheme().getAttributes(XmlHighlighterColors.MATCHED_TAG_NAME).getBackgroundColor();
        }
        Color[] colorsForEditor = colorArray;
        Color[] colorsForLineMarkers = XmlTagTreeHighlightingPass.toColorsForLineMarkers(baseColors);
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        assert (colorsForEditor.length > 0);
        for (int i = 0; i < count && i < baseColors.length; ++i) {
            Color color;
            Pair<TextRange, TextRange> pair = this.myPairsToHighlight.get(i);
            if (pair.first == null && pair.second == null || (color = colorsForEditor[i]) == null) continue;
            if (pair.first != null && !((TextRange)pair.first).isEmpty()) {
                highlightInfos.add(XmlTagTreeHighlightingPass.createHighlightInfo(color, (TextRange)pair.first));
            }
            if (pair.second != null && !((TextRange)pair.second).isEmpty()) {
                highlightInfos.add(XmlTagTreeHighlightingPass.createHighlightInfo(color, (TextRange)pair.second));
            }
            int start2 = pair.first != null ? ((TextRange)pair.first).getStartOffset() : ((TextRange)pair.second).getStartOffset();
            int end = pair.second != null ? ((TextRange)pair.second).getEndOffset() : ((TextRange)pair.first).getEndOffset();
            Color lineMarkerColor = colorsForLineMarkers[i];
            if (count <= 1 || lineMarkerColor == null || start2 == end) continue;
            RangeHighlighter highlighter = XmlTagTreeHighlightingPass.createHighlighter((MarkupModel)markupModel, new TextRange(start2, end), lineMarkerColor);
            newHighlighters.add(highlighter);
        }
        this.myEditor.putUserData(TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY, newHighlighters);
        return highlightInfos;
    }

    private static void clearLineMarkers(Editor editor) {
        List oldHighlighters = (List)editor.getUserData(TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY);
        if (oldHighlighters != null) {
            MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
            for (RangeHighlighter highlighter : oldHighlighters) {
                if (!markupModel.containsHighlighter(highlighter)) continue;
                highlighter.dispose();
            }
            editor.putUserData(TAG_TREE_HIGHLIGHTERS_IN_EDITOR_KEY, null);
        }
    }

    @NotNull
    private static HighlightInfo createHighlightInfo(Color color, @NotNull TextRange range) {
        if (range == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(4);
        }
        TextAttributes attributes = new TextAttributes(null, color, null, null, 0);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)TYPE).range(range).textAttributes(attributes).severity(HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY).createUnconditionally();
        if (highlightInfo == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(5);
        }
        return highlightInfo;
    }

    @NotNull
    private static RangeHighlighter createHighlighter(MarkupModel mm, @NotNull TextRange range, Color color) {
        if (range == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(6);
        }
        RangeHighlighter highlighter = mm.addRangeHighlighter(null, range.getStartOffset(), range.getEndOffset(), 0, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((__, g, r) -> {
            g.setColor(color);
            g.fillRect(r.x - 1, r.y, 2, r.height);
        });
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(7);
        }
        return rangeHighlighter;
    }

    static Color toLineMarkerColor(int gray, Color color) {
        return color == null ? null : new Color(XmlTagTreeHighlightingPass.toLineMarkerColor(gray, color.getRed()), XmlTagTreeHighlightingPass.toLineMarkerColor(gray, color.getGreen()), XmlTagTreeHighlightingPass.toLineMarkerColor(gray, color.getBlue()));
    }

    private static int toLineMarkerColor(int gray, int color) {
        int value = (int)((double)gray * 0.6 + 0.32 * (double)color);
        return value < 0 ? 0 : Math.min(value, 255);
    }

    private static Color[] toColorsForLineMarkers(Color[] baseColors) {
        Color[] colors = new Color[baseColors.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = XmlTagTreeHighlightingPass.toLineMarkerColor(239, baseColors[i]);
        }
        return colors;
    }

    private Color[] toColorsForEditor(Color[] baseColors) {
        Color tagBackground = this.myEditor.getBackgroundColor();
        Color[] resultColors = new Color[baseColors.length];
        double transparency = (double)WebEditorOptions.getInstance().getTagTreeHighlightingOpacity() * 0.01;
        for (int i = 0; i < resultColors.length; ++i) {
            Color color1;
            Color color = baseColors[i];
            resultColors[i] = color1 = color != null ? UIUtil.makeTransparent((Color)color, (Color)tagBackground, (double)transparency) : null;
        }
        return resultColors;
    }

    public static void clearHighlightingAndLineMarkers(Editor editor, @NotNull Project project2) {
        if (project2 == null) {
            XmlTagTreeHighlightingPass.$$$reportNull$$$0(8);
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)project2, (boolean)true);
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            HighlightInfo info = HighlightInfo.fromRangeHighlighter((RangeHighlighter)highlighter);
            if (info == null || info.type != TYPE) continue;
            highlighter.dispose();
        }
        XmlTagTreeHighlightingPass.clearLineMarkers(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeHighlightingPass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagRanges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearHighlightingAndLineMarkers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

