/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.collections;

import java.util.HashMap;
import java.util.Map;
import org.jitsi.utils.collections.MapEntry;

public class JMap {
    @SafeVarargs
    public static <K, V> Map<K, V> ofEntries(Map.Entry<K, V> ... entries) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        Map<K, V> map = JMap.of(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        Map<K, V> map = JMap.of(k1, v1, k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new MapEntry<K, V>(key, value);
    }
}

