/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.scrolling;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.SpringSpec;
import androidx.compose.foundation.ScrollState;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.text.TextLayoutResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.foundation.util.JewelLogger;
import org.jetbrains.jewel.markdown.MarkdownBlock;

@ExperimentalJewelApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00a6@\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0005H$J\b\u0010\u0012\u001a\u00020\u0005H$J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH&\u00a8\u0006 "}, d2={"Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer;", "", "<init>", "()V", "scrollToLine", "", "sourceLine", "", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "", "(ILandroidx/compose/animation/core/AnimationSpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "process", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "beforeProcessing", "afterProcessing", "acceptBlockSpans", "block", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "sourceRange", "Lkotlin/ranges/IntRange;", "acceptGlobalPosition", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "acceptTextLayout", "textLayout", "Landroidx/compose/ui/text/TextLayoutResult;", "Companion", "PerLine", "intellij.platform.jewel.markdown.core"})
@StabilityInferred(parameters=1)
public abstract class ScrollingSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Nullable
    public abstract Object scrollToLine(int var1, @NotNull AnimationSpec<Float> var2, @NotNull Continuation<? super Unit> var3);

    public static /* synthetic */ Object scrollToLine$default(ScrollingSynchronizer scrollingSynchronizer, int n, AnimationSpec animationSpec, Continuation continuation, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollToLine");
        }
        if ((n2 & 2) != 0) {
            animationSpec = (AnimationSpec)new SpringSpec(0.0f, 0.0f, null, 7, null);
        }
        return scrollingSynchronizer.scrollToLine(n, (AnimationSpec<Float>)animationSpec, (Continuation<? super Unit>)continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T process(@NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.beforeProcessing();
        try {
            object = action.invoke();
        }
        finally {
            this.afterProcessing();
        }
        return (T)object;
    }

    protected abstract void beforeProcessing();

    protected abstract void afterProcessing();

    public abstract void acceptBlockSpans(@NotNull MarkdownBlock var1, @NotNull IntRange var2);

    public abstract void acceptGlobalPosition(@NotNull MarkdownBlock var1, @NotNull LayoutCoordinates var2);

    public abstract void acceptTextLayout(@NotNull MarkdownBlock var1, @NotNull TextLayoutResult var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer;", "scrollState", "Landroidx/compose/foundation/gestures/ScrollableState;", "intellij.platform.jewel.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nScrollingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollingSynchronizer.kt\norg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$Companion\n+ 2 JewelLogger.kt\norg/jetbrains/jewel/foundation/util/JewelLoggerKt\n*L\n1#1,277:1\n9#2:278\n*S KotlinDebug\n*F\n+ 1 ScrollingSynchronizer.kt\norg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$Companion\n*L\n119#1:278\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ScrollingSynchronizer create(@NotNull ScrollableState scrollState) {
            ScrollingSynchronizer scrollingSynchronizer;
            Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
            ScrollableState scrollableState = scrollState;
            if (scrollableState instanceof ScrollState) {
                scrollingSynchronizer = new PerLine((ScrollState)scrollState);
            } else if (scrollableState instanceof LazyListState) {
                Companion $this$myLogger$iv = this;
                boolean $i$f$myLogger = false;
                JewelLogger.Companion.getInstance(Companion.class).warn("Synchronization for LazyListState is not supported yet");
                scrollingSynchronizer = null;
            } else {
                scrollingSynchronizer = null;
            }
            return scrollingSynchronizer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0014J\b\u0010\u001d\u001a\u00020\u0014H\u0014J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\fH\u0016J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$PerLine;", "Lorg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer;", "scrollState", "Landroidx/compose/foundation/ScrollState;", "<init>", "(Landroidx/compose/foundation/ScrollState;)V", "lines2Blocks", "Ljava/util/TreeMap;", "", "Lorg/jetbrains/jewel/markdown/MarkdownBlock;", "blocks2LineRanges", "", "Lkotlin/ranges/IntRange;", "blocks2Top", "previousPositions", "actualBlocks", "", "blocks2TextOffsets", "", "scrollToLine", "", "sourceLine", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "", "(ILandroidx/compose/animation/core/AnimationSpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBestBlockForLine", "line", "beforeProcessing", "afterProcessing", "acceptBlockSpans", "block", "sourceRange", "acceptGlobalPosition", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "acceptTextLayout", "textLayout", "Landroidx/compose/ui/text/TextLayoutResult;", "intellij.platform.jewel.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nScrollingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollingSynchronizer.kt\norg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$PerLine\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,277:1\n69#2:278\n70#3:279\n22#4:280\n*S KotlinDebug\n*F\n+ 1 ScrollingSynchronizer.kt\norg/jetbrains/jewel/markdown/scrolling/ScrollingSynchronizer$PerLine\n*L\n203#1:278\n203#1:279\n203#1:280\n*E\n"})
    private static final class PerLine
    extends ScrollingSynchronizer {
        @NotNull
        private final ScrollState scrollState;
        @NotNull
        private final TreeMap<Integer, MarkdownBlock> lines2Blocks;
        @NotNull
        private Map<MarkdownBlock, IntRange> blocks2LineRanges;
        @NotNull
        private final Map<MarkdownBlock, Integer> blocks2Top;
        @NotNull
        private final Map<MarkdownBlock, Integer> previousPositions;
        @NotNull
        private final Set<MarkdownBlock> actualBlocks;
        @NotNull
        private final Map<MarkdownBlock, List<Integer>> blocks2TextOffsets;

        public PerLine(@NotNull ScrollState scrollState) {
            Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
            this.scrollState = scrollState;
            this.lines2Blocks = new TreeMap();
            this.blocks2LineRanges = new LinkedHashMap();
            this.blocks2Top = new LinkedHashMap();
            this.previousPositions = new LinkedHashMap();
            this.actualBlocks = new LinkedHashSet();
            this.blocks2TextOffsets = new LinkedHashMap();
        }

        @Override
        @Nullable
        public Object scrollToLine(int sourceLine, @NotNull AnimationSpec<Float> animationSpec, @NotNull Continuation<? super Unit> $completion) {
            MarkdownBlock markdownBlock = this.findBestBlockForLine(sourceLine);
            if (markdownBlock == null) {
                return Unit.INSTANCE;
            }
            MarkdownBlock block = markdownBlock;
            Integer n = this.blocks2Top.get(block);
            if (n == null) {
                return Unit.INSTANCE;
            }
            int y = n;
            if (y < 0) {
                return Unit.INSTANCE;
            }
            IntRange intRange = this.blocks2LineRanges.get(block);
            if (intRange == null) {
                return Unit.INSTANCE;
            }
            IntRange lineRange = intRange;
            List<Integer> textOffsets = this.blocks2TextOffsets.get(block);
            int lineIndexInBlock = Math.max(0, sourceLine - lineRange.getStart());
            List<Integer> list = textOffsets;
            int lineOffset = list != null ? ((Number)list.get(lineIndexInBlock)).intValue() : 0;
            Object object = this.scrollState.animateScrollTo(y + lineOffset, animationSpec, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        private final MarkdownBlock findBestBlockForLine(int line) {
            SortedMap<Integer, MarkdownBlock> sm = this.lines2Blocks.subMap(line, Integer.MAX_VALUE);
            if (sm.isEmpty()) {
                return null;
            }
            Intrinsics.checkNotNull(sm);
            return (MarkdownBlock)MapsKt.getValue((Map)sm, (Object)sm.firstKey());
        }

        @Override
        protected void beforeProcessing() {
            this.lines2Blocks.clear();
            this.blocks2LineRanges.clear();
        }

        @Override
        protected void afterProcessing() {
            this.blocks2LineRanges.keySet().retainAll((Collection)this.actualBlocks);
            this.blocks2Top.keySet().retainAll((Collection)this.actualBlocks);
            this.blocks2TextOffsets.keySet().retainAll((Collection)this.actualBlocks);
            this.previousPositions.keySet().retainAll((Collection)this.actualBlocks);
            this.actualBlocks.clear();
        }

        @Override
        public void acceptBlockSpans(@NotNull MarkdownBlock block, @NotNull IntRange sourceRange) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)sourceRange, (String)"sourceRange");
            int line = sourceRange.getFirst();
            int n = sourceRange.getLast();
            if (line <= n) {
                while (true) {
                    this.lines2Blocks.putIfAbsent(line, block);
                    if (line == n) break;
                    ++line;
                }
            }
            this.blocks2LineRanges.put(block, sourceRange);
            ((Collection)this.actualBlocks).add(block);
        }

        @Override
        public void acceptGlobalPosition(@NotNull MarkdownBlock block, @NotNull LayoutCoordinates coordinates) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            long arg0$iv = LayoutCoordinatesKt.positionInRoot((LayoutCoordinates)coordinates);
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            boolean $i$f$floatFromBits = false;
            int y = (int)Float.intBitsToFloat(bits$iv$iv$iv) + this.scrollState.getValue();
            Integer oldY = this.previousPositions.get(block);
            if (oldY == null || y != oldY) {
                Integer n = y;
                this.blocks2Top.put(block, n);
                n = y;
                this.previousPositions.put(block, n);
            }
        }

        @Override
        public void acceptTextLayout(@NotNull MarkdownBlock block, @NotNull TextLayoutResult textLayout) {
            int n;
            int i;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)textLayout, (String)"textLayout");
            if (!(block instanceof MarkdownBlock.CodeBlock)) {
                return;
            }
            IntRange intRange = this.blocks2LineRanges.get(block);
            if (intRange == null) {
                return;
            }
            IntRange sourceLines = intRange;
            int y = 0;
            List list = new ArrayList();
            if (block instanceof MarkdownBlock.CodeBlock.FencedCodeBlock) {
                int openingLine = RangesKt.first((IntProgression)((IntProgression)sourceLines));
                int firstSourceLine = openingLine + 1;
                int closingLine = RangesKt.last((IntProgression)((IntProgression)sourceLines));
                Integer n2 = y;
                ((Collection)list).add(n2);
                for (int i2 = firstSourceLine; i2 < closingLine; ++i2) {
                    Integer n3 = y;
                    ((Collection)list).add(n3);
                    float lineHeight = textLayout.getLineBottom(i2 - firstSourceLine) - textLayout.getLineTop(i2 - firstSourceLine);
                    y += (int)lineHeight;
                }
                n2 = y;
                ((Collection)list).add(n2);
            } else if (block instanceof MarkdownBlock.CodeBlock.IndentedCodeBlock && (i = sourceLines.getFirst()) <= (n = sourceLines.getLast())) {
                while (true) {
                    Integer n4 = y;
                    ((Collection)list).add(n4);
                    float lineHeight = textLayout.getLineBottom(i - sourceLines.getFirst()) - textLayout.getLineTop(i - sourceLines.getFirst());
                    y += (int)lineHeight;
                    if (i == n) break;
                    ++i;
                }
            }
            this.blocks2TextOffsets.put(block, list);
        }
    }
}

