/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization;

import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesLexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u001aH\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010\u0006*\u00020\u0007*\u0002H\u00062!\u0010\b\u001a\u001d\u0012\u0013\u0012\u0011H\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u0002H\u00050\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010\u0018\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0012\u0010\u001b\u001a\u00020\u0017*\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d*\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0002\u001a\u0012\u0010\u001f\u001a\u00020\u0017*\u00020\u00102\u0006\u0010 \u001a\u00020\u001a\u001a\u0014\u0010!\u001a\u0004\u0018\u00010\u0017*\u00020\u00102\u0006\u0010 \u001a\u00020\u001a\u001a\u0012\u0010\"\u001a\u00020\u0017*\u00020\u00102\u0006\u0010#\u001a\u00020\u001a\u001a\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170$*\u00020%2\u0006\u0010\u001e\u001a\u00020\u0002\u001a\"\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001d2\u0006\u0010(\u001a\u00020\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170*\u001a \u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001d0\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d\u001a\u001e\u0010-\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00020.2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d\u001a\u0016\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00062"}, d2={"hasIntersectionWith", "", "Lkotlin/ranges/IntRange;", "other", "use", "T", "G", "Ljava/awt/Graphics;", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "g", "(Ljava/awt/Graphics;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "addEditorDocumentListener", "", "Lcom/intellij/openapi/editor/Editor;", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "getText", "", "Lcom/intellij/openapi/editor/Document;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getLineText", "line", "", "getCell", "getCells", "", "lines", "getCellByOrdinal", "ordinal", "safeGetCellByOrdinal", "getCellByOffset", "offset", "Lkotlin/sequences/Sequence;", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "makeMarkersFromIntervals", "Lcom/intellij/notebooks/visualization/NotebookCellLinesLexer$Marker;", "document", "intervals", "", "groupNeighborCells", "cells", "mergeAndJoinIntersections", "", "isLineVisible", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookVisualizationUiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookVisualizationUiUtil.kt\ncom/intellij/notebooks/visualization/NotebookVisualizationUiUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class NotebookVisualizationUiUtilKt {
    public static final boolean hasIntersectionWith(@NotNull IntRange $this$hasIntersectionWith, @NotNull IntRange other) {
        Intrinsics.checkNotNullParameter((Object)$this$hasIntersectionWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$hasIntersectionWith.getFirst() <= other.getLast() && $this$hasIntersectionWith.getLast() >= other.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, G extends Graphics> T use(@NotNull G $this$use, @NotNull Function1<? super G, ? extends T> handler) {
        Object object;
        Intrinsics.checkNotNullParameter($this$use, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$use = false;
        try {
            object = handler.invoke($this$use);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$use.dispose();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    public static final void addEditorDocumentListener(@NotNull Editor $this$addEditorDocumentListener, @NotNull DocumentListener listener2) {
        Intrinsics.checkNotNullParameter((Object)$this$addEditorDocumentListener, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (!($this$addEditorDocumentListener instanceof EditorImpl)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!((EditorImpl)$this$addEditorDocumentListener).isDisposed()) {
            ((EditorImpl)$this$addEditorDocumentListener).getDocument().addDocumentListener(listener2, ((EditorImpl)$this$addEditorDocumentListener).getDisposable());
        }
    }

    @NotNull
    public static final String getText(@NotNull Document $this$getText, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        String string = $this$getText.getText(new TextRange($this$getText.getLineStartOffset(interval.getLines().getFirst()), $this$getText.getLineEndOffset(interval.getLines().getLast())));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public static final String getLineText(@NotNull Document $this$getLineText, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineText, (String)"<this>");
        String string = $this$getLineText.getText(new TextRange($this$getLineText.getLineStartOffset(line), $this$getLineText.getLineEndOffset(line)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public static final NotebookCellLines.Interval getCell(@NotNull Editor $this$getCell, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$getCell, (String)"<this>");
        return NotebookCellLines.Companion.get($this$getCell).intervalsIterator(line).next();
    }

    @NotNull
    public static final List<NotebookCellLines.Interval> getCells(@NotNull Editor $this$getCells, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)$this$getCells, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return SequencesKt.toList(NotebookVisualizationUiUtilKt.getCells(NotebookCellLines.Companion.get($this$getCells), lines));
    }

    @NotNull
    public static final NotebookCellLines.Interval getCellByOrdinal(@NotNull Editor $this$getCellByOrdinal, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)$this$getCellByOrdinal, (String)"<this>");
        return NotebookCellLines.Companion.get($this$getCellByOrdinal).getIntervals().get(ordinal);
    }

    @Nullable
    public static final NotebookCellLines.Interval safeGetCellByOrdinal(@NotNull Editor $this$safeGetCellByOrdinal, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)$this$safeGetCellByOrdinal, (String)"<this>");
        return (NotebookCellLines.Interval)CollectionsKt.getOrNull(NotebookCellLines.Companion.get($this$safeGetCellByOrdinal).getIntervals(), (int)ordinal);
    }

    @NotNull
    public static final NotebookCellLines.Interval getCellByOffset(@NotNull Editor $this$getCellByOffset, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$getCellByOffset, (String)"<this>");
        return NotebookVisualizationUiUtilKt.getCell($this$getCellByOffset, $this$getCellByOffset.getDocument().getLineNumber(offset));
    }

    @NotNull
    public static final Sequence<NotebookCellLines.Interval> getCells(@NotNull NotebookCellLines $this$getCells, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)$this$getCells, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        return SequencesKt.takeWhile((Sequence)SequencesKt.asSequence((Iterator)$this$getCells.intervalsIterator(lines.getFirst())), arg_0 -> NotebookVisualizationUiUtilKt.getCells$lambda$0(lines, arg_0));
    }

    @NotNull
    public static final List<NotebookCellLinesLexer.Marker> makeMarkersFromIntervals(@NotNull Document document, @NotNull Iterable<NotebookCellLines.Interval> intervals) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(intervals, (String)"intervals");
        ArrayList<NotebookCellLinesLexer.Marker> markers = new ArrayList<NotebookCellLinesLexer.Marker>();
        for (NotebookCellLines.Interval interval : intervals) {
            if (interval.getMarkers().getHasTopLine()) {
                NotebookVisualizationUiUtilKt.makeMarkersFromIntervals$addMarker(document, markers, interval.getLines().getFirst(), interval.getType(), interval.getData());
            }
            if (!interval.getMarkers().getHasBottomLine()) continue;
            NotebookVisualizationUiUtilKt.makeMarkersFromIntervals$addMarker(document, markers, interval.getLines().getLast(), interval.getType(), interval.getData());
        }
        return markers;
    }

    @NotNull
    public static final List<List<NotebookCellLines.Interval>> groupNeighborCells(@NotNull List<NotebookCellLines.Interval> cells) {
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        SmartList groups = new SmartList();
        for (NotebookCellLines.Interval cell : cells) {
            boolean bl;
            Object object = (SmartList)CollectionsKt.lastOrNull((List)((List)groups));
            if (object != null && (object = (NotebookCellLines.Interval)CollectionsKt.last((List)((List)object))) != null) {
                Object it = object;
                boolean bl2 = false;
                bl = ((NotebookCellLines.Interval)it).getOrdinal() + 1 == cell.getOrdinal();
            } else {
                bl = false;
            }
            if (!bl) {
                groups.add((Object)new SmartList());
            }
            ((SmartList)CollectionsKt.last((List)((List)groups))).add((Object)cell);
        }
        return (List)groups;
    }

    public static final void mergeAndJoinIntersections(@NotNull List<IntRange> $this$mergeAndJoinIntersections, @NotNull List<IntRange> other) {
        Intrinsics.checkNotNullParameter($this$mergeAndJoinIntersections, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        List list = ContainerUtil.mergeSortedLists($this$mergeAndJoinIntersections, other, NotebookVisualizationUiUtilKt::mergeAndJoinIntersections$lambda$2, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mergeSortedLists(...)");
        List merged = list;
        $this$mergeAndJoinIntersections.clear();
        for (IntRange current : merged) {
            boolean bl;
            IntRange previous = (IntRange)CollectionsKt.removeLastOrNull($this$mergeAndJoinIntersections);
            if (previous == null) {
                Intrinsics.checkNotNull((Object)current);
                bl = $this$mergeAndJoinIntersections.add(current);
                continue;
            }
            if (previous.getLast() + 1 >= current.getFirst()) {
                bl = $this$mergeAndJoinIntersections.add(new IntRange(previous.getFirst(), Math.max(previous.getLast(), current.getLast())));
                continue;
            }
            $this$mergeAndJoinIntersections.add(previous);
            Intrinsics.checkNotNull((Object)current);
            bl = $this$mergeAndJoinIntersections.add(current);
        }
    }

    public static final boolean isLineVisible(@NotNull EditorImpl editor, int line) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int lineY = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
        Rectangle rectangle = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleAreaOnScrollingFinished(...)");
        Rectangle viewArea = rectangle;
        return viewArea.y <= lineY && lineY <= viewArea.y + viewArea.height;
    }

    private static final boolean getCells$lambda$0(IntRange $lines, NotebookCellLines.Interval it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLines().getFirst() <= $lines.getLast();
    }

    private static final void makeMarkersFromIntervals$addMarker(Document $document, ArrayList<NotebookCellLinesLexer.Marker> markers, int line, NotebookCellLines.CellType type, KeyFMap data) {
        int startOffset = $document.getLineStartOffset(line);
        int endOffset = line + 1 < $document.getLineCount() ? $document.getLineStartOffset(line + 1) : $document.getLineEndOffset(line);
        int length = endOffset - startOffset;
        markers.add(new NotebookCellLinesLexer.Marker(markers.size(), type, startOffset, length, data));
    }

    private static final int mergeAndJoinIntersections$lambda$2(IntRange o1, IntRange o2) {
        return o1.getFirst() - o2.getFirst();
    }
}

