/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.targets;

import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.targets.SingleScopeTestTarget;
import org.jetbrains.qodana.staticAnalysis.inspections.targets.TestTarget;
import org.jetbrains.qodana.staticAnalysis.scopes.QodanaAnalysisScope;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/QodanaTargetsService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "Lorg/jetbrains/annotations/NotNull;", "getTestTargets", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/TestTarget;", "tools", "", "", "Lcom/intellij/codeInspection/ex/Tools;", "createEachInspectionTargets", "createModuleInspectionTargets", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaTargetsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaTargetsService.kt\norg/jetbrains/qodana/staticAnalysis/inspections/targets/QodanaTargetsService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,38:1\n11158#2:39\n11493#2,3:40\n*S KotlinDebug\n*F\n+ 1 QodanaTargetsService.kt\norg/jetbrains/qodana/staticAnalysis/inspections/targets/QodanaTargetsService\n*L\n33#1:39\n33#1:40,3\n*E\n"})
public final class QodanaTargetsService {
    @NotNull
    private final Project project;
    @NotNull
    private final PathMacroManager macroManager;

    public QodanaTargetsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        this.macroManager = pathMacroManager;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<TestTarget> getTestTargets(@NotNull Map<String, ? extends Tools> tools) {
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        return CollectionsKt.plus((Collection)this.createEachInspectionTargets(tools, this.project), (Iterable)this.createModuleInspectionTargets(tools, this.project));
    }

    private final List<TestTarget> createEachInspectionTargets(Map<String, ? extends Tools> tools, Project project) {
        if (!Boolean.getBoolean("qodana.report.inspection.test")) {
            return CollectionsKt.emptyList();
        }
        Integer threshold = Integer.getInteger("qodana.report.inspection.test.threshold", 100);
        List list2 = CollectionsKt.toList((Iterable)tools.keySet());
        Intrinsics.checkNotNull((Object)threshold);
        return CollectionsKt.listOf((Object)new SingleScopeTestTarget("InspectionTest", list2, threshold, new QodanaAnalysisScope(project), this.macroManager));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TestTarget> createModuleInspectionTargets(Map<String, ? extends Tools> tools, Project project) {
        void $this$mapTo$iv$iv;
        Module[] modules;
        if (!Boolean.getBoolean("qodana.report.module.inspection.test")) {
            return CollectionsKt.emptyList();
        }
        Integer threshold = Integer.getInteger("qodana.report.inspection.test.threshold", 100);
        Module[] $this$map$iv = modules = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$map = false;
        Module[] moduleArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void module;
            void item$iv$iv;
            void var13_13 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = "ModuleInspectionTest[" + module.getName() + "]";
            List list2 = CollectionsKt.toList((Iterable)tools.keySet());
            Intrinsics.checkNotNull((Object)threshold);
            collection.add(new SingleScopeTestTarget(string, list2, threshold, new QodanaAnalysisScope((Module)module), this.macroManager));
        }
        return (List)destination$iv$iv;
    }
}

