/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.derived.FSLinearGradient;
import com.openhtmltopdf.pdfboxout.PdfBoxFastOutputDevice;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType3;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;

public class GradientHelper {
    public static PDShading createLinearGradient(PdfBoxFastOutputDevice od, AffineTransform transform2, FSLinearGradient gradient, Shape bounds) {
        PDShadingType2 shading = new PDShadingType2(new COSDictionary());
        shading.setShadingType(2);
        shading.setColorSpace(PDDeviceRGB.INSTANCE);
        Rectangle rect = bounds.getBounds();
        Point2D.Float ptStart = new Point2D.Float((float)gradient.getX1() + (float)rect.getMinX(), (float)gradient.getY1() + (float)rect.getMinY());
        Point2D.Float ptEnd = new Point2D.Float((float)gradient.getX2() + (float)rect.getMinX(), (float)gradient.getY2() + (float)rect.getMinY());
        Point2D ptStartDevice = transform2.transform(ptStart, null);
        Point2D ptEndDevice = transform2.transform(ptEnd, null);
        float startX = (float)ptStartDevice.getX();
        float startY = od.normalizeY((float)ptStartDevice.getY());
        float endX = (float)ptEndDevice.getX();
        float endY = od.normalizeY((float)ptEndDevice.getY());
        COSArray coords = new COSArray();
        coords.add(new COSFloat(startX));
        coords.add(new COSFloat(startY));
        coords.add(new COSFloat(endX));
        coords.add(new COSFloat(endY));
        shading.setCoords(coords);
        PDFunctionType3 type3 = GradientHelper.buildType3Function(gradient.getStopPoints(), (float)ptEnd.distance(ptStart));
        COSArray extend = new COSArray();
        extend.add(COSBoolean.FALSE);
        extend.add(COSBoolean.FALSE);
        shading.setFunction(type3);
        shading.setExtend(extend);
        return shading;
    }

    private static PDFunctionType3 buildType3Function(List<FSLinearGradient.StopPoint> stopPoints, float distance) {
        float max = stopPoints.get(stopPoints.size() - 1).getLength();
        COSDictionary function = new COSDictionary();
        function.setInt(COSName.FUNCTION_TYPE, 3);
        COSArray domain = new COSArray();
        domain.add(new COSFloat(0.0f));
        domain.add(new COSFloat(1.0f));
        COSArray encode = new COSArray();
        COSArray range = new COSArray();
        range.add(new COSFloat(0.0f));
        range.add(new COSFloat(1.0f));
        COSArray bounds = new COSArray();
        for (int i = 1; i < stopPoints.size() - 1; ++i) {
            float pos = stopPoints.get(i).getLength() / max * distance * (1.0f / distance);
            bounds.add(new COSFloat(pos));
        }
        COSArray functions = GradientHelper.buildType2Functions(stopPoints, domain, encode);
        function.setItem(COSName.FUNCTIONS, (COSBase)functions);
        function.setItem(COSName.BOUNDS, (COSBase)bounds);
        function.setItem(COSName.ENCODE, (COSBase)encode);
        PDFunctionType3 type3 = new PDFunctionType3(function);
        type3.setDomainValues(domain);
        return type3;
    }

    private static COSArray buildType2Functions(List<FSLinearGradient.StopPoint> stopPoints, COSArray domain, COSArray encode) {
        FSRGBColor prevColor = (FSRGBColor)stopPoints.get(0).getColor();
        COSArray functions = new COSArray();
        for (int i = 1; i < stopPoints.size(); ++i) {
            FSRGBColor color = (FSRGBColor)stopPoints.get(i).getColor();
            float[] component = new float[]{(float)prevColor.getRed() / 255.0f, (float)prevColor.getGreen() / 255.0f, (float)prevColor.getBlue() / 255.0f};
            PDColor prevPdColor = new PDColor(component, (PDColorSpace)PDDeviceRGB.INSTANCE);
            float[] component1 = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
            PDColor pdColor = new PDColor(component1, (PDColorSpace)PDDeviceRGB.INSTANCE);
            COSArray c0 = new COSArray();
            COSArray c1 = new COSArray();
            for (float component2 : prevPdColor.getComponents()) {
                c0.add(new COSFloat(component2));
            }
            for (float component3 : pdColor.getComponents()) {
                c1.add(new COSFloat(component3));
            }
            COSDictionary type2Function = new COSDictionary();
            type2Function.setInt(COSName.FUNCTION_TYPE, 2);
            type2Function.setItem(COSName.C0, (COSBase)c0);
            type2Function.setItem(COSName.C1, (COSBase)c1);
            type2Function.setInt(COSName.N, 1);
            type2Function.setItem(COSName.DOMAIN, (COSBase)domain);
            functions.add(type2Function);
            encode.add(new COSFloat(0.0f));
            encode.add(new COSFloat(1.0f));
            prevColor = color;
        }
        return functions;
    }
}

