/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.extend.impl;

import com.openhtmltopdf.extend.FSCacheEx;
import com.openhtmltopdf.extend.FSCacheValue;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class FSDefaultCacheStore
implements FSCacheEx<String, FSCacheValue> {
    private final Map<String, FSCacheValue> _store = new ConcurrentHashMap<String, FSCacheValue>();

    @Override
    public void put(String key, FSCacheValue value2) {
        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_PUTTING_KEY_IN_CACHE, key);
        this._store.put(key, value2);
    }

    @Override
    public FSCacheValue get(String key, Callable<? extends FSCacheValue> loader) {
        FSCacheValue value2;
        if (this._store.containsKey(key)) {
            return this.get(key);
        }
        try {
            value2 = loader.call();
            if (value2 != null) {
                this._store.put(key, value2);
            }
        }
        catch (Exception e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_COULD_NOT_CACHE_VALUE_FOR_KEY, (Object)key, e);
            value2 = null;
        }
        XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_CACHE_HIT_STATUS, (Object)(value2 == null ? "Missed" : "Hit"), (Object)key);
        return value2;
    }

    @Override
    public FSCacheValue get(String key) {
        FSCacheValue value2 = this._store.get(key);
        XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_CACHE_HIT_STATUS, (Object)(value2 == null ? "Missed" : "Hit"), (Object)key);
        return value2;
    }
}

