/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.IMetricConsumer;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/SumConsumer;", "Lcom/jetbrains/rd/platform/diagnostics/IMetricConsumer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "watchdogName", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/diagnostic/Logger;Ljava/lang/String;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getWatchdogName", "()Ljava/lang/String;", "sum", "", "n", "", "consumeValue", "", "value", "comment", "intellij.rd.platform"})
final class SumConsumer
implements IMetricConsumer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String watchdogName;
    private double sum;
    private int n;

    public SumConsumer(@NotNull Lifetime lifetime, @NotNull Logger logger, @NotNull String watchdogName) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)watchdogName, (String)"watchdogName");
        this.logger = logger;
        this.watchdogName = watchdogName;
        lifetime.onTermination(() -> SumConsumer._init_$lambda$0(this));
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getWatchdogName() {
        return this.watchdogName;
    }

    @Override
    public void consumeValue(double value2, @Nullable String comment) {
        this.sum += value2;
        if (this.logger.isTraceEnabled()) {
            int n = this.n;
            this.n = n + 1;
            StructuredLoggingKt.logMeasuredTime(this.logger, this.watchdogName + ".N" + n, (long)value2, comment);
        }
    }

    private static final Unit _init_$lambda$0(SumConsumer this$0) {
        StructuredLoggingKt.logMeasuredTime$default(this$0.logger, this$0.watchdogName + ".sum", (long)this$0.sum, null, 4, null);
        return Unit.INSTANCE;
    }
}

