## Python Tests Documentation

### Where to Find the Tests?

#### In the Repository
Our providers from the `com.intellij.scientific.py.tables.providers` package use Python code located in:
`intellij/community/python/helpers/pydev/_pydevd_bundle/tables`.

The tests for these Python files can be found in:
`intellij/community/python/helpers/pydev/pydev_tests_tables`.

#### In TeamCity
These tests require Python, and setting up the environment can take some time (about 2-10 minutes). Because of this, the tests run under a separate configuration named `PyDev Tables Tests`.

We test three Python versions:
- Python 2.7
- Python 3.8
- Python 3.12

Additionally, we have two variants of implementations for certain table frameworks:
- One for environments with the `pandas` package.
- Another for environments without `pandas`.

*Why two implementations?*

_We have two different implementations for frameworks like NumPy, PyTorch, and TensorFlow._

_To transfer data from the Python kernel, we use a specified format to serialize the tables' data in HTML or CSV. Since NumPy, PyTorch, and TensorFlow don't have built-in methods for dumping data in HTML format, we rely on `pandas` when available for this serialization. When `pandas` isn't installed, we use custom classes and functions to gather the data._

### Test Configurations

As a result, we have six different test configurations:
- `Tables, Linux, Python <version_number>`
- `Tables, Linux, Python <version_number>, without pandas`

### What Do We Check?

We validate several aspects of the Python tables, including:

- **Data Display**:
  - `get_data` with various formatting options.
  - `display_data_html` / `display_data_csv` with various formatting options.

- **Dataframe Meta Information**:
  - `get_type`, `get_shape`, `get_head`, `get_column_types` to collect meta-information about dataframes.

- **Statistics Data Collection (pandas, polars)**:
  - `get_column_descriptions` to collect statistical data.
  - `get_value_occurrences_count` collects data used for visualization in the stat headers.

- **Utility Functions**

- **Common Tests**:
  - Ensuring that all Python-side providers have the appropriate API for calls from the IDE-side:
    - All necessary methods exist.
    - Methods have correct arguments.

### How Are Python Table Tests Configured?

We use the `pytest` framework for running the tests.

To set up the testing environment with all required packages, we use `tox`.

You can find the `tox` configuration file here:
`intellij/community/python/helpers/pydev/pydev_tests_tables/tox.ini`.

