from _typeshed import StrPath
from lib2to3.pgen2 import grammar
from lib2to3.pgen2.tokenize import _TokenInfo
from typing import IO, Any, Iterable, Iterator, NoReturn, Text

class PgenGrammar(grammar.Grammar): ...

class ParserGenerator:
    filename: StrPath
    stream: IO[Text]
    generator: Iterator[_TokenInfo]
    first: dict[Text, dict[Text, int]]
    def __init__(self, filename: StrPath, stream: IO[Text] | None = ...) -> None: ...
    def make_grammar(self) -> PgenGrammar: ...
    def make_first(self, c: PgenGrammar, name: Text) -> dict[int, int]: ...
    def make_label(self, c: PgenGrammar, label: Text) -> int: ...
    def addfirstsets(self) -> None: ...
    def calcfirst(self, name: Text) -> None: ...
    def parse(self) -> tuple[dict[Text, list[DFAState]], Text]: ...
    def make_dfa(self, start: NFAState, finish: NFAState) -> list[DFAState]: ...
    def dump_nfa(self, name: Text, start: NFAState, finish: NFAState) -> list[DFAState]: ...
    def dump_dfa(self, name: Text, dfa: Iterable[DFAState]) -> None: ...
    def simplify_dfa(self, dfa: list[DFAState]) -> None: ...
    def parse_rhs(self) -> tuple[NFAState, NFAState]: ...
    def parse_alt(self) -> tuple[NFAState, NFAState]: ...
    def parse_item(self) -> tuple[NFAState, NFAState]: ...
    def parse_atom(self) -> tuple[NFAState, NFAState]: ...
    def expect(self, type: int, value: Any | None = ...) -> Text: ...
    def gettoken(self) -> None: ...
    def raise_error(self, msg: str, *args: Any) -> NoReturn: ...

class NFAState:
    arcs: list[tuple[Text | None, NFAState]]
    def __init__(self) -> None: ...
    def addarc(self, next: NFAState, label: Text | None = ...) -> None: ...

class DFAState:
    nfaset: dict[NFAState, Any]
    isfinal: bool
    arcs: dict[Text, DFAState]
    def __init__(self, nfaset: dict[NFAState, Any], final: NFAState) -> None: ...
    def addarc(self, next: DFAState, label: Text) -> None: ...
    def unifystate(self, old: DFAState, new: DFAState) -> None: ...
    def __eq__(self, other: DFAState) -> bool: ...  # type: ignore[override]

def generate_grammar(filename: StrPath = ...) -> PgenGrammar: ...
