/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.DelaunayTriangulationBuilder;
import org.locationtech.jts.triangulate.Segment;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;

public class ConformingDelaunayTriangulationBuilder {
    private Collection siteCoords;
    private Geometry constraintLines;
    private double tolerance = 0.0;
    private QuadEdgeSubdivision subdiv = null;
    private Map constraintVertexMap = new TreeMap();

    public void setSites(Geometry geom) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geom);
    }

    public void setConstraints(Geometry constraintLines) {
        this.constraintLines = constraintLines;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private void create() {
        if (this.subdiv != null) {
            return;
        }
        Envelope siteEnv = DelaunayTriangulationBuilder.envelope(this.siteCoords);
        List segments = new ArrayList();
        if (this.constraintLines != null) {
            siteEnv.expandToInclude(this.constraintLines.getEnvelopeInternal());
            this.createVertices(this.constraintLines);
            segments = ConformingDelaunayTriangulationBuilder.createConstraintSegments(this.constraintLines);
        }
        List sites = this.createSiteVertices(this.siteCoords);
        ConformingDelaunayTriangulator cdt = new ConformingDelaunayTriangulator(sites, this.tolerance);
        cdt.setConstraints(segments, new ArrayList(this.constraintVertexMap.values()));
        cdt.formInitialDelaunay();
        cdt.enforceConstraints();
        this.subdiv = cdt.getSubdivision();
    }

    private List createSiteVertices(Collection coords) {
        ArrayList<ConstraintVertex> verts = new ArrayList<ConstraintVertex>();
        for (Coordinate coord : coords) {
            if (this.constraintVertexMap.containsKey(coord)) continue;
            verts.add(new ConstraintVertex(coord));
        }
        return verts;
    }

    private void createVertices(Geometry geom) {
        Coordinate[] coords = geom.getCoordinates();
        for (int i2 = 0; i2 < coords.length; ++i2) {
            ConstraintVertex v = new ConstraintVertex(coords[i2]);
            this.constraintVertexMap.put(coords[i2], v);
        }
    }

    private static List createConstraintSegments(Geometry geom) {
        List lines = LinearComponentExtracter.getLines(geom);
        ArrayList constraintSegs = new ArrayList();
        for (LineString line : lines) {
            ConformingDelaunayTriangulationBuilder.createConstraintSegments(line, constraintSegs);
        }
        return constraintSegs;
    }

    private static void createConstraintSegments(LineString line, List constraintSegs) {
        Coordinate[] coords = line.getCoordinates();
        for (int i2 = 1; i2 < coords.length; ++i2) {
            constraintSegs.add(new Segment(coords[i2 - 1], coords[i2]));
        }
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public Geometry getEdges(GeometryFactory geomFact) {
        this.create();
        return this.subdiv.getEdges(geomFact);
    }

    public Geometry getTriangles(GeometryFactory geomFact) {
        this.create();
        return this.subdiv.getTriangles(geomFact);
    }
}

