/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.types;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.types.DasTypeSystemImpl;
import com.intellij.database.dialects.postgresbase.types.PgAnyArrayType;
import com.intellij.database.dialects.postgresbase.types.PgArrayType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/postgresbase/types/PgBaseTypeSystem;", "Lcom/intellij/database/dialects/base/types/DasTypeSystemImpl;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getNormalizedTypeName", "", "name", "getDefaultTypeName", "cat", "Lcom/intellij/database/types/DasTypeCategory;", "normalizeType", "Lcom/intellij/database/model/DataType;", "type", "getTypeCategoryByName", "typeName", "doCreateAnyArrayType", "Lcom/intellij/database/dialects/postgresbase/types/PgAnyArrayType;", "doCreateArrayType", "Lcom/intellij/database/dialects/postgresbase/types/PgArrayType;", "componentType", "Lcom/intellij/database/types/DasType;", "isTriggerFunctionType", "", "returnType", "intellij.database.dialects.postgresbase"})
public class PgBaseTypeSystem
extends DasTypeSystemImpl {
    public PgBaseTypeSystem(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String normalName = super.getNormalizedTypeName(name2);
        return StringsKt.endsWith$default((String)normalName, (String)"[]", (boolean)false, (int)2, null) ? this.getNormalizedTypeName(StringsKt.removeSuffix((String)normalName, (CharSequence)"[]")) + "[]" : (Intrinsics.areEqual((Object)normalName, (Object)"int8") ? "bigint" : (Intrinsics.areEqual((Object)normalName, (Object)"serial8") ? "bigserial" : (Intrinsics.areEqual((Object)normalName, (Object)"bool") ? "boolean" : (Intrinsics.areEqual((Object)normalName, (Object)"character varying") ? "varchar" : (Intrinsics.areEqual((Object)normalName, (Object)"float8") ? "double precision" : (Intrinsics.areEqual((Object)normalName, (Object)"int4") ? "integer" : (Intrinsics.areEqual((Object)normalName, (Object)"int") ? "integer" : (Intrinsics.areEqual((Object)normalName, (Object)"decimal") ? "numeric" : (Intrinsics.areEqual((Object)normalName, (Object)"float4") ? "real" : (Intrinsics.areEqual((Object)normalName, (Object)"int2") ? "smallint" : (Intrinsics.areEqual((Object)normalName, (Object)"serial4") ? "serial" : (Intrinsics.areEqual((Object)normalName, (Object)"serial2") ? "smallserial" : normalName))))))))))));
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull DasTypeCategory cat) {
        Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
        return switch (WhenMappings.$EnumSwitchMapping$0[cat.ordinal()]) {
            case 1 -> "integer";
            case 2 -> "numeric";
            case 3 -> "text";
            case 4 -> "boolean";
            case 5 -> "date";
            case 6 -> "date";
            case 7 -> "time";
            case 8 -> "timestamp";
            case 9 -> "interval";
            case 10 -> "bytea";
            case 11 -> "record";
            default -> null;
        };
    }

    @Override
    @NotNull
    public DataType normalizeType(@NotNull DataType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (StringsKt.equals((String)"without time zone", (String)type.suffix, (boolean)true)) {
            String string = type.schemaName;
            String string2 = type.typeName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeName");
            DataType dataType = DataTypeFactory.of(string, this.getNormalizedTypeName(string2), type.size, type.scale, type.sizeUnit, null, type.sizeUnitExplicit, type.custom, type.jdbcType);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            return dataType;
        }
        return super.normalizeType(type);
    }

    @Override
    @NotNull
    public DasTypeCategory getTypeCategoryByName(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)typeName, (Object)"record") ? DasTypeCategory.RECORD : super.getTypeCategoryByName(typeName);
    }

    @Override
    @NotNull
    protected PgAnyArrayType doCreateAnyArrayType() {
        return PgAnyArrayType.INSTANCE;
    }

    @Override
    @NotNull
    protected PgArrayType doCreateArrayType(@NotNull DasType componentType) {
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        return new PgArrayType(componentType);
    }

    @Override
    public boolean isTriggerFunctionType(@NotNull DasType returnType) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        String typeName = DasTypeUtilsKt.getTypeName(returnType);
        return StringsKt.equals((String)"trigger", (String)typeName, (boolean)true) || StringsKt.equals((String)"event_trigger", (String)typeName, (boolean)true);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasTypeCategory.values().length];
            try {
                nArray[DasTypeCategory.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.REAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE_TIME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.DATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.TIMESTAMP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.INTERVAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.BYTES.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasTypeCategory.RECORD.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

