/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.TextDecompositionNodes;
import com.intellij.database.dataSource.url.template.TextDecompositionUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public class TextDecomposition {
    private Boolean myMatched;
    private String myTextCache;
    private final Map<String, List<@NotNull TextDecompositionNodes.Parameter>> myParameters;
    private final StatelessTextDecomposition myStateless;
    private final TextDecompositionNodes.ListChoiceSNode myRoot;
    private List<TextRange> myInvalidRanges;
    private boolean myErroneous;

    @Nullable
    public TextRange getParameterRange(@NotNull String name2, int index) {
        if (name2 == null) {
            TextDecomposition.$$$reportNull$$$0(0);
        }
        this.validateText();
        TextDecompositionNodes.Matchable matchable = (TextDecompositionNodes.Matchable)ObjectUtils.tryCast((Object)this.getParameterNode(name2, index), TextDecompositionNodes.Matchable.class);
        return matchable != null && matchable.getFrom() != -1 ? TextRange.create((int)matchable.getFrom(), (int)matchable.getTo()) : null;
    }

    public void validateParameters() {
        this.validateText();
    }

    private static void collectParameters(@NotNull TextDecompositionNodes.SNode root, final @NotNull Map<String, List<TextDecompositionNodes.Parameter>> res) {
        if (root == null) {
            TextDecomposition.$$$reportNull$$$0(1);
        }
        if (res == null) {
            TextDecomposition.$$$reportNull$$$0(2);
        }
        res.clear();
        new TextDecompositionNodes.NodeVisitor<Void>(){

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                TextDecompositionNodes.Parameter param;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node instanceof TextDecompositionNodes.Parameter && (param = (TextDecompositionNodes.Parameter)((Object)node)).getName() != null) {
                    res.computeIfAbsent(param.getName(), k -> new ArrayList()).add(param);
                }
                node.visitChildren(this);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$1", "visit"));
            }
        }.visit(root);
    }

    public TextDecomposition(@NotNull StatelessTextDecomposition decomposition) {
        if (decomposition == null) {
            TextDecomposition.$$$reportNull$$$0(3);
        }
        this.myStateless = decomposition;
        this.myRoot = TextDecompositionNodes.create(decomposition.getNode());
        this.myParameters = new HashMap<String, List<TextDecompositionNodes.Parameter>>(1);
        TextDecomposition.collectParameters(this.myRoot, this.myParameters);
    }

    @NotNull
    public StatelessTextDecomposition getStateless() {
        StatelessTextDecomposition statelessTextDecomposition = this.myStateless;
        if (statelessTextDecomposition == null) {
            TextDecomposition.$$$reportNull$$$0(4);
        }
        return statelessTextDecomposition;
    }

    @TestOnly
    public String getPattern() {
        return this.myRoot.getStateless().getPattern();
    }

    public boolean isValid() {
        if (this.myMatched == null) {
            this.myMatched = this.isValidImpl();
        }
        return this.myMatched;
    }

    private boolean isValidImpl() {
        if (!this.myRoot.getStateless().matches(this.getText())) {
            return false;
        }
        return this.findMandatoryNodeMismatch() == false;
    }

    private Boolean findMandatoryNodeMismatch() {
        return new TextDecompositionNodes.NodeVisitor<Boolean>(){
            boolean mandatoryMismatch = false;

            @Override
            public Boolean visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.mandatoryMismatch) {
                    return true;
                }
                if (node instanceof TextDecompositionNodes.ListChoiceSNode) {
                    boolean bl = this.mandatoryMismatch = !node.isMatched() && ((TextDecompositionNodes.ListChoiceSNode)node).getStateless().isMandatory();
                    if (this.mandatoryMismatch) {
                        return true;
                    }
                }
                node.visitChildren(this);
                return this.mandatoryMismatch;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$2", "visit"));
            }
        }.visit(this.myRoot);
    }

    public void setTextTolerantly(@NotNull String text2) {
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(5);
        }
        this.validateText();
        if (text2.equals(this.myTextCache)) {
            return;
        }
        this.myTextCache = null;
        if (!this.matchCompletely(text2)) {
            this.matchIncrementally(text2);
        }
        TextDecomposition.collectParameters(this.myRoot, this.myParameters);
    }

    public void setText(@NotNull String text2) {
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(6);
        }
        if (text2.equals(this.myTextCache)) {
            return;
        }
        this.myTextCache = null;
        if (!this.matchCompletely(text2)) {
            this.matchFailed(text2);
        }
        TextDecomposition.collectParameters(this.myRoot, this.myParameters);
    }

    @NotNull
    public List<TextRange> getInvalidRanges() {
        this.validateText();
        List<TextRange> list = this.myInvalidRanges;
        if (list == null) {
            TextDecomposition.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public String getText() {
        this.validateText();
        String string = this.myTextCache;
        if (string == null) {
            TextDecomposition.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String findProperty(@NotNull String name2) {
        if (name2 == null) {
            TextDecomposition.$$$reportNull$$$0(9);
        }
        block0: for (TextDecompositionNodes.ListChoiceSNode node : TextDecompositionUtil.traverse(this.myRoot).filter(TextDecompositionNodes.ListChoiceSNode.class)) {
            JBIterable leaves;
            if (node == this.myRoot || !(leaves = TextDecompositionUtil.traverse(node).filter(TextDecompositionNodes.LeafSNode.class)).skip(3).isEmpty()) continue;
            int cnt = 0;
            for (TextDecompositionNodes.LeafSNode leaf : leaves) {
                if (++cnt == 1 && !StringUtil.equalsIgnoreCase((CharSequence)name2, (CharSequence)leaf.getText()) || cnt == 2 && !"=".equals(leaf.getText())) continue block0;
                if (cnt != 3) continue;
                return leaf.getText();
            }
        }
        return null;
    }

    public void setParameter(@NotNull String name2, int index, @NotNull String value) {
        TextDecompositionNodes.Parameter param;
        if (name2 == null) {
            TextDecomposition.$$$reportNull$$$0(10);
        }
        if (value == null) {
            TextDecomposition.$$$reportNull$$$0(11);
        }
        if ((param = this.getParameterNode(name2, index)) == null || value.equals(param.getValue())) {
            return;
        }
        param.setValue(value);
        this.myErroneous = false;
        this.purgeErrors();
        this.myMatched = value.isEmpty() || param.isValueValid(value) ? null : Boolean.FALSE;
    }

    public void purgeErrors() {
        TextDecompositionUtil.purgeBadGroups(this.myRoot);
        this.myTextCache = null;
    }

    @Nullable
    public String getParameter(@NotNull String name2, int index) {
        TextDecompositionNodes.Parameter param;
        if (name2 == null) {
            TextDecomposition.$$$reportNull$$$0(12);
        }
        return (param = this.getParameterNode(name2, index)) == null ? null : param.getValue();
    }

    @NotNull
    public @Unmodifiable List<String> getParameters(@NotNull String name2) {
        List<TextDecompositionNodes.Parameter> params;
        if (name2 == null) {
            TextDecomposition.$$$reportNull$$$0(13);
        }
        if ((params = this.myParameters.get(name2)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TextDecomposition.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = ContainerUtil.map(params, p2 -> p2.getValue());
        if (list == null) {
            TextDecomposition.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    private TextDecompositionNodes.Parameter getParameterNode(@NotNull String name2, int index) {
        List<TextDecompositionNodes.Parameter> params;
        if (name2 == null) {
            TextDecomposition.$$$reportNull$$$0(16);
        }
        if ((params = this.myParameters.get(name2)) == null || params.size() <= index) {
            return null;
        }
        return params.get(index);
    }

    private void validateText() {
        if (this.myTextCache == null) {
            this.checkOptionals();
            TextDecompositionUtil.resetDisabledMatchables(this.myRoot);
            StringBuilder builder = new StringBuilder();
            TextDecompositionUtil.buildText(builder, this.myRoot);
            this.myInvalidRanges = TextDecompositionUtil.extractBadRanges(this.myRoot);
            this.myTextCache = builder.toString();
        }
    }

    private void checkOptionals() {
        new TextDecompositionUtil.SimpleNodeVisitor<ThreeState>(){

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ParameterSNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                return ThreeState.fromBoolean((!node.getText().isEmpty() || node.getBadGroup() != null ? 1 : 0) != 0);
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.TextSNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(1);
                }
                return node.getBadGroup() != null ? ThreeState.YES : ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.CompositeSNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(2);
                }
                ThreeState res = ThreeState.UNSURE;
                for (TextDecompositionNodes.SNode c2 : node.getChildren()) {
                    ThreeState tmp = (ThreeState)this.visit(c2);
                    if (tmp == ThreeState.YES && res != ThreeState.NO) {
                        res = ThreeState.YES;
                        continue;
                    }
                    if (tmp != ThreeState.NO) continue;
                    res = ThreeState.NO;
                }
                return res;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.OptionalSNode node) {
                ThreeState res;
                if (node == null) {
                    3.$$$reportNull$$$0(3);
                }
                ThreeState threeState = res = node.getBadGroup() != null ? ThreeState.YES : (ThreeState)this.visit(node.getNode());
                if (res != ThreeState.UNSURE) {
                    node.setEnabled(node.isMatched() && TextDecomposition.this.myErroneous || res.toBoolean());
                } else {
                    node.setEnabled(node.isMatched());
                }
                return node.isEnabled() ? ThreeState.YES : ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.AntiSNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(4);
                }
                return ThreeState.UNSURE;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ListSNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(5);
                }
                ThreeState res = ThreeState.NO;
                for (TextDecompositionNodes.ListChoiceSNode c2 : node.getMatches()) {
                    ThreeState tmp = this.visit(c2);
                    if (tmp != ThreeState.YES) continue;
                    res = ThreeState.YES;
                }
                return res;
            }

            @Override
            public ThreeState visit(@NotNull TextDecompositionNodes.ListChoiceSNode node) {
                ThreeState res;
                if (node == null) {
                    3.$$$reportNull$$$0(6);
                }
                if ((res = (ThreeState)this.visit(node.getRoot())) != ThreeState.UNSURE) {
                    node.setEnabled(node.isMatched() && TextDecomposition.this.myErroneous || res.toBoolean());
                } else {
                    node.setEnabled(node.isMatched());
                }
                return ThreeState.fromBoolean((boolean)node.isEnabled());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$3", "visit"));
            }
        }.visit(this.myRoot);
        this.myRoot.setEnabled(true);
    }

    private boolean matchCompletely(@NotNull String text2) {
        boolean stopMatching;
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(17);
        }
        if (stopMatching = this.myRoot.getStateless().matches(text2)) {
            this.myRoot.setMatch(text2);
        }
        boolean matched = stopMatching && this.findMandatoryNodeMismatch() == false;
        this.myErroneous = !matched;
        this.myMatched = matched;
        return stopMatching;
    }

    private void matchIncrementally(@NotNull String text2) {
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(18);
        }
        this.myRoot.matchIncrementally(text2, null);
    }

    private void matchFailed(final @NotNull String text2) {
        if (text2 == null) {
            TextDecomposition.$$$reportNull$$$0(19);
        }
        new TextDecompositionNodes.NodeVisitor<Void>(){
            private final TextDecompositionNodes.BadGroup myBadGroup;
            {
                this.myBadGroup = new TextDecompositionNodes.BadGroup(text2);
            }

            @Override
            public Void visit(@NotNull TextDecompositionNodes.SNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (node instanceof TextDecompositionNodes.LeafSNode) {
                    ((TextDecompositionNodes.LeafSNode)node).setBadGroup(this.myBadGroup);
                }
                if (node instanceof TextDecompositionNodes.OptionalSNode) {
                    ((TextDecompositionNodes.OptionalSNode)node).setEnabled(false);
                    return null;
                }
                if (node instanceof TextDecompositionNodes.ListChoiceSNode && node != TextDecomposition.this.myRoot) {
                    ((TextDecompositionNodes.ListChoiceSNode)node).setEnabled(false);
                    return null;
                }
                node.visitChildren(this);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/url/template/TextDecomposition$4", "visit"));
            }
        }.visit(this.myRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decomposition";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/TextDecomposition";
                break;
            }
            case 5: 
            case 6: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/TextDecomposition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateless";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParameterRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setTextTolerantly";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setParameter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "matchCompletely";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "matchIncrementally";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "matchFailed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 14, 15 -> new IllegalStateException(string);
        };
    }

    public static interface PatternFactory {
        @Nullable
        public Pattern getPattern(@NotNull String var1, @Nullable String var2, @Nullable String var3);
    }
}

