/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.microservices.actions;

import com.intellij.httpClient.actions.generation.HttpRequestGenerationManager;
import com.intellij.httpClient.actions.generation.HttpRequestPresentableError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlContextError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfoError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.microservices.endpoints.FromUrlTargetInfosConversionResult;
import com.intellij.httpClient.http.request.microservices.endpoints.HttpClientTabUtilsKt;
import com.intellij.httpClient.http.request.microservices.endpoints.UrlTargetInfoEx;
import com.intellij.httpClient.microservices.actions.HttpGenerateRequestFromEndpointsActionKt;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.PsiElementNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/microservices/actions/HttpGenerateRequestFromEndpointsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "defaultNotificationGroup", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "showNotification", "project", "Lcom/intellij/openapi/project/Project;", "invalidUrlTargetInfos", "", "Lcom/intellij/httpClient/http/request/microservices/endpoints/UrlTargetInfoEx;", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "MyNotification", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpGenerateRequestFromEndpointsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpGenerateRequestFromEndpointsAction.kt\ncom/intellij/httpClient/microservices/actions/HttpGenerateRequestFromEndpointsAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n1563#2:93\n1634#2,2:94\n1636#2:97\n1#3:96\n13472#4,2:98\n*S KotlinDebug\n*F\n+ 1 HttpGenerateRequestFromEndpointsAction.kt\ncom/intellij/httpClient/microservices/actions/HttpGenerateRequestFromEndpointsAction\n*L\n54#1:93\n54#1:94,2\n54#1:97\n81#1:98,2\n*E\n"})
public final class HttpGenerateRequestFromEndpointsAction
extends AnAction {
    private final NotificationGroup defaultNotificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("http.generation.notifications");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Iterable urlInfos = (Iterable)e.getData(EndpointsProvider.URL_TARGET_INFO);
        if (urlInfos == null) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Iterable iterable = (Iterable)e.getData(EndpointsProvider.URL_TARGET_INFO);
        if (iterable == null) {
            return;
        }
        Iterable endpointsData = iterable;
        List urls = CollectionsKt.toList((Iterable)endpointsData);
        if (urls.isEmpty()) {
            return;
        }
        FromUrlTargetInfosConversionResult fromUrlTargetInfosConversionResult = HttpClientTabUtilsKt.getGenerationRequestsFromUrlTargetInfos(project2, urls);
        List<HttpRequestUrlsGenerationRequest> requests2 = fromUrlTargetInfosConversionResult.component1();
        List<UrlTargetInfoEx<HttpRequestUrlContextError>> errorContexts = fromUrlTargetInfosConversionResult.component2();
        List<UrlTargetInfoEx<HttpRequestUrlPathInfoError>> invalidUrls = fromUrlTargetInfosConversionResult.component3();
        if (!((Collection)errorContexts).isEmpty()) {
            this.showNotification(project2, errorContexts);
        }
        if (!((Collection)invalidUrls).isEmpty()) {
            this.showNotification(project2, invalidUrls);
        }
        if (!((Collection)requests2).isEmpty()) {
            new HttpRequestGenerationManager(project2).generateRequestsInHttpEditor(requests2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showNotification(Project project, List<? extends UrlTargetInfoEx<? extends HttpRequestPresentableError>> invalidUrlTargetInfos) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NotificationGroup notificationGroup = this.defaultNotificationGroup;
        Iterable iterable = invalidUrlTargetInfos;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SmartPsiElementPointer smartPsiElementPointer;
            void it;
            UrlTargetInfoEx urlTargetInfoEx = (UrlTargetInfoEx)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiElement psiElement = it.getUrl().resolveToPsiElement();
            if (psiElement != null && (psiElement = psiElement.getNavigationElement()) != null) {
                PsiElement el = psiElement;
                boolean bl2 = false;
                smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)el);
            } else {
                smartPsiElementPointer = null;
            }
            collection.add(smartPsiElementPointer);
        }
        List pointers2 = (List)destination$iv$iv;
        String string = RestClientBundle.message("http.request.microservices.generate.from.endpoints.view.fail.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = RestClientBundle.message("http.request.microservices.generate.from.endpoints.view.fail.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        MyNotification notification = new MyNotification(notificationGroup.createNotification(string, string2, NotificationType.ERROR));
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)invalidUrlTargetInfos)) {
            String msg;
            Object[] objectArray = new Object[]{((HttpRequestPresentableError)((UrlTargetInfoEx)indexedValue.getValue()).getAdditionalInfo()).getMessage(), ((UrlTargetInfoEx)indexedValue.getValue()).getUrl().getPath().getPresentation()};
            Intrinsics.checkNotNullExpressionValue((Object)RestClientBundle.message("http.request.microservices.generate.from.endpoints.view.fail.concrete.message", objectArray), (String)"message(...)");
            notification.addAction((AnAction)NotificationAction.create((String)msg, arg_0 -> HttpGenerateRequestFromEndpointsAction.showNotification$lambda$4(arg_0 -> HttpGenerateRequestFromEndpointsAction.showNotification$lambda$3(project, invalidUrlTargetInfos, pointers2, indexedValue, arg_0), arg_0)));
        }
        notification.setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification.setDropDownText(RestClientBundle.message("http.request.microservices.generate.from.endpoints.view.fail.dropdown", new Object[0]));
        notification.whenExpired(() -> HttpGenerateRequestFromEndpointsAction.showNotification$lambda$6(project));
        notification.notify(project);
    }

    private static final Unit showNotification$lambda$3(Project $project, List $invalidUrlTargetInfos, List $pointers, IndexedValue $indexedValue, AnActionEvent anActionEvent) {
        block0: {
            HttpGenerateRequestFromEndpointsActionKt.access$countStatistics($project, $invalidUrlTargetInfos);
            SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)$pointers.get($indexedValue.getIndex());
            if (smartPsiElementPointer == null || (smartPsiElementPointer = smartPsiElementPointer.getElement()) == null) break block0;
            SmartPsiElementPointer navigationElement = smartPsiElementPointer;
            boolean bl = false;
            new PsiElementNavigatable((PsiElement)navigationElement).navigate(true);
        }
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void showNotification$lambda$6(Project $project) {
        NotificationsManager manager = NotificationsManager.getNotificationsManager();
        Notification[] notificationArray = manager.getNotificationsOfType(MyNotification.class, $project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        Object[] $this$forEach$iv = notificationArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MyNotification it = (MyNotification)((Object)element$iv);
            boolean bl = false;
            manager.expire((Notification)it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/httpClient/microservices/actions/HttpGenerateRequestFromEndpointsAction$MyNotification;", "Lcom/intellij/notification/Notification;", "delegate", "<init>", "(Lcom/intellij/notification/Notification;)V", "intellij.restClient"})
    private static final class MyNotification
    extends Notification {
        public MyNotification(@NotNull Notification delegate2) {
            Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
            super(delegate2.getGroupId(), delegate2.getTitle(), delegate2.getContent(), delegate2.getType());
        }
    }
}

