/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa;

import com.intellij.httpClient.http.request.run.js.graalvm.StringUtilsKt;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.EncryptionAlgorithm;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.JsRsaCryptoKey;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.RsaCryptoKey;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.RsaCryptoSupportKt;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.RsaKeyAlgorithm;
import com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa.SigningAlgorithm;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.eac.RSAPublicKey;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J$\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007J&\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0019\u001a\u00020\u000fJ&\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010\u0019\u001a\u00020\u000fJ&\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010\u0019\u001a\u00020\u000fJ,\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0019\u001a\u00020\u000fJ\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0011\u001a\u00020\fH\u0016J!\u0010#\u001a\u0004\u0018\u00010\u001e2\u0010\u0010$\u001a\f\u0012\u0006\b\u0001\u0012\u00020%\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u001c\u0010*\u001a\u00020+2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010,\u001a\u0004\u0018\u00010%H\u0016\u00a8\u0006-"}, d2={"Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/SubtleCrypto;", "Lorg/graalvm/polyglot/proxy/ProxyObject;", "<init>", "()V", "generateKeyInternal", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/RsaCryptoKey;", "rsaKeyAlgorithm", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/RsaKeyAlgorithm;", "exportable", "", "keyUsage", "", "", "(Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/RsaKeyAlgorithm;Z[Ljava/lang/String;)Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/RsaCryptoKey;", "exportKeyInternal", "", "format", "key", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/JsRsaCryptoKey;", "importKeyInternal", "keyData", "algorithm", "encryptInternal", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/EncryptionAlgorithm;", "Ljava/security/PublicKey;", "data", "decryptInternal", "Ljava/security/PrivateKey;", "signInternal", "signingAlgorithm", "Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/SigningAlgorithm;", "verifyInternal", "signature", "getMember", "", "extractSignatureAlgoritm", "arguments", "Lorg/graalvm/polyglot/Value;", "([Lorg/graalvm/polyglot/Value;)Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/SigningAlgorithm;", "getMemberKeys", "()[Ljava/lang/String;", "hasMember", "putMember", "", "value", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nRsaCryptoSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsaCryptoSupport.kt\ncom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/SubtleCrypto\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1#2:330\n*E\n"})
public final class SubtleCrypto
implements ProxyObject {
    @Nullable
    public final RsaCryptoKey generateKeyInternal(@NotNull RsaKeyAlgorithm rsaKeyAlgorithm, boolean exportable, @NotNull String[] keyUsage) {
        String hash;
        Intrinsics.checkNotNullParameter((Object)rsaKeyAlgorithm, (String)"rsaKeyAlgorithm");
        Intrinsics.checkNotNullParameter((Object)keyUsage, (String)"keyUsage");
        if (!Intrinsics.areEqual((Object)rsaKeyAlgorithm.getName(), (Object)"RSA-OAEP") && !Intrinsics.areEqual((Object)rsaKeyAlgorithm.getName(), (Object)"RSA-PSS")) {
            return null;
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstanceStrong();
        byte[] byArray = rsaKeyAlgorithm.getPublicExponent();
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            random.setSeed(it);
        }
        Integer n = rsaKeyAlgorithm.getModulusLength();
        int keyLength = n != null ? n : 2048;
        keyGen.initialize(keyLength, random);
        KeyPair keyPair = keyGen.generateKeyPair();
        String string = rsaKeyAlgorithm.getHash();
        if (string == null) {
            string = "SHA-256";
        }
        if (!Intrinsics.areEqual((Object)(hash = string), (Object)"SHA-256") && !Intrinsics.areEqual((Object)hash, (Object)"SHA-512")) {
            return null;
        }
        JsRsaCryptoKey<PublicKey> publicKey = new JsRsaCryptoKey<PublicKey>(keyPair.getPublic(), hash, keyLength, exportable, keyUsage);
        JsRsaCryptoKey<PrivateKey> privateKey = new JsRsaCryptoKey<PrivateKey>(keyPair.getPrivate(), hash, keyLength, exportable, keyUsage);
        return new RsaCryptoKey(publicKey, privateKey);
    }

    @Nullable
    public final byte[] exportKeyInternal(@NotNull String format, @NotNull JsRsaCryptoKey<?> key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        String string = format;
        if (Intrinsics.areEqual((Object)string, (Object)"pkcs8")) {
            Object obj = key.getKey();
            PrivateKey privateKey = obj instanceof PrivateKey ? (PrivateKey)obj : null;
            object = privateKey != null ? privateKey.getEncoded() : null;
        } else if (Intrinsics.areEqual((Object)string, (Object)"spki")) {
            Object obj = key.getKey();
            PublicKey publicKey = obj instanceof PublicKey ? (PublicKey)obj : null;
            object = publicKey != null ? publicKey.getEncoded() : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final JsRsaCryptoKey<?> importKeyInternal(@NotNull String format, @NotNull byte[] keyData, @NotNull RsaKeyAlgorithm algorithm) {
        JsRsaCryptoKey<PrivateKey> jsRsaCryptoKey;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)keyData, (String)"keyData");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        if (!Intrinsics.areEqual((Object)algorithm.getName(), (Object)"RSA-OAEP") && !Intrinsics.areEqual((Object)algorithm.getName(), (Object)"RSA-PSS")) {
            return null;
        }
        String string = format;
        if (Intrinsics.areEqual((Object)string, (Object)"pkcs8")) {
            Serializable serializable;
            PKCS8EncodedKeySpec privateKeyData = new PKCS8EncodedKeySpec(keyData);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeyData);
            String[] stringArray = new String[]{"decrypt", "sign"};
            JsRsaCryptoKey<PrivateKey> jsRsaCryptoKey2 = new JsRsaCryptoKey<PrivateKey>(privateKey, algorithm.getHash(), (serializable = privateKey instanceof RSAPrivateKey ? (RSAPrivateKey)privateKey : null) != null && (serializable = serializable.getModulus()) != null ? ((BigInteger)serializable).intValue() : 2024, true, stringArray);
            jsRsaCryptoKey = jsRsaCryptoKey2;
        } else if (Intrinsics.areEqual((Object)string, (Object)"spki")) {
            Object object;
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(keyData));
            String[] stringArray = new String[]{"encrypt", "verify"};
            JsRsaCryptoKey<PublicKey> jsRsaCryptoKey3 = new JsRsaCryptoKey<PublicKey>(publicKey, algorithm.getHash(), (object = publicKey instanceof RSAPublicKey ? (RSAPublicKey)publicKey : null) != null && (object = object.getModulus()) != null ? ((BigInteger)object).intValue() : 2024, true, stringArray);
            jsRsaCryptoKey = jsRsaCryptoKey3;
        } else {
            jsRsaCryptoKey = null;
        }
        return jsRsaCryptoKey;
    }

    @Nullable
    public final byte[] encryptInternal(@NotNull EncryptionAlgorithm algorithm, @NotNull JsRsaCryptoKey<PublicKey> key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)algorithm.getName(), (Object)"RSA-OAEP")) {
            return null;
        }
        Cipher encryptCipher = Cipher.getInstance("RSA/ECB/OAEPWith" + key.getHash() + "AndMGF1Padding");
        encryptCipher.init(1, key.getKey());
        return encryptCipher.doFinal(data);
    }

    @Nullable
    public final byte[] decryptInternal(@NotNull EncryptionAlgorithm algorithm, @NotNull JsRsaCryptoKey<PrivateKey> key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)algorithm.getName(), (Object)"RSA-OAEP")) {
            return null;
        }
        Cipher decryptCipher = Cipher.getInstance("RSA/ECB/OAEPWith" + key.getHash() + "AndMGF1Padding");
        decryptCipher.init(2, key.getKey());
        return decryptCipher.doFinal(data);
    }

    @Nullable
    public final byte[] signInternal(@NotNull SigningAlgorithm signingAlgorithm, @NotNull JsRsaCryptoKey<PrivateKey> key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)signingAlgorithm, (String)"signingAlgorithm");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)signingAlgorithm.getName(), (Object)"RSA-PSS")) {
            return null;
        }
        if (!ArraysKt.contains((Object[])key.getUsages(), (Object)"sign")) {
            return null;
        }
        Long l = signingAlgorithm.getSaltLength();
        PSSParameterSpec pssSpec = new PSSParameterSpec(key.getHash(), "MGF1", new MGF1ParameterSpec(key.getHash()), l != null ? (int)l.longValue() : 64, 1);
        Signature signature = Signature.getInstance("RSASSA-PSS");
        Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"getInstance(...)");
        Signature signer = signature;
        signer.setParameter(pssSpec);
        signer.initSign(key.getKey());
        signer.update(data);
        return signer.sign();
    }

    public final boolean verifyInternal(@NotNull SigningAlgorithm signingAlgorithm, @NotNull byte[] signature, @NotNull JsRsaCryptoKey<PublicKey> key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)signingAlgorithm, (String)"signingAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)signingAlgorithm.getName(), (Object)"RSA-PSS")) {
            return false;
        }
        if (!ArraysKt.contains((Object[])key.getUsages(), (Object)"verify")) {
            return false;
        }
        Long l = signingAlgorithm.getSaltLength();
        PSSParameterSpec pssSpec = new PSSParameterSpec(key.getHash(), "MGF1", new MGF1ParameterSpec(key.getHash()), l != null ? (int)l.longValue() : 64, 1);
        Signature verifier = Signature.getInstance("RSASSA-PSS");
        verifier.setParameter(pssSpec);
        verifier.initVerify(key.getKey());
        verifier.update(data);
        return verifier.verify(signature);
    }

    @Nullable
    public Object getMember(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return switch (key) {
            case "generateKey" -> arg_0 -> SubtleCrypto.getMember$lambda$2(this, arg_0);
            case "encrypt" -> arg_0 -> SubtleCrypto.getMember$lambda$3(this, arg_0);
            case "decrypt" -> arg_0 -> SubtleCrypto.getMember$lambda$4(this, arg_0);
            case "sign" -> arg_0 -> SubtleCrypto.getMember$lambda$5(this, arg_0);
            case "verify" -> arg_0 -> SubtleCrypto.getMember$lambda$6(this, arg_0);
            case "exportKey" -> arg_0 -> SubtleCrypto.getMember$lambda$7(this, arg_0);
            case "importKey" -> arg_0 -> SubtleCrypto.getMember$lambda$9(this, arg_0);
            default -> null;
        };
    }

    private final SigningAlgorithm extractSignatureAlgoritm(Value[] arguments) {
        Object object = arguments;
        if (object == null || (object = (Value)ArraysKt.getOrNull((Object[])object, (int)0)) == null || (object = object.getMember("name")) == null || (object = object.asString()) == null) {
            return null;
        }
        Object algorithmName = object;
        Value value2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
        Long saltLength = value2 != null && (value2 = value2.getMember("saltLength")) != null ? Long.valueOf(value2.asLong()) : null;
        return new SigningAlgorithm((String)algorithmName, saltLength);
    }

    @NotNull
    public String[] getMemberKeys() {
        String[] stringArray = new String[]{"generateKey", "exportKey", "importKey", "encrypt", "decrypt", "sign", "verify"};
        return stringArray;
    }

    public boolean hasMember(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ArraysKt.contains((Object[])this.getMemberKeys(), (Object)key);
    }

    public void putMember(@Nullable String key, @Nullable Value value2) {
    }

    private static final Object getMember$lambda$2(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        Value algorithmValue;
        Intrinsics.checkNotNull((Object)arguments);
        Value value2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
        if (value2 != null) {
            algorithmValue = value2;
            boolean bl = false;
            object = algorithmValue.getMember("name");
            if (object == null || (object = object.asString()) == null) {
                return null;
            }
        } else {
            return null;
        }
        Object name = object;
        Value value3 = algorithmValue.getMember("hash");
        String hash = value3 != null ? value3.asString() : null;
        Value value4 = algorithmValue.getMember("modulusLength");
        Integer modulusLength = value4 != null ? Integer.valueOf(value4.asInt()) : null;
        Value value5 = algorithmValue.getMember("publicExponent");
        byte[] publicExponent = (byte[])(value5 != null ? StringUtilsKt.asByteArray(value5) : null);
        RsaKeyAlgorithm algorithm = new RsaKeyAlgorithm((String)name, modulusLength, publicExponent, hash);
        Value value6 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (value6 == null) {
            return null;
        }
        boolean extractable = value6.asBoolean();
        String[] stringArray = (String[])ArraysKt.getOrNull((Object[])arguments, (int)2);
        if (stringArray == null || (stringArray = RsaCryptoSupportKt.access$asStringArray((Value)stringArray)) == null) {
            return null;
        }
        String[] keyUsages = stringArray;
        RsaCryptoKey key = this$0.generateKeyInternal(algorithm, extractable, keyUsages);
        Pair[] pairArray = new Pair[2];
        Pair[] pairArray2 = new Pair[5];
        pairArray2[0] = TuplesKt.to((Object)"type", (Object)"private");
        pairArray2[1] = TuplesKt.to((Object)"extractable", (Object)extractable);
        pairArray2[2] = TuplesKt.to((Object)"algorithm", (Object)ArraysKt.getOrNull((Object[])arguments, (int)0));
        pairArray2[3] = TuplesKt.to((Object)"usages", (Object)ArraysKt.getOrNull((Object[])arguments, (int)2));
        RsaCryptoKey rsaCryptoKey = key;
        pairArray2[4] = TuplesKt.to((Object)"_handle", rsaCryptoKey != null ? rsaCryptoKey.getPrivateKey() : null);
        pairArray[0] = TuplesKt.to((Object)"privateKey", (Object)ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray2)));
        pairArray2 = new Pair[5];
        pairArray2[0] = TuplesKt.to((Object)"type", (Object)"public");
        pairArray2[1] = TuplesKt.to((Object)"extractable", (Object)extractable);
        pairArray2[2] = TuplesKt.to((Object)"algorithm", (Object)ArraysKt.getOrNull((Object[])arguments, (int)0));
        pairArray2[3] = TuplesKt.to((Object)"usages", (Object)ArraysKt.getOrNull((Object[])arguments, (int)2));
        RsaCryptoKey rsaCryptoKey2 = key;
        pairArray2[4] = TuplesKt.to((Object)"_handle", rsaCryptoKey2 != null ? rsaCryptoKey2.getPublicKey() : null);
        pairArray[1] = TuplesKt.to((Object)"publicKey", (Object)ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray2)));
        return ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray));
    }

    private static final Object getMember$lambda$3(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        Object keyRaw;
        Object algorithmName;
        block7: {
            block6: {
                Intrinsics.checkNotNull((Object)arguments);
                Object object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
                if (object2 == null || (object2 = object2.getMember("name")) == null || (object2 = object2.asString()) == null) {
                    return null;
                }
                algorithmName = object2;
                Object object3 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
                if (object3 == null || (object3 = object3.getMember("_handle")) == null || (object3 = (JsRsaCryptoKey)object3.as(JsRsaCryptoKey.class)) == null) {
                    return null;
                }
                keyRaw = object3;
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)2);
                if (object == null) break block6;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block7;
            }
            return null;
        }
        Object data = object;
        Object object4 = keyRaw instanceof JsRsaCryptoKey ? keyRaw : null;
        if (object4 == null) {
            return null;
        }
        Object key = object4;
        return this$0.encryptInternal(new EncryptionAlgorithm((String)algorithmName), (JsRsaCryptoKey<PublicKey>)key, (byte[])data);
    }

    private static final Object getMember$lambda$4(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        Object keyRaw;
        Object algorithmName;
        block7: {
            block6: {
                Intrinsics.checkNotNull((Object)arguments);
                Object object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
                if (object2 == null || (object2 = object2.getMember("name")) == null || (object2 = object2.asString()) == null) {
                    return null;
                }
                algorithmName = object2;
                Object object3 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
                if (object3 == null || (object3 = object3.getMember("_handle")) == null || (object3 = (JsRsaCryptoKey)object3.as(JsRsaCryptoKey.class)) == null) {
                    return null;
                }
                keyRaw = object3;
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)2);
                if (object == null) break block6;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block7;
            }
            return null;
        }
        Object data = object;
        Object object4 = keyRaw instanceof JsRsaCryptoKey ? keyRaw : null;
        if (object4 == null) {
            return null;
        }
        Object key = object4;
        return this$0.decryptInternal(new EncryptionAlgorithm((String)algorithmName), (JsRsaCryptoKey<PrivateKey>)key, (byte[])data);
    }

    private static final Object getMember$lambda$5(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        Object keyRaw;
        SigningAlgorithm signingAlgorithm;
        block7: {
            block6: {
                SigningAlgorithm signingAlgorithm2 = this$0.extractSignatureAlgoritm(arguments);
                if (signingAlgorithm2 == null) {
                    return null;
                }
                signingAlgorithm = signingAlgorithm2;
                Intrinsics.checkNotNull((Object)arguments);
                Object object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
                if (object2 == null || (object2 = object2.getMember("_handle")) == null || (object2 = (JsRsaCryptoKey)object2.as(JsRsaCryptoKey.class)) == null) {
                    return null;
                }
                keyRaw = object2;
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)2);
                if (object == null) break block6;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block7;
            }
            return null;
        }
        Object data = object;
        Object object3 = keyRaw instanceof JsRsaCryptoKey ? keyRaw : null;
        if (object3 == null) {
            return null;
        }
        Object key = object3;
        return this$0.signInternal(signingAlgorithm, (JsRsaCryptoKey<PrivateKey>)key, (byte[])data);
    }

    private static final Object getMember$lambda$6(SubtleCrypto this$0, Value[] arguments) {
        Object object;
        Object signature;
        Object keyRaw;
        SigningAlgorithm signingAlgorithm;
        block12: {
            block11: {
                Object object2;
                block10: {
                    block9: {
                        SigningAlgorithm signingAlgorithm2 = this$0.extractSignatureAlgoritm(arguments);
                        if (signingAlgorithm2 == null) {
                            return null;
                        }
                        signingAlgorithm = signingAlgorithm2;
                        Intrinsics.checkNotNull((Object)arguments);
                        Object object3 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
                        if (object3 == null || (object3 = object3.getMember("_handle")) == null || (object3 = (JsRsaCryptoKey)object3.as(JsRsaCryptoKey.class)) == null) {
                            return null;
                        }
                        keyRaw = object3;
                        object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)2);
                        if (object2 == null) break block9;
                        byte[] byArray = StringUtilsKt.asByteArray(object2);
                        object2 = byArray;
                        if (byArray != null) break block10;
                    }
                    return null;
                }
                signature = object2;
                object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)3);
                if (object == null) break block11;
                byte[] byArray = StringUtilsKt.asByteArray(object);
                object = byArray;
                if (byArray != null) break block12;
            }
            return null;
        }
        Object data = object;
        Object object4 = keyRaw instanceof JsRsaCryptoKey ? keyRaw : null;
        if (object4 == null) {
            return null;
        }
        Object key = object4;
        return this$0.verifyInternal(signingAlgorithm, (byte[])signature, (JsRsaCryptoKey<PublicKey>)key, (byte[])data);
    }

    private static final Object getMember$lambda$7(SubtleCrypto this$0, Value[] arguments) {
        Intrinsics.checkNotNull((Object)arguments);
        Object object = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
        if (object == null || (object = object.asString()) == null) {
            return null;
        }
        Object format = object;
        Object object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (object2 == null || (object2 = object2.getMember("_handle")) == null || (object2 = (JsRsaCryptoKey)object2.as(JsRsaCryptoKey.class)) == null) {
            return null;
        }
        Object keyRaw = object2;
        Object object3 = keyRaw instanceof JsRsaCryptoKey ? keyRaw : null;
        if (object3 == null) {
            return null;
        }
        Object key = object3;
        return this$0.exportKeyInternal((String)format, (JsRsaCryptoKey<?>)key);
    }

    private static final Object getMember$lambda$9(SubtleCrypto this$0, Value[] arguments) {
        Pair pair;
        Object obj;
        JsRsaCryptoKey<?> key;
        Object object;
        Object name;
        Object[] obj2;
        Object object2;
        Object format;
        block14: {
            block13: {
                Intrinsics.checkNotNull((Object)arguments);
                Object object3 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)0);
                if (object3 == null || (object3 = object3.asString()) == null) {
                    return null;
                }
                format = object3;
                object2 = (Value)ArraysKt.getOrNull((Object[])arguments, (int)1);
                if (object2 == null) break block13;
                byte[] byArray = StringUtilsKt.asByteArray(object2);
                object2 = byArray;
                if (byArray != null) break block14;
            }
            return null;
        }
        Object keyData = object2;
        Object[] objectArray = (Object[])ArraysKt.getOrNull((Object[])arguments, (int)2);
        if (objectArray != null) {
            obj2 = objectArray;
            boolean bl = false;
            Object object4 = obj2.getMember("name");
            if (object4 == null || (object4 = object4.asString()) == null) {
                return null;
            }
            name = object4;
            object = obj2.getMember("hash");
            if (object == null || (object = object.getMember("name")) == null || (object = object.asString()) == null) {
                object = "SHA-256";
            }
        } else {
            return null;
        }
        Object hash = object;
        RsaKeyAlgorithm algorithm = new RsaKeyAlgorithm((String)name, null, null, (String)hash);
        JsRsaCryptoKey<?> jsRsaCryptoKey = key = this$0.importKeyInternal((String)format, (byte[])keyData, algorithm);
        Object object5 = obj = jsRsaCryptoKey != null ? jsRsaCryptoKey.getKey() : null;
        if (obj instanceof PrivateKey) {
            obj2 = new String[]{"decrypt", "sign"};
            pair = TuplesKt.to((Object)"private", (Object)ProxyArray.fromList((List)CollectionsKt.listOf((Object[])obj2)));
        } else if (obj instanceof PublicKey) {
            obj2 = new String[]{"encrypt", "verify"};
            pair = TuplesKt.to((Object)"public", (Object)ProxyArray.fromList((List)CollectionsKt.listOf((Object[])obj2)));
        } else {
            return null;
        }
        Pair pair2 = pair;
        String type = (String)pair2.component1();
        ProxyArray usage = (ProxyArray)pair2.component2();
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)type);
        pairArray[1] = TuplesKt.to((Object)"extractable", (Object)true);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"name", (Object)algorithm.getName()), TuplesKt.to((Object)"hash", (Object)ProxyObject.fromMap((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)algorithm.getHash()))))};
        pairArray[2] = TuplesKt.to((Object)"algorithm", (Object)ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray2)));
        pairArray[3] = TuplesKt.to((Object)"usages", (Object)usage);
        pairArray[4] = TuplesKt.to((Object)"_handle", key);
        return ProxyObject.fromMap((Map)MapsKt.mapOf((Pair[])pairArray));
    }
}

