/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.environment.auth;

import com.intellij.httpClient.http.request.environment.auth.AuthType;
import com.intellij.httpClient.http.request.environment.auth.mock.MockAuthConfig;
import com.intellij.httpClient.http.request.environment.auth.oauth2.OAuth2Config;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0012\u0013R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0001\u0002\u0014\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/intellij/httpClient/http/request/environment/auth/AuthConfiguration;", "T", "", "type", "Lcom/intellij/httpClient/http/request/environment/auth/AuthType;", "getType", "()Lcom/intellij/httpClient/http/request/environment/auth/AuthType;", "id", "", "getId", "()Ljava/lang/String;", "config", "getConfig", "()Ljava/lang/Object;", "acquireAutomatically", "", "getAcquireAutomatically", "()Z", "OAuth2", "Mock", "Lcom/intellij/httpClient/http/request/environment/auth/AuthConfiguration$Mock;", "Lcom/intellij/httpClient/http/request/environment/auth/AuthConfiguration$OAuth2;", "intellij.restClient"})
public interface AuthConfiguration<T> {
    @NotNull
    public AuthType getType();

    @NotNull
    public String getId();

    public T getConfig();

    public boolean getAcquireAutomatically();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/intellij/httpClient/http/request/environment/auth/AuthConfiguration$Mock;", "Lcom/intellij/httpClient/http/request/environment/auth/AuthConfiguration;", "Lcom/intellij/httpClient/http/request/environment/auth/mock/MockAuthConfig;", "id", "", "config", "<init>", "(Ljava/lang/String;Lcom/intellij/httpClient/http/request/environment/auth/mock/MockAuthConfig;)V", "getId", "()Ljava/lang/String;", "getConfig", "()Lcom/intellij/httpClient/http/request/environment/auth/mock/MockAuthConfig;", "type", "Lcom/intellij/httpClient/http/request/environment/auth/AuthType;", "getType", "()Lcom/intellij/httpClient/http/request/environment/auth/AuthType;", "acquireAutomatically", "", "getAcquireAutomatically", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.restClient"})
    public static final class Mock
    implements AuthConfiguration<MockAuthConfig> {
        @NotNull
        private final String id;
        @NotNull
        private final MockAuthConfig config;

        public Mock(@NotNull String id, @NotNull MockAuthConfig config) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.id = id;
            this.config = config;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public MockAuthConfig getConfig() {
            return this.config;
        }

        @Override
        @NotNull
        public AuthType getType() {
            return AuthType.MOCK;
        }

        @Override
        public boolean getAcquireAutomatically() {
            return true;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final MockAuthConfig component2() {
            return this.config;
        }

        @NotNull
        public final Mock copy(@NotNull String id, @NotNull MockAuthConfig config) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new Mock(id, config);
        }

        public static /* synthetic */ Mock copy$default(Mock mock, String string, MockAuthConfig mockAuthConfig, int n, Object object) {
            if ((n & 1) != 0) {
                string = mock.id;
            }
            if ((n & 2) != 0) {
                mockAuthConfig = mock.config;
            }
            return mock.copy(string, mockAuthConfig);
        }

        @NotNull
        public String toString() {
            return "Mock(id=" + this.id + ", config=" + this.config + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.config.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mock)) {
                return false;
            }
            Mock mock = (Mock)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)mock.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.config, (Object)mock.config);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/httpClient/http/request/environment/auth/AuthConfiguration$OAuth2;", "Lcom/intellij/httpClient/http/request/environment/auth/AuthConfiguration;", "Lcom/intellij/httpClient/http/request/environment/auth/oauth2/OAuth2Config;", "id", "", "config", "acquireAutomatically", "", "<init>", "(Ljava/lang/String;Lcom/intellij/httpClient/http/request/environment/auth/oauth2/OAuth2Config;Z)V", "getId", "()Ljava/lang/String;", "getConfig", "()Lcom/intellij/httpClient/http/request/environment/auth/oauth2/OAuth2Config;", "getAcquireAutomatically", "()Z", "type", "Lcom/intellij/httpClient/http/request/environment/auth/AuthType;", "getType", "()Lcom/intellij/httpClient/http/request/environment/auth/AuthType;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.restClient"})
    public static final class OAuth2
    implements AuthConfiguration<OAuth2Config> {
        @NotNull
        private final String id;
        @NotNull
        private final OAuth2Config config;
        private final boolean acquireAutomatically;

        public OAuth2(@NotNull String id, @NotNull OAuth2Config config, boolean acquireAutomatically) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.id = id;
            this.config = config;
            this.acquireAutomatically = acquireAutomatically;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public OAuth2Config getConfig() {
            return this.config;
        }

        @Override
        public boolean getAcquireAutomatically() {
            return this.acquireAutomatically;
        }

        @Override
        @NotNull
        public AuthType getType() {
            return AuthType.OAUTH2;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final OAuth2Config component2() {
            return this.config;
        }

        public final boolean component3() {
            return this.acquireAutomatically;
        }

        @NotNull
        public final OAuth2 copy(@NotNull String id, @NotNull OAuth2Config config, boolean acquireAutomatically) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new OAuth2(id, config, acquireAutomatically);
        }

        public static /* synthetic */ OAuth2 copy$default(OAuth2 oAuth2, String string, OAuth2Config oAuth2Config, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = oAuth2.id;
            }
            if ((n & 2) != 0) {
                oAuth2Config = oAuth2.config;
            }
            if ((n & 4) != 0) {
                bl = oAuth2.acquireAutomatically;
            }
            return oAuth2.copy(string, oAuth2Config, bl);
        }

        @NotNull
        public String toString() {
            return "OAuth2(id=" + this.id + ", config=" + this.config + ", acquireAutomatically=" + this.acquireAutomatically + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.config.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.acquireAutomatically);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OAuth2)) {
                return false;
            }
            OAuth2 oAuth2 = (OAuth2)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)oAuth2.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.config, (Object)oAuth2.config)) {
                return false;
            }
            return this.acquireAutomatically == oAuth2.acquireAutomatically;
        }
    }
}

