/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.httpClient.actions.HttpClientActionsUsage;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.notification.HttpClientNotificationPanelV2Kt;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.httpClient.http.request.run.HttpRequestInvalidLogFileException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestShowHistoryAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        Boolean isNonClassic;
        if (e == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(0);
        }
        if ((isNonClassic = (Boolean)e.getData(HttpClientNotificationPanelV2Kt.HTTP_CLIENT_IS_TOOLBAR_V2)) != null && isNonClassic.booleanValue()) {
            e.getPresentation().setIcon(AllIcons.Vcs.History);
        }
        if ((project = e.getProject()) == null || project.isDefault()) {
            return;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file == null) {
            return;
        }
        VirtualFile logFile = HttpRequestHistoryManager.getInstance(project).findLogFile();
        e.getPresentation().setEnabled(!Objects.equals(file, logFile));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(2);
        }
        if ((project = event.getProject()) == null || project.isDefault()) {
            this.showErrorBalloon(null, event, RestClientBundle.message("http.request.show.log.file.action.failed.default.project", new Object[0]), null, HttpClientActionsUsage.ProblemType.GENERAL);
            return;
        }
        try {
            HttpRequestPsiFile logFile = HttpRequestHistoryManager.getInstance(project).getLogFile();
            FileEditorManager.getInstance((Project)project).openFile(logFile.getVirtualFile(), true);
        }
        catch (HttpRequestInvalidLogFileException e) {
            this.showErrorBalloon(project, event, e.getMessage(), e.getProblemFix(), e.getProblemType());
        }
    }

    protected void showErrorBalloon(@Nullable Project project, @NotNull AnActionEvent event, @NlsContexts.PopupContent @NotNull String message, final @Nullable HttpRequestInvalidLogFileException.ProblemFix problemFix, final @NotNull HttpClientActionsUsage.ProblemType problemType) {
        InputEvent inputEvent;
        if (event == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(3);
        }
        if (message == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(4);
        }
        if (problemType == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(5);
        }
        RelativePoint point = (inputEvent = event.getInputEvent()) instanceof MouseEvent ? new RelativePoint((MouseEvent)inputEvent) : JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext());
        String fullMessage = problemFix != null ? HttpRequestShowHistoryAction.messageWithFixLink(message, problemFix) : message;
        HyperlinkAdapter listener2 = problemFix != null ? new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HttpClientActionsUsage.FIX_INVALID_LOG_LINK_CLICKED.log((Object)problemType);
                    problemFix.action().run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/httpClient/actions/HttpRequestShowHistoryAction$1", "hyperlinkActivated"));
            }
        } : null;
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(fullMessage, MessageType.ERROR, (HyperlinkListener)listener2).setFadeoutTime(fullMessage.length() > 100 ? 5000L : 2000L);
        if (project != null) {
            builder.setDisposable((Disposable)HttpRequestHistoryManager.getInstance(project));
        }
        builder.createBalloon().show(point, Balloon.Position.below);
        HttpClientActionsUsage.ERROR_ABOUT_INVALID_LOG_SHOWN.log((Object)problemType);
    }

    @NlsContexts.PopupContent
    @NotNull
    private static String messageWithFixLink(@NotNull @Nls String message, @NotNull HttpRequestInvalidLogFileException.ProblemFix problemFix) {
        if (message == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(6);
        }
        if (problemFix == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(7);
        }
        String string = new HtmlBuilder().append(message).br().appendLink("\"config\"", problemFix.text()).toString();
        if (string == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/HttpRequestShowHistoryAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/HttpRequestShowHistoryAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "messageWithFixLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "messageWithFixLink";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8 -> new IllegalStateException(string);
        };
    }
}

