/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.api.AddDataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.GroupBy;
import org.jetbrains.kotlinx.dataframe.api.SortDsl;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.api.UpdateKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.api.ColumnSetWithSortFlag;
import org.jetbrains.kotlinx.dataframe.impl.api.SortColumnDescriptor;
import org.jetbrains.kotlinx.dataframe.impl.api.SortDirection;
import org.jetbrains.kotlinx.dataframe.impl.api.SortFlag;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.missing.MissingColumnGroup;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0005\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\n\u0012\u0002\b\u00030\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0080\u0001\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00110\u00122N\u0010\u0013\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u0015\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\u0014j\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u0002`\u0019\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001eH\u0000\u001a~\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0012\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00110\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u001c2N\u0010\u0013\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u0015\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\u0014j\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u0002`\u0019\u00a2\u0006\u0002\b\u001aH\u0000\u001a|\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010!*\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H!0 2J\u0010\u0013\u001aF\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u0015\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H!0\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0014j\f\u0012\u0004\u0012\u0002H!\u0012\u0002\b\u0003`\u0019\u00a2\u0006\u0002\b\u001aH\u0000\u00a8\u0006\""}, d2={"addFlag", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "C", "flag", "Lorg/jetbrains/kotlinx/dataframe/impl/api/SortFlag;", "Lorg/jetbrains/kotlinx/dataframe/impl/api/ColumnSetWithSortFlag;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "createComparator", "Ljava/util/Comparator;", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "nullsLast", "", "getSortColumns", "", "Lorg/jetbrains/kotlinx/dataframe/impl/api/SortColumnDescriptor;", "T", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "columns", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/SortDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/api/SortColumnsSelector;", "Lkotlin/ExtensionFunctionType;", "unresolvedColumnsPolicy", "Lorg/jetbrains/kotlinx/dataframe/columns/UnresolvedColumnsPolicy;", "reversed", "Lorg/jetbrains/kotlinx/dataframe/impl/api/SortDirection;", "sortByImpl", "Lorg/jetbrains/kotlinx/dataframe/api/GroupBy;", "G", "core"})
@SourceDebugExtension(value={"SMAP\nsort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sort.kt\norg/jetbrains/kotlinx/dataframe/impl/api/SortKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1549#2:127\n1620#2,3:128\n2661#2,7:131\n819#2:138\n847#2,2:139\n1549#2:141\n1620#2,3:142\n*S KotlinDebug\n*F\n+ 1 sort.kt\norg/jetbrains/kotlinx/dataframe/impl/api/SortKt\n*L\n47#1:127\n47#1:128,3\n52#1:131,7\n75#1:138\n75#1:139,2\n76#1:141\n76#1:142,3\n*E\n"})
public final class SortKt {
    @NotNull
    public static final <T, G> GroupBy<T, G> sortByImpl(@NotNull GroupBy<? extends T, ? extends G> $this$sortByImpl, @NotNull Function2<? super SortDsl<? extends G>, ? super SortDsl<? extends G>, ? extends ColumnsResolver<?>> columns2) {
        Intrinsics.checkNotNullParameter($this$sortByImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return TypeConversionsKt.asGroupBy(SortKt.sortByImpl(UpdateKt.with(UpdateKt.update(GroupBy.DefaultImpls.toDataFrame$default($this$sortByImpl, null, 1, null), (Function2)new Function2<ColumnsSelectionDsl<? extends T>, ColumnsSelectionDsl<? extends T>, ColumnsResolver<? extends DataFrame<? extends G>>>($this$sortByImpl){
            final /* synthetic */ GroupBy<T, G> $this_sortByImpl;
            {
                this.$this_sortByImpl = $receiver;
                super(2);
            }

            @NotNull
            public final ColumnsResolver<DataFrame<G>> invoke(@NotNull ColumnsSelectionDsl<? extends T> $this$update, @NotNull ColumnsSelectionDsl<? extends T> it) {
                Intrinsics.checkNotNullParameter($this$update, (String)"$this$update");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$this_sortByImpl.getGroups();
            }
        }), (Function2)new Function2<AddDataRow<? extends T>, DataFrame<? extends G>, DataFrame<? extends G>>(columns2){
            final /* synthetic */ Function2<SortDsl<? extends G>, SortDsl<? extends G>, ColumnsResolver<?>> $columns;
            {
                this.$columns = $columns;
                super(2);
            }

            @Nullable
            public final DataFrame<G> invoke(@NotNull AddDataRow<? extends T> $this$with, @NotNull DataFrame<? extends G> it) {
                Intrinsics.checkNotNullParameter($this$with, (String)"$this$with");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return SortKt.sortByImpl(it, UnresolvedColumnsPolicy.Skip, this.$columns);
            }
        }), UnresolvedColumnsPolicy.Skip, (Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(columns2, (int)2)), (Function2)new Function2<ColumnsSelectionDsl<? extends T>, ColumnsSelectionDsl<? extends T>, SingleColumn<? extends DataFrame<? extends G>>>($this$sortByImpl){
            final /* synthetic */ GroupBy<T, G> $this_sortByImpl;
            {
                this.$this_sortByImpl = $receiver;
                super(2);
            }

            @NotNull
            public final SingleColumn<DataFrame<G>> invoke(@NotNull ColumnsSelectionDsl<? extends T> $this$asGroupBy, @NotNull ColumnsSelectionDsl<? extends T> it) {
                Intrinsics.checkNotNullParameter($this$asGroupBy, (String)"$this$asGroupBy");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return CastKt.castFrameColumn(DataFrameGetKt.getFrameColumn((ColumnsContainer)it, this.$this_sortByImpl.getGroups().name()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> DataFrame<T> sortByImpl(@NotNull DataFrame<? extends T> $this$sortByImpl, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super SortDsl<? extends T>, ? super SortDsl<? extends T>, ? extends ColumnsResolver<? extends C>> columns2) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$sortByImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        List<SortColumnDescriptor<?>> sortColumns = SortKt.getSortColumns($this$sortByImpl, columns2, unresolvedColumnsPolicy);
        if (sortColumns.isEmpty()) {
            return $this$sortByImpl;
        }
        Iterable $this$map$iv = sortColumns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Comparator<Integer> comparator;
            void it;
            SortColumnDescriptor sortColumnDescriptor = (SortColumnDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getDirection().ordinal()]) {
                case 1: {
                    comparator = SortKt.createComparator(it.getColumn(), it.getNullsLast());
                    break;
                }
                case 2: {
                    comparator = SortKt.createComparator(it.getColumn(), it.getNullsLast()).reversed();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(comparator);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            Comparator $i$f$mapTo2 = (Comparator)iterator$iv.next();
            Comparator a = (Comparator)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)a);
            Intrinsics.checkNotNull((Object)b);
            accumulator$iv = ComparisonsKt.then((Comparator)a, (Comparator)b);
        }
        Comparator compChain = (Comparator)accumulator$iv;
        Iterable iterable2 = (Iterable)RangesKt.until((int)0, (int)DataFrameKt.getNrow($this$sortByImpl));
        Intrinsics.checkNotNull((Object)compChain);
        List permutation = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)compChain);
        return $this$sortByImpl.get(permutation);
    }

    public static /* synthetic */ DataFrame sortByImpl$default(DataFrame dataFrame, UnresolvedColumnsPolicy unresolvedColumnsPolicy, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            unresolvedColumnsPolicy = UnresolvedColumnsPolicy.Fail;
        }
        return SortKt.sortByImpl(dataFrame, unresolvedColumnsPolicy, function2);
    }

    @NotNull
    public static final Comparator<Integer> createComparator(@NotNull DataColumn<?> $this$createComparator, boolean nullsLast) {
        Intrinsics.checkNotNullParameter($this$createComparator, (String)"<this>");
        UtilsKt.assertIsComparable($this$createComparator);
        Comparator valueComparator = SortKt::createComparator$lambda$2;
        Comparator comparatorWithNulls = nullsLast ? ComparisonsKt.nullsLast((Comparator)valueComparator) : ComparisonsKt.nullsFirst((Comparator)valueComparator);
        return (arg_0, arg_1) -> SortKt.createComparator$lambda$3(comparatorWithNulls, $this$createComparator, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> List<SortColumnDescriptor<?>> getSortColumns(@NotNull DataFrame<? extends T> $this$getSortColumns, @NotNull Function2<? super SortDsl<? extends T>, ? super SortDsl<? extends T>, ? extends ColumnsResolver<? extends C>> columns2, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy) {
        void $this$mapTo$iv$iv;
        ColumnWithPath it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getSortColumns, (String)"<this>");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Iterable $this$filterNot$iv = UtilsKt.resolve(ConstructorsKt.toColumnSetForSort(columns2), $this$getSortColumns, unresolvedColumnsPolicy);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ColumnWithPath)element$iv$iv;
            boolean bl = false;
            if (it.getData() instanceof MissingColumnGroup) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SortColumnDescriptor sortColumnDescriptor;
            it = (ColumnWithPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DataColumn col2 = it.getData();
            if (col2 instanceof SortColumnDescriptor) {
                sortColumnDescriptor = (SortColumnDescriptor)col2;
            } else if (col2 instanceof ValueColumn) {
                sortColumnDescriptor = new SortColumnDescriptor((ValueColumn)col2, null, false, 6, null);
            } else {
                throw new IllegalStateException("Can not use " + (Object)((Object)DataColumnKt.getKind(col2)) + " as sort column");
            }
            collection.add(sortColumnDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <C> ColumnSetWithSortFlag<C> addFlag(@NotNull ColumnsResolver<? extends C> $this$addFlag, @NotNull SortFlag flag) {
        Intrinsics.checkNotNullParameter($this$addFlag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)flag), (String)"flag");
        return new ColumnSetWithSortFlag<C>($this$addFlag, flag);
    }

    @NotNull
    public static final <C> ColumnWithPath<C> addFlag(@NotNull ColumnWithPath<? extends C> $this$addFlag, @NotNull SortFlag flag) {
        SortColumnDescriptor sortColumnDescriptor;
        block9: {
            DataColumn<C> col2;
            block10: {
                DataColumn<C> dataColumn;
                block8: {
                    Intrinsics.checkNotNullParameter($this$addFlag, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)((Object)flag), (String)"flag");
                    dataColumn = col2 = $this$addFlag.getData();
                    if (!(dataColumn instanceof SortColumnDescriptor)) break block8;
                    switch (WhenMappings.$EnumSwitchMapping$1[flag.ordinal()]) {
                        case 1: {
                            sortColumnDescriptor = new SortColumnDescriptor(((SortColumnDescriptor)col2).getColumn(), SortKt.reversed(((SortColumnDescriptor)col2).getDirection()), ((SortColumnDescriptor)col2).getNullsLast());
                            break block9;
                        }
                        case 2: {
                            sortColumnDescriptor = new SortColumnDescriptor(((SortColumnDescriptor)col2).getColumn(), ((SortColumnDescriptor)col2).getDirection(), true);
                            break block9;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!(dataColumn instanceof ValueColumn)) break block10;
                switch (WhenMappings.$EnumSwitchMapping$1[flag.ordinal()]) {
                    case 1: {
                        sortColumnDescriptor = new SortColumnDescriptor((ValueColumn)col2, SortDirection.Desc, false, 4, null);
                        break block9;
                    }
                    case 2: {
                        sortColumnDescriptor = new SortColumnDescriptor((ValueColumn)col2, SortDirection.Asc, true);
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new IllegalArgumentException("Can not apply sort flag to column kind " + (Object)((Object)DataColumnKt.getKind(col2)));
        }
        return UtilsKt.addPath(sortColumnDescriptor, $this$addFlag.getPath());
    }

    @NotNull
    public static final SortDirection reversed(@NotNull SortDirection $this$reversed) {
        SortDirection sortDirection;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$reversed), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$reversed.ordinal()]) {
            case 1: {
                sortDirection = SortDirection.Desc;
                break;
            }
            case 2: {
                sortDirection = SortDirection.Asc;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sortDirection;
    }

    private static final int createComparator$lambda$2(Object left, Object right) {
        Intrinsics.checkNotNull((Object)left, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any?>");
        return ((Comparable)left).compareTo(right);
    }

    private static final int createComparator$lambda$3(Comparator $comparatorWithNulls, DataColumn $this_createComparator, Integer left, Integer right) {
        Intrinsics.checkNotNullParameter((Object)$comparatorWithNulls, (String)"$comparatorWithNulls");
        Intrinsics.checkNotNullParameter((Object)$this_createComparator, (String)"$this_createComparator");
        Intrinsics.checkNotNull((Object)left);
        Object t = $this_createComparator.get(left);
        Intrinsics.checkNotNull((Object)right);
        return $comparatorWithNulls.compare(t, $this_createComparator.get(right));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SortDirection.values().length];
            try {
                nArray[SortDirection.Asc.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortDirection.Desc.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SortFlag.values().length];
            try {
                nArray[SortFlag.Reversed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortFlag.NullsLast.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

