/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables.inline;

import com.intellij.jupyter.core.core.api.NotebookDisposable;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.jupyter.py.variables.inline.JupyterInlinePainter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "painters", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlinePainter;", "getInlineCallback", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineCallback;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "updateEditor", "", "dispose", "Companion", "intellij.jupyter.py"})
public final class JupyterInlineService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private ConcurrentHashMap<VirtualFile, JupyterInlinePainter> painters;

    public JupyterInlineService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.painters = new ConcurrentHashMap();
    }

    @Nullable
    public final JupyterInlineCallback getInlineCallback(@NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        VirtualFile originalFile = notebookFile.getOriginFile();
        if (this.project.isDisposed()) {
            return null;
        }
        return this.painters.computeIfAbsent(originalFile, arg_0 -> JupyterInlineService.getInlineCallback$lambda$2(arg_0 -> JupyterInlineService.getInlineCallback$lambda$1(this, notebookFile, arg_0), arg_0));
    }

    public final void updateEditor(@NotNull BackedNotebookVirtualFile notebookFile) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
            JupyterInlinePainter jupyterInlinePainter = this.painters.get(notebookFile.getOriginFile());
            if (jupyterInlinePainter == null) break block0;
            jupyterInlinePainter.updateEditor();
        }
    }

    public void dispose() {
        this.painters = new ConcurrentHashMap();
    }

    private static final JupyterInlinePainter getInlineCallback$lambda$1(JupyterInlineService this$0, BackedNotebookVirtualFile $notebookFile, VirtualFile it) {
        JupyterInlinePainter jupyterInlinePainter;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JupyterInlinePainter it2 = jupyterInlinePainter = new JupyterInlinePainter(this$0.project, $notebookFile);
        boolean bl = false;
        Disposer.register((Disposable)Companion.getDisposableTarget(this$0.project), (Disposable)((Disposable)it2));
        return jupyterInlinePainter;
    }

    private static final JupyterInlinePainter getInlineCallback$lambda$2(Function1 $tmp0, Object p0) {
        return (JupyterInlinePainter)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final JupyterInlineService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineService;", "project", "Lcom/intellij/openapi/project/Project;", "getDisposableTarget", "Lcom/intellij/openapi/Disposable;", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "intellij.jupyter.py"})
    @SourceDebugExtension(value={"SMAP\nJupyterInlineService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterInlineService.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlineService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,47:1\n30#2,2:48\n*S KotlinDebug\n*F\n+ 1 JupyterInlineService.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlineService$Companion\n*L\n38#1:48,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterInlineService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JupyterInlineService> serviceClass$iv = JupyterInlineService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterInlineService)object;
        }

        @NotNull
        public final Disposable getDisposableTarget(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (Disposable)NotebookDisposable.Companion.forProject(project);
        }

        public final void install(@NotNull Editor editor, @NotNull BackedNotebookVirtualFile notebookFile) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            new JupyterInlineService(project2).getInlineCallback(notebookFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

