/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefaultHighlightingSettingProvider
extends DefaultHighlightingSettingProvider {
    @Nullable
    public FileHighlightingSetting getDefaultSetting(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile topLevel;
        FileHighlightingSetting skipHighlighting;
        FileType type2;
        boolean isJavaScript;
        boolean isTypeScript;
        if (project == null) {
            JSDefaultHighlightingSettingProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JSDefaultHighlightingSettingProvider.$$$reportNull$$$0(1);
        }
        boolean bl = isTypeScript = !(isJavaScript = DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type2 = file.getFileType())) && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(type2);
        if (!isJavaScript && !isTypeScript) {
            return null;
        }
        if (project.isDefault()) {
            return null;
        }
        if (!file.isValid()) {
            return null;
        }
        FileHighlightingSetting fileHighlightingSetting = skipHighlighting = isTypeScript ? FileHighlightingSetting.SKIP_INSPECTION : FileHighlightingSetting.SKIP_HIGHLIGHTING;
        if (BaseJSSymbolProcessor.isTooBigForHighlighting(file)) {
            return skipHighlighting;
        }
        ThreeState explicitlyCompact = JSLibraryManager.getInstance(project).getFileState(file);
        if (explicitlyCompact == ThreeState.YES) {
            return skipHighlighting;
        }
        if (explicitlyCompact == ThreeState.NO) {
            return FileHighlightingSetting.SKIP_INSPECTION;
        }
        if (JSMinifiedFileUtil.isFileContentMinified(file)) {
            return skipHighlighting;
        }
        if (file instanceof VirtualFileWindow) {
            VirtualFileWindow w = (VirtualFileWindow)file;
            v2 = w.getDelegate();
        } else {
            v2 = topLevel = file;
        }
        if (topLevel instanceof LightVirtualFile) {
            return null;
        }
        if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(topLevel) && !ScratchUtil.isScratch((VirtualFile)topLevel)) {
            return skipHighlighting;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/validation/JSDefaultHighlightingSettingProvider";
        objectArray[2] = "getDefaultSetting";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

