/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.codeInsight.PackageJsonCompletionContributor;
import com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages.PopularNodePackagesProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0007JD\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J)\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonCompletionUtil;", "", "<init>", "()V", "searchPackagesByPrefix", "", "project", "Lcom/intellij/openapi/project/Project;", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "prefix", "", "limit", "", "filter", "Ljava/util/function/Predicate;", "Lcom/intellij/javascript/nodejs/packageJson/NodePackageBasicInfo;", "consumer", "Ljava/util/function/Consumer;", "searchPackagesByPrefixInRegistry", "Lcom/intellij/openapi/util/Condition;", "executeWithoutReadAction", "T", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "action", "Lkotlin/Function0;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "findPrefix", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "element", "Lcom/intellij/psi/PsiElement;", "unquote", "str", "quotationChar", "", "intellij.javascript.impl"})
public final class PackageJsonCompletionUtil {
    @NotNull
    public static final PackageJsonCompletionUtil INSTANCE = new PackageJsonCompletionUtil();

    private PackageJsonCompletionUtil() {
    }

    @JvmStatic
    public static final void searchPackagesByPrefix(@NotNull Project project, @NotNull VirtualFile contextFileOrDir, @NotNull String prefix, int limit, @NotNull Predicate<NodePackageBasicInfo> filter2, @NotNull Consumer<NodePackageBasicInfo> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contextFileOrDir, (String)"contextFileOrDir");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        List<NodePackageBasicInfo> list = PopularNodePackagesProvider.getInstance().findByPrefix(prefix, limit, filter2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"findByPrefix(...)");
        List<NodePackageBasicInfo> popularPackages = list;
        popularPackages.forEach(consumer);
        int fromRegistry = Math.max(0, limit - popularPackages.size());
        if (fromRegistry > 0 && !StringsKt.isBlank((CharSequence)prefix)) {
            ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
            if (progressIndicator == null) {
                PackageJsonCompletionUtil $this$searchPackagesByPrefix_u24lambda_u240 = INSTANCE;
                boolean bl = false;
                PackageJsonCompletionContributor.LOG.info("Aborted completing '" + prefix + "*' packages without ProgressIndicator");
                return;
            }
            ProgressIndicator indicator = progressIndicator;
            Set popularPackageNames = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)popularPackages), PackageJsonCompletionUtil::searchPackagesByPrefix$lambda$1));
            INSTANCE.executeWithoutReadAction(indicator, () -> PackageJsonCompletionUtil.searchPackagesByPrefix$lambda$3(project, contextFileOrDir, prefix, fromRegistry, consumer, popularPackageNames, filter2));
        }
    }

    private final void searchPackagesByPrefixInRegistry(Project project, VirtualFile contextFileOrDir, String prefix, int limit, Condition<NodePackageBasicInfo> filter2, Consumer<NodePackageBasicInfo> consumer) {
        try {
            Flow<NodePackageBasicInfo> flow = NpmRegistryService.Companion.getInstance(project).findPackages(NpmRegistryService.Companion.namePrefixSearch(prefix), limit, contextFileOrDir, filter2);
            CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(flow, consumer, null){
                int label;
                final /* synthetic */ Flow<NodePackageBasicInfo> $flow;
                final /* synthetic */ Consumer<NodePackageBasicInfo> $consumer;
                {
                    this.$flow = $flow;
                    this.$consumer = $consumer;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$flow.collect(new FlowCollector(this.$consumer){
                                final /* synthetic */ Consumer<NodePackageBasicInfo> $consumer;
                                {
                                    this.$consumer = $consumer;
                                }

                                public final Object emit(NodePackageBasicInfo it, Continuation<? super Unit> $completion) {
                                    this.$consumer.accept(it);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (CancellationException e) {
            PackageJsonCompletionContributor.LOG.info("Fetching '" + prefix + "*' packages from registry cancelled");
            throw e;
        }
        catch (IOException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(e);
            }
            PackageJsonCompletionContributor.LOG.info("Cannot fetch '" + prefix + "*' packages from registry", (Throwable)e);
        }
    }

    private final <T> T executeWithoutReadAction(ProgressIndicator indicator, Function0<? extends T> action) {
        return (T)(ApplicationManager.getApplication().isReadAccessAllowed() ? ApplicationUtil.runWithCheckCanceled(() -> PackageJsonCompletionUtil.executeWithoutReadAction$lambda$4(action), (ProgressIndicator)indicator) : action.invoke());
    }

    @JvmStatic
    @NotNull
    public static final String findPrefix(@NotNull CompletionParameters parameters2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        String name = element2.getText();
        int prefixLength = Math.min(name.length(), parameters2.getOffset() - element2.getTextRange().getStartOffset());
        Intrinsics.checkNotNull((Object)name);
        String string = name.substring(0, prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String barePrefix = string;
        return INSTANCE.unquote(INSTANCE.unquote(barePrefix, '\"'), '\'');
    }

    private final String unquote(String str, char quotationChar) {
        String string = StringUtil.unquoteString((String)str, (char)quotationChar);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        return StringsKt.removePrefix((String)string, (CharSequence)String.valueOf(quotationChar));
    }

    private static final String searchPackagesByPrefix$lambda$1(NodePackageBasicInfo it) {
        return it.getName();
    }

    private static final boolean searchPackagesByPrefix$lambda$3$lambda$2(Set $popularPackageNames, Predicate $filter, NodePackageBasicInfo it) {
        return !$popularPackageNames.contains(it.getName()) && $filter.test(it);
    }

    private static final Unit searchPackagesByPrefix$lambda$3(Project $project, VirtualFile $contextFileOrDir, String $prefix, int $fromRegistry, Consumer $consumer, Set $popularPackageNames, Predicate $filter) {
        INSTANCE.searchPackagesByPrefixInRegistry($project, $contextFileOrDir, $prefix, $fromRegistry, (Condition<NodePackageBasicInfo>)((Condition)arg_0 -> PackageJsonCompletionUtil.searchPackagesByPrefix$lambda$3$lambda$2($popularPackageNames, $filter, arg_0)), $consumer);
        return Unit.INSTANCE;
    }

    private static final Object executeWithoutReadAction$lambda$4(Function0 $tmp0) {
        return $tmp0.invoke();
    }
}

