/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.wsl.execution;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.process.ProcessCloseUtil;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.ssh.deploy.CommandExecutionResultWithRawStreams;
import com.jetbrains.gateway.ssh.deploy.ExtensionsKt;
import com.jetbrains.gateway.ssh.deploy.HostCommandExecutor;
import com.jetbrains.gateway.ssh.deploy.ShellArgument;
import com.jetbrains.gateway.wsl.execution.WslCommandExecutionStreams;
import com.jetbrains.gateway.wsl.execution.WslHostCommandExecutor;
import com.jetbrains.gateway.wsl.execution.WslHostCommandExecutorKt;
import com.jetbrains.gateway.wsl.execution.WslHostFileAccessor;
import com.jetbrains.gateway.wsl.execution.WslTunnelConnector;
import com.jetbrains.gateway.wsl.panels.WslRecentConnectionsAdapterKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"JV\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u001a\u0010-\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020)0(\u0012\u0004\u0012\u00020\u000f0.H\u0096@\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0014\u001a\f0\u000f\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00061"}, d2={"Lcom/jetbrains/gateway/wsl/execution/WslHostCommandExecutor;", "Lcom/jetbrains/gateway/ssh/deploy/HostCommandExecutor;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "fileAccessor", "Lcom/jetbrains/gateway/wsl/execution/WslHostFileAccessor;", "getFileAccessor", "()Lcom/jetbrains/gateway/wsl/execution/WslHostFileAccessor;", "tunnelConnector", "Lcom/jetbrains/gateway/wsl/execution/WslTunnelConnector;", "getTunnelConnector", "()Lcom/jetbrains/gateway/wsl/execution/WslTunnelConnector;", "connectionTypeId", "", "getConnectionTypeId", "()Ljava/lang/String;", "uniqueConfigId", "getUniqueConfigId", "host", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getHost", "user", "getUser", "userData", "Lcom/intellij/openapi/util/UserDataHolderBase;", "getUserData", "()Lcom/intellij/openapi/util/UserDataHolderBase;", "warmUp", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeCommand", "Lcom/jetbrains/gateway/ssh/deploy/CommandExecutionResultWithRawStreams;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "command", "", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument;", "mergeStderrIntoStdout", "", "useTty", "stringifier", "Lkotlin/Function1;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;[Lcom/jetbrains/gateway/ssh/deploy/ShellArgument;ZZLkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nWslHostCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslHostCommandExecutor.kt\ncom/jetbrains/gateway/wsl/execution/WslHostCommandExecutor\n+ 2 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n+ 3 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n13#2,4:113\n19#2,2:122\n39#3,5:117\n11228#4:124\n11563#4,3:125\n14#5:128\n*S KotlinDebug\n*F\n+ 1 WslHostCommandExecutor.kt\ncom/jetbrains/gateway/wsl/execution/WslHostCommandExecutor\n*L\n44#1:113,4\n44#1:122,2\n46#1:117,5\n76#1:124\n76#1:125,3\n30#1:128\n*E\n"})
public final class WslHostCommandExecutor
implements HostCommandExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WSLDistribution distribution;
    @NotNull
    private final WslHostFileAccessor fileAccessor;
    @NotNull
    private final WslTunnelConnector tunnelConnector;
    @NotNull
    private final String host;
    @NotNull
    private final String user;
    @NotNull
    private final UserDataHolderBase userData;
    @NotNull
    private static final Logger logger;

    public WslHostCommandExecutor(@NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        this.distribution = distribution;
        this.fileAccessor = new WslHostFileAccessor(this.distribution);
        this.tunnelConnector = new WslTunnelConnector(this.distribution);
        String string = this.distribution.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        this.host = string;
        String string2 = System.getenv("USERNAME");
        if (string2 == null) {
            string2 = "";
        }
        this.user = string2;
        this.userData = new UserDataHolderBase();
    }

    @Override
    @NotNull
    public WslHostFileAccessor getFileAccessor() {
        return this.fileAccessor;
    }

    @Override
    @NotNull
    public WslTunnelConnector getTunnelConnector() {
        return this.tunnelConnector;
    }

    @Override
    @NotNull
    public String getConnectionTypeId() {
        return "wsl";
    }

    @Override
    @NotNull
    public String getUniqueConfigId() {
        return WslRecentConnectionsAdapterKt.getWslThinClientUniqueId(this.distribution);
    }

    @Override
    @NotNull
    public String getHost() {
        return this.host;
    }

    @Override
    @NotNull
    public String getUser() {
        return this.user;
    }

    @NotNull
    public UserDataHolderBase getUserData() {
        return this.userData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object warmUp(@NotNull ProgressIndicator progressIndicator, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof warmUp.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ WslHostCommandExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.warmUp(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withPushPop$iv = progressIndicator;
                $i$f$withPushPop = 0;
                wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
                $this$withPushPop$iv.pushState();
                $i$a$-withPushPop-WslHostCommandExecutor$warmUp$2 = 0;
                progressIndicator.setText(GatewayBundle.INSTANCE.message("remote.deploy.warm-up", new Object[0]));
                this_$iv = Lifetime.Companion;
                $i$f$using = 0;
                def$iv = new LifetimeDefinition();
                lt = def$iv.getLifetime();
                $i$a$-using-WslHostCommandExecutor$warmUp$2$1 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)progressIndicator);
                $continuation.L$1 = $this$withPushPop$iv;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$3 = def$iv;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)lt);
                $continuation.I$0 = $i$f$withPushPop;
                $continuation.Z$0 = wasIndeterminate$iv;
                $continuation.I$1 = $i$a$-withPushPop-WslHostCommandExecutor$warmUp$2;
                $continuation.I$2 = $i$f$using;
                $continuation.I$3 = $i$a$-using-WslHostCommandExecutor$warmUp$2$1;
                $continuation.label = 1;
                v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lt, progressIndicator, null){
                    Object L$1;
                    Object L$2;
                    long J$0;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ WslHostCommandExecutor this$0;
                    final /* synthetic */ Lifetime $lt;
                    final /* synthetic */ ProgressIndicator $progressIndicator;
                    {
                        this.this$0 = $receiver;
                        this.$lt = $lt;
                        this.$progressIndicator = $progressIndicator;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = (CoroutineScope)this.L$0;
                        var14_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var4_4 = new ShellArgument[]{new ShellArgument.PlainText("echo"), new ShellArgument.PlainText("Host warm up")};
                                this.L$0 = $this$coroutineScope;
                                this.label = 1;
                                v0 = HostCommandExecutor.executeCommand$default(this.this$0, this.$lt, var4_4, false, false, null, (Continuation)this, 28, null);
                                if (v0 == var14_3) {
                                    return var14_3;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                command = (CommandExecutionResultWithRawStreams)v0;
                                startTime = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
                                waiter = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(command, null){
                                    int label;
                                    final /* synthetic */ CommandExecutionResultWithRawStreams $command;
                                    {
                                        this.$command = $command;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = ExtensionsKt.awaitOrKill(this.$command, WslHostCommandExecutorKt.access$getWSL_WARMUP_TIMEOUT$p(), (Continuation<? super Boolean>)((Continuation)this));
                                                if (object2 != object) return object2;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return object2;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
lbl20:
                                // 2 sources

                                while (!waiter.isCompleted()) {
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                                    this.L$2 = waiter;
                                    this.J$0 = startTime;
                                    this.label = 2;
                                    v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)50, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                                    if (v1 == var14_3) {
                                        return var14_3;
                                    }
                                    ** GOTO lbl39
                                }
                                break;
                            }
                            case 2: {
                                startTime = this.J$0;
                                waiter = (Deferred)this.L$2;
                                command = (CommandExecutionResultWithRawStreams)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl39:
                                // 2 sources

                                currentTime = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
                                elapsed = Duration.minus-LRDsOJo((long)currentTime, (long)startTime);
                                var13_15 = WslHostCommandExecutorKt.access$getWSL_WARMUP_TIMEOUT$p();
                                progress = Duration.div-LRDsOJo((long)elapsed, (long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)var13_15.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)var13_15.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)));
                                this.$progressIndicator.setFraction(RangesKt.coerceIn((double)progress, (double)0.0, (double)1.0));
                                ** GOTO lbl20
                            }
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$coroutineScope);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)waiter);
                        this.J$0 = startTime;
                        this.label = 3;
                        v2 = waiter.await((Continuation)this);
                        if (v2 == var14_3) {
                            return var14_3;
                        }
                        ** GOTO lbl60
                        {
                            case 3: {
                                startTime = this.J$0;
                                waiter = (Deferred)this.L$2;
                                command = (CommandExecutionResultWithRawStreams)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl60:
                                // 2 sources

                                if (!(completedSuccessfully = ((Boolean)v2).booleanValue())) {
                                    throw new IllegalStateException("Warm-up timeout".toString());
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var16_5) goto lbl41
lbl40:
                // 1 sources

                return var16_5;
lbl41:
                // 1 sources

                ** GOTO lbl58
            }
            case 1: {
                $i$a$-using-WslHostCommandExecutor$warmUp$2$1 = $continuation.I$3;
                $i$f$using = $continuation.I$2;
                $i$a$-withPushPop-WslHostCommandExecutor$warmUp$2 = $continuation.I$1;
                wasIndeterminate$iv = $continuation.Z$0;
                $i$f$withPushPop = $continuation.I$0;
                lt = (Lifetime)$continuation.L$4;
                def$iv = (LifetimeDefinition)$continuation.L$3;
                this_$iv = (Lifetime.Companion)$continuation.L$2;
                $this$withPushPop$iv = (ProgressIndicator)$continuation.L$1;
                progressIndicator = (ProgressIndicator)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl58:
                    // 2 sources

                    var12_22 = Unit.INSTANCE;
                    ** GOTO lbl66
                    {
                        catch (Throwable var12_23) {
                            throw var12_23;
                        }
                    }
                    finally {
                        LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
                    }
lbl66:
                    // 1 sources

                    var13_24 = Unit.INSTANCE;
                    $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv != false);
                }
                catch (Throwable var6_12) {
                    $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv != false);
                    $this$withPushPop$iv.popState();
                    throw var6_12;
                }
                $this$withPushPop$iv.popState();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object executeCommand(@NotNull Lifetime lifetime, @NotNull ShellArgument[] command, boolean mergeStderrIntoStdout, boolean useTty, @NotNull Function1<? super ShellArgument[], String> stringifier, @NotNull Continuation<? super CommandExecutionResultWithRawStreams> $completion) {
        void $this$mapTo$iv$iv;
        Path path2 = WSLDistribution.findWslExe();
        if (path2 == null) {
            throw new IllegalStateException("Cannot find wsl.exe".toString());
        }
        Path wslExePath = path2;
        ShellArgument[] $this$map$iv = command;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var17_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WslHostCommandExecutorKt.access$shellArgumentToString((ShellArgument)p0));
        }
        List shellCommand = (List)destination$iv$iv;
        logger.info("Starting a WSL process: " + CollectionsKt.joinToString$default((Iterable)shellCommand, null, null, null, (int)0, null, null, (int)63, null));
        objectArray = new String[]{((Object)wslExePath).toString(), "--distribution", this.distribution.getId(), "--"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine((String[])objectArray).withParameters(shellCommand).withRedirectErrorStream(mergeStderrIntoStdout);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withRedirectErrorStream(...)");
        GeneralCommandLine actualCommandLine = generalCommandLine;
        logger.info("Actual command line: " + actualCommandLine);
        return RdCoroutinesUtilKt.withIOBackgroundContext((Lifetime)lifetime, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super WslCommandExecutionStreams>, Object>(actualCommandLine, lifetime, null){
            int label;
            final /* synthetic */ GeneralCommandLine $actualCommandLine;
            final /* synthetic */ Lifetime $lifetime;
            {
                this.$actualCommandLine = $actualCommandLine;
                this.$lifetime = $lifetime;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Process process = this.$actualCommandLine.createProcess();
                        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
                        Process process2 = process;
                        this.$lifetime.onTermination(() -> executeCommand.2.invokeSuspend$lambda$0(process2));
                        String string = this.$actualCommandLine.getCommandLineString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
                        return new WslCommandExecutionStreams(this.$lifetime, string, process2);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super WslCommandExecutionStreams> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Process $process) {
                if ($process.isAlive()) {
                    ProcessCloseUtil.close((Process)$process);
                }
                return Unit.INSTANCE;
            }
        }), $completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WslHostCommandExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WslHostCommandExecutor.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/wsl/execution/WslHostCommandExecutor$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

