/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.util.VectorAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00020\u0007*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00020\u0007*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/util/PaddingHelper;", "T", "", "adapter", "Lorg/jetbrains/letsPlot/commons/intern/util/VectorAdapter;", "(Lorg/jetbrains/letsPlot/commons/intern/util/VectorAdapter;)V", "x", "", "getX", "(Ljava/lang/Object;)D", "y", "getY", "pad", "Lkotlin/Pair;", "", "lineString", "", "padding", "padEnd", "padLineString", "startPadding", "endPadding", "padStart", "commons"})
@SourceDebugExtension(value={"SMAP\nPadding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Padding.kt\norg/jetbrains/letsPlot/commons/intern/util/PaddingHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n350#2,7:66\n1#3:73\n*S KotlinDebug\n*F\n+ 1 Padding.kt\norg/jetbrains/letsPlot/commons/intern/util/PaddingHelper\n*L\n28#1:66,7\n*E\n"})
public final class PaddingHelper<T> {
    @NotNull
    private final VectorAdapter<T> adapter;

    public PaddingHelper(@NotNull VectorAdapter<T> adapter) {
        Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
        this.adapter = adapter;
    }

    private final Pair<Integer, T> pad(List<? extends T> lineString, double padding) {
        int indexOutsidePadding;
        Object start2;
        block4: {
            int n;
            if (lineString.size() < 2) {
                return null;
            }
            start2 = CollectionsKt.first(lineString);
            double padding2 = padding * padding;
            List<T> $this$indexOfFirst$iv = lineString;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<T> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                T item$iv;
                T it = item$iv = iterator2.next();
                boolean bl = false;
                if (MathKt.distance2(this.getX(start2), this.getY(start2), this.getX(it), this.getY(it)) >= padding2) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = indexOutsidePadding = -1;
        }
        if (indexOutsidePadding < 1) {
            return null;
        }
        PaddingHelper $this$pad_u24lambda_u242 = this;
        boolean bl = false;
        T insidePadding = lineString.get(indexOutsidePadding - 1);
        T outsidePadding = lineString.get(indexOutsidePadding);
        double overPadding = MathKt.distance($this$pad_u24lambda_u242.getX(start2), $this$pad_u24lambda_u242.getY(start2), $this$pad_u24lambda_u242.getX(outsidePadding), $this$pad_u24lambda_u242.getY(outsidePadding)) - padding;
        DoubleVector doubleVector = MathKt.pointOnLine($this$pad_u24lambda_u242.getX(outsidePadding), $this$pad_u24lambda_u242.getY(outsidePadding), $this$pad_u24lambda_u242.getX(insidePadding), $this$pad_u24lambda_u242.getY(insidePadding), overPadding);
        boolean bl2 = false;
        double x2 = doubleVector.component1();
        double y2 = doubleVector.component2();
        T adjustedStartPoint = $this$pad_u24lambda_u242.adapter.create(x2, y2);
        return TuplesKt.to((Object)indexOutsidePadding, adjustedStartPoint);
    }

    private final List<T> padStart(List<? extends T> lineString, double padding) {
        Pair<Integer, ? extends T> pair2 = this.pad(lineString, padding);
        if (pair2 == null) {
            return lineString;
        }
        Pair<Integer, ? extends T> pair3 = pair2;
        int index = ((Number)pair3.component1()).intValue();
        Object adjustedStartPoint = pair3.component2();
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)adjustedStartPoint), (Iterable)lineString.subList(index, lineString.size()));
    }

    private final List<T> padEnd(List<? extends T> lineString, double padding) {
        Pair<Integer, T> pair2 = this.pad(CollectionsKt.asReversed(lineString), padding);
        if (pair2 == null) {
            return lineString;
        }
        Pair<Integer, T> pair3 = pair2;
        int index = ((Number)pair3.component1()).intValue();
        Object adjustedEndPoint = pair3.component2();
        return CollectionsKt.plus((Collection)lineString.subList(0, lineString.size() - index), (Object)adjustedEndPoint);
    }

    @NotNull
    public final List<T> padLineString(@NotNull List<? extends T> lineString, double startPadding, double endPadding) {
        Intrinsics.checkNotNullParameter(lineString, (String)"lineString");
        List<? extends T> startPadded = this.padStart(lineString, startPadding);
        return this.padEnd(startPadded, endPadding);
    }

    public final double getX(T $this$x) {
        return this.adapter.x($this$x);
    }

    public final double getY(T $this$y) {
        return this.adapter.y($this$y);
    }
}

