/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.scientific.cells.CellLineMarkerRenderer;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000  2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001 B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\tJ\b\u0010\u0010\u001a\u00020\tH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u001f\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/python/scientific/cells/PlyCellLinesListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "dispose", "", "caretPositionChanged", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "documentChanged", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "update", "updateHighlighting", "offsetOfFirstNonSpace", "", "text", "", "startOffset", "endOffset", "isCellStart", "", "document", "Lcom/intellij/openapi/editor/Document;", "lineNumber", "findCurrentCellLines", "Lcom/intellij/openapi/util/Pair;", "highlightCell", "removeLineMarker", "Companion", "intellij.python.scientific"})
public final class PlyCellLinesListener
implements CaretListener,
DocumentListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private static final Key<RangeHighlighter> LINE_MARKER_IN_EDITOR_KEY;

    public PlyCellLinesListener(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.editor.getCaretModel().addCaretListener((CaretListener)this);
        this.editor.getDocument().addDocumentListener((DocumentListener)this);
        this.update();
    }

    public void dispose() {
        this.editor.getCaretModel().removeCaretListener((CaretListener)this);
        this.editor.getDocument().removeDocumentListener((DocumentListener)this);
        this.removeLineMarker();
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getOldPosition().line == e.getNewPosition().line) {
            return;
        }
        RangeHighlighter marker = (RangeHighlighter)this.editor.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        if (marker != null && document.getLineNumber(marker.getStartOffset()) <= e.getNewPosition().line && document.getLineNumber(marker.getEndOffset()) >= e.getNewPosition().line) {
            return;
        }
        this.update();
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.update();
    }

    public final void update() {
        if (this.editor.getDocument().isInBulkUpdate()) {
            return;
        }
        this.updateHighlighting();
    }

    private final void updateHighlighting() {
        Pair<Integer, Integer> startEndBlock = this.findCurrentCellLines();
        if (((Number)startEndBlock.first).intValue() >= ((Number)startEndBlock.second).intValue()) {
            this.removeLineMarker();
            return;
        }
        DocumentEx documentEx = this.editor.getDocument();
        Object object = startEndBlock.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        int startOffset = documentEx.getLineStartOffset(((Number)object).intValue());
        int endOffset = this.editor.getDocument().getLineEndOffset(((Number)startEndBlock.second).intValue() - 1);
        RangeHighlighter existHighlighter = (RangeHighlighter)this.editor.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (existHighlighter != null && existHighlighter.isValid() && existHighlighter.getStartOffset() == startOffset && existHighlighter.getEndOffset() == endOffset) {
            return;
        }
        this.removeLineMarker();
        this.highlightCell(startOffset, endOffset);
    }

    private final int offsetOfFirstNonSpace(CharSequence text, int startOffset, int endOffset) {
        if (startOffset >= text.length()) {
            return startOffset;
        }
        for (int i = startOffset; i < endOffset; ++i) {
            if (text.charAt(i) == ' ' || text.charAt(i) == '\t') continue;
            return i;
        }
        return startOffset;
    }

    private final boolean isCellStart(Document document, CharSequence text, int lineNumber) {
        if (lineNumber >= document.getLineCount()) {
            return false;
        }
        int startOffset = document.getLineStartOffset(lineNumber);
        int endOffset = document.getLineEndOffset(lineNumber);
        return StringUtil.startsWith((CharSequence)text, (int)(startOffset = this.offsetOfFirstNonSpace(text, startOffset, endOffset)), (CharSequence)"# %%") || StringUtil.startsWith((CharSequence)text, (int)startOffset, (CharSequence)"#%%") || StringUtil.startsWith((CharSequence)text, (int)startOffset, (CharSequence)"# <codecell>") || StringUtil.startsWith((CharSequence)text, (int)startOffset, (CharSequence)"# In[");
    }

    private final Pair<Integer, Integer> findCurrentCellLines() {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text = charSequence;
        int caretLine = this.editor.getCaretModel().getLogicalPosition().line;
        int start = -1;
        for (int i = caretLine; -1 < i; --i) {
            if (!this.isCellStart((Document)document, text, i)) continue;
            start = i;
            break;
        }
        if (start == -1) {
            return new Pair((Object)-1, (Object)-1);
        }
        int end = -1;
        int n = document.getLineCount();
        for (int i = caretLine + 1; i < n; ++i) {
            if (!this.isCellStart((Document)document, text, i)) continue;
            end = i;
            break;
        }
        return new Pair((Object)start, (Object)(end == -1 ? document.getLineCount() : end));
    }

    private final void highlightCell(int startOffset, int endOffset) {
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        TextAttributes attributes = scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES);
        Color color = attributes.getBackgroundColor();
        if (color == null) {
            return;
        }
        Color backgroundColor = color;
        boolean isDark = ColorUtil.isDark((Color)this.editor.getColorsScheme().getDefaultBackground());
        Color color2 = isDark ? ColorUtil.shift((Color)backgroundColor, (double)1.5) : backgroundColor.darker();
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(null, startOffset, endOffset, 0, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        Intrinsics.checkNotNull((Object)color2);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new CellLineMarkerRenderer(color2, this.editor.getGutterComponentEx().getWhitespaceSeparatorOffset()));
        this.editor.putUserData(LINE_MARKER_IN_EDITOR_KEY, (Object)highlighter);
    }

    private final void removeLineMarker() {
        RangeHighlighter rangeHighlighter = (RangeHighlighter)this.editor.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (rangeHighlighter == null) {
            return;
        }
        RangeHighlighter marker = rangeHighlighter;
        this.editor.getMarkupModel().removeHighlighter(marker);
        this.editor.putUserData(LINE_MARKER_IN_EDITOR_KEY, null);
    }

    static {
        Key key = Key.create((String)"PyEditorCellManager.LINE_MARKER_IN_EDITOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LINE_MARKER_IN_EDITOR_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/python/scientific/cells/PlyCellLinesListener$Companion;", "", "<init>", "()V", "LINE_MARKER_IN_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.python.scientific"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

