#ifndef _WAVE_HEADER_H_
#define _WAVE_HEADER_H_

typedef struct
	{						/* header for WAV-Files */
	char main_chunk[4];		/* 'RIFF' */
	uint32_t length;		/* length of file */
	char chunk_type[4];		/* 'WAVE' */
	char sub_chunk[4];		/* 'fmt' */
	uint32_t length_chunk;	/* length sub_chunk, always 16 bytes */
	uint16_t format;		/* always 1 = PCM-Code */
	uint16_t modus;			/* 1 = Mono, 2 = Stereo */
	uint32_t sample_fq;		/* Sample Freq */
	uint32_t byte_p_sec;	/* Data per sec */
	uint16_t byte_p_spl;	/* bytes per sample, 1=8 bit, 2=16 bit (mono) 2=8 bit, 4=16 bit (stereo) */
	uint16_t bit_p_spl;		/* bits per sample, 8, 12, 16 */
	char data_chunk[4];		/* 'data' */
	uint32_t data_length;	/* length of data */
	} wave_header;
					
#endif /* _WAVE_HEADER_H_ */

