/*
Copyright Jan Panteltje 2002
 
subtitler-yuv is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
*/

#ifndef _SUBTITLER_H_
#define _SUBTITLER_H_

/* maximum movie length in frames */
#define MAX_FRAMES	1000000

/* set some limits for this system */
#define MAX_H_PIXELS		2048
#define MAX_V_PIXELS		2048
#define MAX_SCREEN_LINES	200

/* string sizes */
#define READSIZE	65535

/* for status in frame browser USE 1 2 4 8 */
#define NEW_ENTRY		0
#define NO_SPACE		1
#define TOO_LONG		2
#define TXT_HOLD		4

/* for object type IDs */
#define FORMATTED_TEXT			1
#define X_Y_Z_T_TEXT			2
#define X_Y_Z_T_PICTURE			3
#define X_Y_Z_T_FRAME_COUNTER	4
#define X_Y_Z_T_MOVIE			5
#define MAIN_MOVIE				6
#define SUBTITLE_CONTROL		7

/* for formatting subtitles */
#define SUBTITLE_H_FACTOR	.02
#define SUBTITLE_V_FACTOR	.042

/* for this specfic default font */
#define EXTRA_CHAR_SPACE	1 //l followed by t overlap in this font

/*
for masking out areas in rotate and shear.
These 2 values are related, and I have not figured out the relation yet.
YUV_MASK is used to prevent picture areas to be cut out. 
*/
#define LUMINANCE_MASK	178
#define YUV_MASK		164

/* status of operations on an object, use 1, 2, 4, etc. */
#define OBJECT_STATUS_NEW			0
#define OBJECT_STATUS_INIT			1
#define OBJECT_STATUS_GOTO			2
#define OBJECT_STATUS_HAVE_X_DEST	4
#define OBJECT_STATUS_HAVE_Y_DEST	8
#define OBJECT_STATUS_HAVE_Z_DEST	16
#define OBJECT_STATUS_NO_YUV_OUTPUT	32


#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <inttypes.h>
#include <string.h>
#include <stddef.h>
#include <pwd.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <limits.h>
#include <pthread.h>
#include <sys/poll.h>
#include <stdint.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "load_font.h"
#include "frame_list.h"
#include "object_list.h"

int debug_flag;
font_desc_t *vo_font;
font_desc_t *subtitle_current_font_descriptor;
uint8_t *ImageData;
int image_width, image_height;
int default_font;
struct passwd *userinfo;
char *home_dir;
char *user_name;
int sync_mode;
int osd_transp;
int screen_start[MAX_H_PIXELS];
char *tptr;
int screen_lines;
char screen_text[MAX_SCREEN_LINES][MAX_H_PIXELS];
char format_start_str[50];
char format_end_str[50];
int vert_position;
int line_height;
int line_h_start, line_h_end;
int center_flag;
int wtop, wbottom, hstart, hend;
int window_top, window_bottom;
char *frame_memory0, *frame_memory1 ;
int file_format;
char *subtitle_file;
char *default_font_dir;
//vob_t *vob;
char *selected_data_directory;
char *selected_project;
int frame_offset;
double dmax_vector;
int use_pre_processing_flag;

/* for x11 stuff */
int show_output_flag;
int window_open_flag;
int window_size, buffer_size;
unsigned char *ucptrs, *ucptrd;
int color_depth;
/* end x11 stuff */

/* maximum number of movie objects that can be inserted */
#define MAX_MOVIES	1024
/* threads for other instances of transcode in insert movie */
pthread_t *movie_thread[MAX_MOVIES];
pthread_attr_t *attributes;

/* global subtitle parameters */
double ssat, dssat, scol, dscol;
double default_font_factor;
double default_subtitle_vespace;


/* for rotate and shear, the luminance where we cut out the border */
int border_luminance;
int default_border_luminance;

double subtitle_h_factor;
double subtitle_v_factor;
double extra_character_space;
double subtitle_extra_character_space;
double subtitle_vespace;
//double subtitle_dvespace;

int ppml_first_frame, ppml_last_frame;
int current_frame_nr;
int test_mode;
int skip_flag;

/* CCIR spec, taken from ffmpeg source, to match their colors */
#define SCALEBITS 10
#define FIX(x)    ((int) ((x) * (1<<SCALEBITS) + 0.5))
#define ONE_HALF  (1 << (SCALEBITS - 1))

#define RGB_TO_Y_CCIR(r, g, b) \
((FIX(0.29900*219.0/255.0) * (r) + FIX(0.58700*219.0/255.0) * (g) + \
  FIX(0.11400*219.0/255.0) * (b) + (ONE_HALF + (16 << SCALEBITS))) >> SCALEBITS)

#define RGB_TO_U_CCIR(r1, g1, b1, shift)\
(((- FIX(0.16874*224.0/255.0) * r1 - FIX(0.33126*224.0/255.0) * g1 +         \
     FIX(0.50000*224.0/255.0) * b1 + (ONE_HALF << shift) - 1) >> (SCALEBITS + shift)) + 128)

#define RGB_TO_V_CCIR(r1, g1, b1, shift)\
(((FIX(0.50000*224.0/255.0) * r1 - FIX(0.41869*224.0/255.0) * g1 -           \
   FIX(0.08131*224.0/255.0) * b1 + (ONE_HALF << shift) - 1) >> (SCALEBITS + shift)) + 128)

/* this last, so proto knows about structure definitions etc. */
#include "subtitler_proto.h"

#define SUBTITLER_VERSION "-0.6.5"

#endif /* _SUBTITLER_H_ */
