/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class SFFParse
extends BaseParse {
    String[] col_names = new String[]{"Query Name", "Read Sequence", "Read Quality"};
    private RandomAccessFile filein;
    long index_offset = 0L;
    long index_length = 0L;
    int number_of_flows_per_read = 0;
    static int FLOWGRAM_BYTES_PER_FLOW = 2;
    char[] flow_chars = null;

    public SFFParse(String string) {
        super(string);
        try {
            this.filein = new RandomAccessFile(string, "r");
            this.parseHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void seek(long l) throws IOException {
        this.filein.seek(l);
    }

    @Override
    public long getNextRecordIndex() {
        long l = 0L;
        try {
            l = this.filein.getFilePointer();
            if (l == this.index_offset) {
                this.filein.seek(l + this.index_length);
                l = this.filein.getFilePointer();
            }
            int n = this.filein.readUnsignedShort();
            int n2 = this.filein.readUnsignedShort();
            byte[] byArray = new byte[4];
            this.filein.read(byArray);
            long l2 = BytesHelper.toUintRev(byArray);
            this.filein.seek(l + (long)n);
            long l3 = (long)(FLOWGRAM_BYTES_PER_FLOW * this.number_of_flows_per_read) + 3L * l2;
            if ((l3 & 7L) > 0L) {
                l3 = (l3 >> 3) + 1L << 3;
            }
            this.filein.seek(l + (long)n + l3);
            return l;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public String[] getNextRecord() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            int n;
            long l = this.filein.getFilePointer();
            int n2 = this.filein.readUnsignedShort();
            int n3 = this.filein.readUnsignedShort();
            int n4 = this.filein.readInt();
            int n5 = this.filein.readUnsignedShort();
            int n6 = this.filein.readUnsignedShort();
            int n7 = this.filein.readUnsignedShort();
            int n8 = this.filein.readUnsignedShort();
            int n9 = Math.max(1, Math.max(n5, n7)) - 1;
            int n10 = Math.min(n6 == 0 ? n4 : n6, n8 == 0 ? n4 : n8);
            byte[] byArray = new byte[n3];
            this.filein.read(byArray);
            char[] cArray = new String(byArray).toCharArray();
            this.filein.seek(l + (long)n2);
            long l2 = FLOWGRAM_BYTES_PER_FLOW * this.number_of_flows_per_read + 3 * n4;
            if ((l2 & 7L) > 0L) {
                l2 = (l2 >> 3) + 1L << 3;
            }
            this.filein.seek(this.filein.getFilePointer() + (long)(2 * this.number_of_flows_per_read) + (long)n4);
            byArray = new byte[n4];
            this.filein.read(byArray);
            char[] cArray2 = new String(byArray).toCharArray();
            for (n = 0; n < n9; ++n) {
                cArray2[n] = Character.toLowerCase(cArray2[n]);
            }
            for (n = n10; n < cArray2.length; ++n) {
                cArray2[n] = Character.toLowerCase(cArray2[n]);
            }
            byte[] byArray2 = new byte[n4];
            this.filein.read(byArray2);
            int n11 = 0;
            while (n11 < byArray2.length) {
                int n12 = n11++;
                byArray2[n12] = (byte)(byArray2[n12] + 33);
            }
            this.filein.seek(l + (long)n2 + l2);
            arrayList.add(new String(cArray));
            arrayList.add(new String(cArray2));
            arrayList.add(new String(byArray2));
        }
        catch (Exception exception) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    @Override
    public double getProgress() {
        try {
            return 1.0 * (double)this.filein.getFilePointer() / (1.0 * (double)this.filein.length());
        }
        catch (IOException iOException) {
            return 1.0;
        }
    }

    private void parseHeader() {
        this.header = "";
        try {
            int n;
            byte[] byArray = new byte[4];
            this.filein.read(byArray);
            this.header = this.header + "Magic: " + new String(byArray) + "\n";
            this.filein.read(byArray);
            this.header = this.header + "Version: ";
            for (n = 0; n < byArray.length; ++n) {
                this.header = this.header + byArray[n];
            }
            this.header = this.header + "\n";
            this.index_offset = this.filein.readLong();
            this.header = this.header + "Index Offset: " + this.index_offset + "\n";
            this.filein.read(byArray);
            this.index_length = BytesHelper.toUintRev(byArray);
            this.header = this.header + "Index Length: " + this.index_length + "\n";
            this.filein.read(byArray);
            this.header = this.header + "# of Reads: " + BytesHelper.toUintRev(byArray) + "\n";
            n = this.filein.readUnsignedShort();
            int n2 = this.filein.readUnsignedShort();
            this.number_of_flows_per_read = this.filein.readUnsignedShort();
            this.header = this.header + "Format Code: " + this.filein.readUnsignedByte() + "\n";
            byArray = new byte[this.number_of_flows_per_read];
            this.filein.read(byArray);
            this.flow_chars = new String(byArray).toCharArray();
            byArray = new byte[n2];
            this.filein.read(byArray);
            this.header = this.header + "Key Sequence: " + new String(byArray) + "\n";
            this.filein.seek(n);
        }
        catch (IOException iOException) {
            System.out.println("Error in Parsing Header");
        }
    }

    @Override
    public String getToolTip(String string, int n, int n2, String[] stringArray) {
        if (n2 == 1 && stringArray.length > 2) {
            String string2 = stringArray[2];
            return this.prettyPrintBaseQual(string, string2);
        }
        return string;
    }

    protected String prettyPrintBaseQual(String string, String string2) {
        if (string.equals("*") || string.length() != string2.length()) {
            return "<html><font size=\"5\">" + string + "</font></html>";
        }
        String string3 = "<html>";
        for (int i = 0; i < string.length(); ++i) {
            string3 = string3 + "<font size=\"5\" color=\"";
            int n = string2.charAt(i) - 33;
            string3 = n < 20 ? string3 + "#E9CFEC" : string3 + "#571B7e";
            string3 = string3 + "\">";
            string3 = string3 + string.charAt(i);
            string3 = string3 + "</font>";
        }
        string3 = string3 + "</html>";
        return string3;
    }

    @Override
    public String getColumnName(int n) {
        if (this.col_names == null) {
            return "";
        }
        if (n >= this.col_names.length) {
            return "";
        }
        if (n < 0) {
            return "";
        }
        return this.col_names[n];
    }

    @Override
    public int getNumColumnLabels() {
        if (this.col_names == null) {
            return 0;
        }
        return this.col_names.length;
    }
}

