/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;
import net.sf.samtools.util.BlockCompressedInputStream;

public class BAMParse
extends AlignParse {
    BlockCompressedInputStream bgzf = null;
    HashMap<Integer, String> refmap = null;
    int block_size = 0;
    long file_size = 1L;

    public BAMParse(String string) {
        super(string);
        try {
            this.file_size = new File(string).length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.file_size = 1L;
        }
        try {
            this.bgzf = new BlockCompressedInputStream(new File(string));
            if (!this.isBAM()) {
                this.bgzf.close();
            } else {
                this.parseHeader();
                this.getReferences();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isBAM() {
        try {
            this.bgzf.seek(0L);
            byte[] byArray = new byte[4];
            this.bgzf.read(byArray);
            String string = new String(byArray);
            return string.equals("BAM\u0001");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    @Override
    public void seek(long l) throws IOException {
        this.bgzf.seek(l);
    }

    @Override
    public long getNextRecordIndex() {
        long l = 0L;
        try {
            l = this.bgzf.getFilePointer();
            byte[] byArray = new byte[4];
            if (this.bgzf.read(byArray) != 4) {
                return -1L;
            }
            this.block_size = BytesHelper.toInt(byArray);
            byte[] byArray2 = new byte[this.block_size];
            this.bgzf.read(byArray2);
            return l;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Override
    public String[] getNextRecord() {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            int n;
            objectArray = new byte[2];
            byte[] byArray = new byte[36];
            if (this.bgzf.read(byArray) != 36) {
                return null;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.block_size = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            String string = null;
            string = this.refmap.get(new Integer(n2));
            if (string == null) {
                string = new String("*");
            }
            int n3 = byteBuffer.getInt() + 1;
            int n4 = byteBuffer.get() & 0xFF;
            int n5 = byteBuffer.get() & 0xFF;
            byteBuffer.get();
            byteBuffer.get();
            byteBuffer.get((byte[])objectArray);
            int n6 = ((objectArray[1] & 0xFF) << 8) + (objectArray[0] & 0xFF);
            byteBuffer.get((byte[])objectArray);
            int n7 = ((objectArray[1] & 0xFF) << 8) + (objectArray[0] & 0xFF);
            int n8 = byteBuffer.getInt();
            int n9 = byteBuffer.getInt();
            int n10 = byteBuffer.getInt() + 1;
            String string2 = null;
            if (n2 == n9) {
                string2 = "=";
            } else {
                string2 = this.refmap.get(new Integer(n9));
                if (string2 == null) {
                    string2 = new String("*");
                }
            }
            int n11 = byteBuffer.getInt();
            this.block_size -= 32;
            byte[] byArray2 = new byte[n4 - 1];
            this.bgzf.read(byArray2);
            this.bgzf.read(new byte[1]);
            String string3 = new String(byArray2);
            this.block_size -= n4;
            String string4 = "";
            byte[] byArray3 = new byte[4];
            for (n = 0; n < n6; ++n) {
                this.bgzf.read(byArray3);
                int n12 = BytesHelper.toInt(byArray3);
                string4 = string4 + (n12 >> 4 & 0xFFFFFFF);
                string4 = string4 + this.getOp(n12 & 0xF);
            }
            if (string4.length() < 1) {
                string4 = "*";
            }
            this.block_size -= 4 * n6;
            n = (n8 + 1) / 2;
            byte[] byArray4 = new byte[n];
            this.bgzf.read(byArray4);
            String string5 = "";
            for (int i = 0; i < n; ++i) {
                string5 = string5 + this.getBase(byArray4[i] >> 4 & 0xF);
                if (2 * i + 1 >= n8) continue;
                string5 = string5 + this.getBase(byArray4[i] & 0xF);
            }
            if (string5.length() < 1) {
                string5 = "*";
            }
            this.block_size -= n;
            String string6 = new String("*");
            if (n8 != 0) {
                boolean bl = true;
                object = new byte[n8];
                this.bgzf.read((byte[])object);
                int n13 = 0;
                while (n13 < ((byte[])object).length) {
                    if (object[n13] != -1) {
                        bl = false;
                    }
                    int n14 = n13++;
                    object[n14] = (byte)(object[n14] + 33);
                }
                if (!bl) {
                    string6 = new String((byte[])object);
                }
            }
            this.block_size -= n8;
            arrayList.add(string3);
            arrayList.add("" + n7);
            arrayList.add(string);
            arrayList.add("" + n3);
            arrayList.add("" + n5);
            arrayList.add(string4);
            arrayList.add(string2);
            arrayList.add("" + n10);
            arrayList.add("" + n11);
            arrayList.add(string5);
            arrayList.add(string6);
            while (this.block_size > 0) {
                byte[] byArray5 = new byte[2];
                this.bgzf.read(byArray5);
                object = new String(byArray5) + ":";
                this.block_size -= 2;
                byte[] byArray6 = new byte[1];
                this.bgzf.read(byArray6);
                --this.block_size;
                String string7 = this.getVal(byArray6);
                if (byArray6[0] != 65 && byArray6[0] != 66 && byArray6[0] != 102 && byArray6[0] != 90 && byArray6[0] != 72) {
                    byArray6[0] = 105;
                }
                object = (String)object + new String(byArray6) + ":" + string7;
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            return null;
        }
        objectArray = new String[arrayList.size()];
        return (String[])arrayList.toArray(objectArray);
    }

    @Override
    public double getProgress() {
        return 1.0 * (double)BlockCompressedFilePointerUtil.getBlockAddress(this.bgzf.getFilePointer()) / (1.0 * (double)this.file_size);
    }

    private void parseHeader() {
        this.header = "";
        try {
            byte[] byArray = new byte[4];
            this.bgzf.read(byArray);
            int n = BytesHelper.toInt(byArray);
            byArray = new byte[n];
            this.bgzf.read(byArray);
            this.header = new String(byArray);
        }
        catch (IOException iOException) {
            System.out.println("Error in Parsing Header");
        }
    }

    private void getReferences() {
        try {
            byte[] byArray = new byte[4];
            this.bgzf.read(byArray);
            int n = BytesHelper.toInt(byArray);
            this.refmap = new HashMap(n);
            this.refmap.put(new Integer(-1), "*");
            for (int i = 0; i < n; ++i) {
                this.bgzf.read(byArray);
                int n2 = BytesHelper.toInt(byArray);
                byte[] byArray2 = new byte[n2 - 1];
                this.bgzf.read(byArray2);
                this.refmap.put(new Integer(i), new String(byArray2));
                this.bgzf.read(new byte[5]);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error in getting references");
        }
    }

    private char getBase(int n) {
        if (n <= 0) {
            return '=';
        }
        if (n <= 1) {
            return 'A';
        }
        if (n <= 2) {
            return 'C';
        }
        if (n <= 4) {
            return 'G';
        }
        if (n <= 8) {
            return 'T';
        }
        return 'N';
    }

    private char getOp(int n) {
        switch (n) {
            case 0: {
                return 'M';
            }
            case 1: {
                return 'I';
            }
            case 2: {
                return 'D';
            }
            case 3: {
                return 'N';
            }
            case 4: {
                return 'S';
            }
            case 5: {
                return 'H';
            }
            case 6: {
                return 'P';
            }
            case 7: {
                return '=';
            }
        }
        return 'X';
    }

    private String getVal(byte[] byArray) {
        String string = null;
        byte[] byArray2 = null;
        int n = 0;
        try {
            switch (byArray[0]) {
                case 65: {
                    byArray2 = new byte[1];
                    this.bgzf.read(byArray2);
                    --this.block_size;
                    string = new String(byArray2);
                    break;
                }
                case 99: {
                    byArray2 = new byte[1];
                    this.bgzf.read(byArray2);
                    --this.block_size;
                    n = byArray2[0];
                    string = "" + n;
                    break;
                }
                case 67: {
                    byArray2 = new byte[1];
                    this.bgzf.read(byArray2);
                    --this.block_size;
                    n = byArray2[0] & 0xFF;
                    string = "" + n;
                    break;
                }
                case 115: {
                    byArray2 = new byte[2];
                    this.bgzf.read(byArray2);
                    this.block_size -= 2;
                    string = "" + BytesHelper.shortToInt(byArray2);
                    break;
                }
                case 83: {
                    byArray2 = new byte[2];
                    this.bgzf.read(byArray2);
                    this.block_size -= 2;
                    string = "" + BytesHelper.shortToUint(byArray2);
                    break;
                }
                case 105: {
                    byArray2 = new byte[4];
                    this.bgzf.read(byArray2);
                    this.block_size -= 4;
                    string = "" + BytesHelper.toInt(byArray2);
                    break;
                }
                case 73: {
                    byArray2 = new byte[4];
                    this.bgzf.read(byArray2);
                    this.block_size -= 4;
                    string = "" + BytesHelper.toUint(byArray2);
                    break;
                }
                case 102: {
                    byArray2 = new byte[4];
                    this.block_size -= this.bgzf.read(byArray2);
                    string = "" + Float.intBitsToFloat(BytesHelper.toInt(byArray2));
                    break;
                }
                case 90: {
                    string = this.getNullTerminatedString();
                    break;
                }
                case 72: {
                    string = this.getHexString();
                    break;
                }
                case 66: {
                    byArray2 = new byte[1];
                    this.block_size -= this.bgzf.read(byArray2);
                    string = new String(byArray2);
                    byte[] byArray3 = new byte[4];
                    this.block_size -= this.bgzf.read(byArray3);
                    int n2 = BytesHelper.toInt(byArray3);
                    for (int i = 0; i < n2; ++i) {
                        string = string + ",";
                        string = string + this.getVal(byArray2);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            return string;
        }
        return string;
    }

    private String getNullTerminatedString() {
        byte[] byArray = new byte[1];
        String string = "";
        try {
            while (this.bgzf.read(byArray) > 0) {
                --this.block_size;
                if (byArray[0] != 0) {
                    string = string + (char)byArray[0];
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            return string;
        }
        return string;
    }

    private String getHexString() {
        byte[] byArray = new byte[1];
        String string = "";
        int n = 0;
        try {
            while (this.bgzf.read(byArray) > 0) {
                --this.block_size;
                n = byArray[0] >> 4 & 0xF;
                if (n != 0) {
                    string = string + Integer.toHexString(n);
                    n = byArray[0] & 0xF;
                    if (n != 0) {
                        string = string + Integer.toHexString(n);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            return string;
        }
        return string;
    }
}

