"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Message = void 0;
var react_1 = __importDefault(require("react"));
var MessageExample_1 = require("./MessageExample");
var components_1 = require("../../components");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var Message = function (_a) {
    var message = _a.message, messageName = _a.messageName, index = _a.index, _b = _a.showExamples, showExamples = _b === void 0 ? false : _b;
    var config = (0, contexts_1.useConfig)();
    if (!message) {
        return null;
    }
    var messageId = typeof message.id === 'function' && message.id();
    var title = message.title();
    var summary = message.summary();
    var payload = message.payload();
    var headers = message.headers();
    var correlationId = message.correlationId();
    var contentType = message.contentType();
    var externalDocs = message.externalDocs();
    var showInfoList = contentType !== null && contentType !== void 0 ? contentType : externalDocs;
    return (react_1.default.createElement("div", { className: "panel-item" },
        react_1.default.createElement("div", { className: "panel-item--center px-8" },
            react_1.default.createElement("div", { className: "shadow rounded bg-gray-200 p-4 border" },
                react_1.default.createElement("div", null,
                    index !== undefined && (react_1.default.createElement("strong", { className: "text-gray-700 mr-2" },
                        "#",
                        index)),
                    title && react_1.default.createElement("span", { className: "text-gray-700 mr-2" }, title)),
                summary && react_1.default.createElement("p", { className: "text-gray-600 text-sm" }, summary),
                showInfoList && (react_1.default.createElement("ul", { className: "leading-normal mt-2 mb-4 space-x-2 space-y-2" },
                    contentType && (react_1.default.createElement("li", { className: "inline-block" },
                        react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "".concat(constants_1.CONTENT_TYPES_SITE, "/").concat(contentType) },
                            react_1.default.createElement("span", null, contentType)))),
                    externalDocs && (react_1.default.createElement("li", { className: "inline-block" },
                        react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url() },
                            react_1.default.createElement("span", null, constants_1.EXTERAL_DOCUMENTATION_TEXT)))))),
                messageId && (react_1.default.createElement("div", { className: "border bg-gray-100 rounded px-4 py-2 mt-2" },
                    react_1.default.createElement("div", { className: "text-sm text-gray-700" },
                        "Message ID",
                        react_1.default.createElement("span", { className: "bg-orange-600 text-white rounded text-xs ml-2 py-0 px-2" }, messageId)))),
                correlationId && (react_1.default.createElement("div", { className: "border bg-gray-100 rounded px-4 py-2 mt-2" },
                    react_1.default.createElement("div", { className: "text-sm text-gray-700" },
                        "Correlation ID",
                        react_1.default.createElement("span", { className: "bg-orange-600 text-white rounded text-xs ml-2 py-0 px-2" }, correlationId.location())),
                    correlationId.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
                        react_1.default.createElement(components_1.Markdown, null, correlationId.description()))))),
                message.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
                    react_1.default.createElement(components_1.Markdown, null, message.description()))),
                payload && (react_1.default.createElement("div", { className: "mt-2", id: messageName
                        ? helpers_1.CommonHelpers.getIdentifier("message-".concat(messageName, "-payload"), config)
                        : undefined },
                    react_1.default.createElement(components_1.Schema, { schemaName: "Payload", schema: payload }))),
                headers && (react_1.default.createElement("div", { className: "mt-2", id: messageName
                        ? helpers_1.CommonHelpers.getIdentifier("message-".concat(messageName, "-headers"), config)
                        : undefined },
                    react_1.default.createElement(components_1.Schema, { schemaName: "Headers", schema: headers }))),
                message.bindings().length > 0 && (react_1.default.createElement("div", { className: "mt-2" },
                    react_1.default.createElement(components_1.Bindings, { name: "Message specific information", bindings: message.bindings() }))),
                react_1.default.createElement(components_1.Extensions, { item: message }),
                message.tags().length > 0 && (react_1.default.createElement("div", { className: "mt-2" },
                    react_1.default.createElement(components_1.Tags, { tags: message.tags() }))))),
        showExamples && (react_1.default.createElement("div", { className: "panel-item--right px-8" },
            react_1.default.createElement(MessageExample_1.MessageExample, { message: message })))));
};
exports.Message = Message;
//# sourceMappingURL=Message.js.map