/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.refactoring.introduceVariable;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.impl.stubs.index.CssCustomPropertyIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssExtractVariableDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiFile myFile;
    private final JBTextField myNameTextField;
    private final JBCheckBox myAllOccurrencesCheckBox;

    public CssExtractVariableDialog(@NotNull Project project, @NotNull PsiFile file, @NotNull String name, int occurrencesCount) {
        if (project == null) {
            CssExtractVariableDialog.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CssExtractVariableDialog.$$$reportNull$$$0(1);
        }
        if (name == null) {
            CssExtractVariableDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myNameTextField = new JBTextField();
        this.myAllOccurrencesCheckBox = new JBCheckBox();
        this.myProject = project;
        this.myFile = file;
        this.myNameTextField.setText(name);
        if (name.startsWith("--")) {
            this.myNameTextField.select(2, name.length());
            this.myNameTextField.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, (Object)true);
        }
        this.myAllOccurrencesCheckBox.setText(occurrencesCount == 1 ? RefactoringBundle.message((String)"replace.all.occurences.checkbox") : RefactoringBundle.message((String)"replace.all.occurences", (Object[])new Object[]{occurrencesCount}));
        this.myAllOccurrencesCheckBox.setEnabled(occurrencesCount > 1);
        this.setTitle(RefactoringBundle.message((String)"introduce.variable.title"));
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return FormBuilder.createFormBuilder().addLabeledComponent(CssBundle.message("label.text.name2", new Object[0]), (JComponent)this.myNameTextField).addComponent((JComponent)this.myAllOccurrencesCheckBox).getPanel();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.getName().startsWith("--")) {
            return new ValidationInfo(CssBundle.message("validation.info.custom.property.name.must.start.with.dash.dash", new Object[0]), (JComponent)this.myNameTextField);
        }
        if (this.getName().equals("--")) {
            return new ValidationInfo(CssBundle.message("validation.info.custom.property.name.cant.be.dash.dash", new Object[0]), (JComponent)this.myNameTextField);
        }
        if (!LanguageNamesValidation.isIdentifier((Language)CSSLanguage.INSTANCE, (String)this.getName(), (Project)this.myProject)) {
            return new ValidationInfo(CssBundle.message("validation.info.invalid.custom.property.name", new Object[0]), (JComponent)this.myNameTextField);
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)this.myFile);
        if (!StubIndex.getElements(CssCustomPropertyIndex.KEY, (Object)this.getName(), (Project)this.myProject, (GlobalSearchScope)scope, CssDeclaration.class).isEmpty()) {
            return new ValidationInfo(CssBundle.message("validation.info.custom.property.with.this.name.already.exists", new Object[0]), (JComponent)this.myNameTextField);
        }
        return null;
    }

    @NotNull
    String getName() {
        String string = this.myNameTextField.getText().trim();
        if (string == null) {
            CssExtractVariableDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    boolean isReplaceAllOccurrences() {
        return this.myAllOccurrencesCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/refactoring/introduceVariable/CssExtractVariableDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

