/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.core.statistics.action;

import com.intellij.dataWrangler.core.statistics.CoreStatisticsHeader;
import com.intellij.dataWrangler.core.statistics.CoreStatisticsHeaderKt;
import com.intellij.dataWrangler.core.statistics.action.CoreStatisticsDisplayActionKt;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsPanelMode;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u0011\u0012\u0013B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "presentationMode", "Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsPanelMode;", "<init>", "(Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsPanelMode;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "StatisticsShowOff", "StatisticsShowCompact", "StatisticsShowDetailed", "Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction$StatisticsShowCompact;", "Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction$StatisticsShowDetailed;", "Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction$StatisticsShowOff;", "intellij.dataWrangler.core"})
public abstract class CoreStatisticsDisplayAction
extends ToggleAction
implements DumbAware {
    @NotNull
    private final StatisticsPanelMode presentationMode;

    private CoreStatisticsDisplayAction(StatisticsPanelMode presentationMode) {
        this.presentationMode = presentationMode;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setKeepPopupOnPerform(KeepPopupOnPerform.Never);
        e.getPresentation().setEnabledAndVisible(CoreStatisticsDisplayActionKt.access$isStatisticsAvailable(e));
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return false;
        }
        DataGrid grid = dataGrid;
        ResultView resultView = grid.getResultView();
        TableResultView tableResultView = resultView instanceof TableResultView ? (TableResultView)resultView : null;
        if (tableResultView == null) {
            return false;
        }
        TableResultView tableWithStatistics = tableResultView;
        return tableWithStatistics.getStatisticsPanelMode() == this.presentationMode;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return;
        }
        DataGrid grid = dataGrid;
        ResultView resultView = grid.getResultView();
        TableResultView tableResultView = resultView instanceof TableResultView ? (TableResultView)resultView : null;
        if (tableResultView == null) {
            return;
        }
        TableResultView tableWithStatistics = tableResultView;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        CoreStatisticsHeader coreStatisticsHeader = CoreStatisticsHeaderKt.findCoreStatisticsHeader(dataContext);
        if (coreStatisticsHeader == null) {
            coreStatisticsHeader = new CoreStatisticsHeader(tableWithStatistics, grid);
        }
        CoreStatisticsHeader header = coreStatisticsHeader;
        header.setMode(this.presentationMode);
    }

    public /* synthetic */ CoreStatisticsDisplayAction(StatisticsPanelMode presentationMode, DefaultConstructorMarker $constructor_marker) {
        this(presentationMode);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction$StatisticsShowCompact;", "Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction;", "<init>", "()V", "intellij.dataWrangler.core"})
    public static final class StatisticsShowCompact
    extends CoreStatisticsDisplayAction {
        public StatisticsShowCompact() {
            super(StatisticsPanelMode.COMPACT, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction$StatisticsShowDetailed;", "Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction;", "<init>", "()V", "intellij.dataWrangler.core"})
    public static final class StatisticsShowDetailed
    extends CoreStatisticsDisplayAction {
        public StatisticsShowDetailed() {
            super(StatisticsPanelMode.DETAILED, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction$StatisticsShowOff;", "Lcom/intellij/dataWrangler/core/statistics/action/CoreStatisticsDisplayAction;", "<init>", "()V", "intellij.dataWrangler.core"})
    public static final class StatisticsShowOff
    extends CoreStatisticsDisplayAction {
        public StatisticsShowOff() {
            super(StatisticsPanelMode.OFF, null);
        }
    }
}

