/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.actions.DiagramActionPopupConsumer;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.diagram.state.DiagramFullSnapshot;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramAction
extends AnAction {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DiagramAction.class);

    public DiagramAction() {
        this.setEnabledInModalContext(true);
    }

    protected DiagramAction(@Nls String name, @Nullable @Nls String description, @Nullable Icon icon) {
        this(() -> name, () -> description, icon);
    }

    protected DiagramAction(@NotNull Supplier<@Nls String> dynamicName, @NotNull Supplier<@Nls String> dynamicDescription, @Nullable Icon icon) {
        if (dynamicName == null) {
            DiagramAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            DiagramAction.$$$reportNull$$$0(1);
        }
        super(dynamicName, dynamicDescription, icon);
        this.setEnabledInModalContext(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(2);
        }
        DiagramBuilder builder = DiagramAction.getBuilder(e);
        e.getPresentation().setEnabled(builder != null && this.isEnabled(e, builder));
        if (builder != null) {
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.isSelected(e, builder));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DiagramAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public abstract void perform(@NotNull AnActionEvent var1);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(4);
        }
        if ((builder = DiagramAction.getBuilder(e)) == null) {
            return;
        }
        Project project = builder.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DiagramFullSnapshot oldSnapshot = (DiagramFullSnapshot)builder.getActionExecutor().suppressComputableReadLockAssertion(() -> DiagramFullSnapshot.Factory.getInstance().makeSnapshot(builder));
        if (this instanceof DiagramActionWithPreparation) {
            DiagramActionWithPreparation actionWithPreparation = (DiagramActionWithPreparation)this;
            Object data = ReadAction.compute(() -> actionWithPreparation.prepare(e));
            if (data != null) {
                WriteCommandAction.writeCommandAction((Project)project).withName(this.getActionName()).withGroupId(this.getActionGroupId(e)).run(() -> {
                    PsiFile[] files = this.getAffectedFiles(e);
                    actionWithPreparation.execute(builder, data, e);
                    DiagramActionsManager.getInstance(project).actionPerformed(builder, oldSnapshot, files);
                    builder.notifyOtherBuilders();
                });
            }
        } else if (this.isUndoable(e)) {
            WriteCommandAction.writeCommandAction((Project)project).withName(this.getActionName()).withGroupId(this.getActionGroupId(e)).run(() -> {
                PsiFile[] files = this.getAffectedFiles(e);
                this.perform(e);
                DiagramActionsManager.getInstance(project).actionPerformed(builder, oldSnapshot, files);
                builder.notifyOtherBuilders();
            });
        } else {
            this.perform(e);
            builder.notifyOtherBuilders();
        }
    }

    public PsiFile @NotNull [] getAffectedFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(5);
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            DiagramAction.$$$reportNull$$$0(6);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    @Nullable
    public static DiagramBuilder getBuilder(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(7);
        }
        return DiagramAction.getBuilderFromActionEvent(e);
    }

    @Nullable
    public static DiagramProvider getProvider(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(8);
        }
        return (builder = DiagramAction.getBuilder(e)) == null ? null : builder.getProvider();
    }

    @Nullable
    public static DiagramDataModel getDataModel(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(9);
        }
        return (builder = DiagramAction.getBuilder(e)) == null ? null : builder.getDataModel();
    }

    @Nullable
    public static DiagramBuilder getBuilderFromActionEvent(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(10);
        }
        return (DiagramBuilder)e.getData(DiagramDataKeys.BUILDER);
    }

    @Nullable
    public static Graph2D getGraph(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(11);
        }
        return (builder = DiagramAction.getBuilder(e)) == null ? null : builder.getGraph();
    }

    public boolean isSelected(@NotNull AnActionEvent e, @NotNull DiagramBuilder b) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(12);
        }
        if (b == null) {
            DiagramAction.$$$reportNull$$$0(13);
        }
        return false;
    }

    public boolean isEnabled(@NotNull AnActionEvent e, @NotNull DiagramBuilder b) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(14);
        }
        if (b == null) {
            DiagramAction.$$$reportNull$$$0(15);
        }
        return true;
    }

    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(16);
        }
        return true;
    }

    @Nullable
    @NonNls
    public String getActionGroupId(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(17);
        }
        return null;
    }

    @NotNull
    @Nls
    public abstract String getActionName();

    @NotNull
    public static List<DiagramNode> getSelectedNodes(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(18);
        }
        return DiagramAction.getSelectedNodes(DiagramAction.getBuilder(e));
    }

    @NotNull
    public static List<DiagramNode> getSelectedNodes(@Nullable DiagramBuilder builder) {
        return builder != null ? ContainerUtil.map((Collection)GraphSelectionService.getInstance().getSelectedNodes(builder.getGraph()), builder::getNodeObject) : new ArrayList<DiagramNode>();
    }

    @NotNull
    public static List<DiagramNode> getSelectedNodesExceptNotes(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(19);
        }
        if ((builder = DiagramAction.getBuilder(e)) == null) {
            List<DiagramNode> list = List.of();
            if (list == null) {
                DiagramAction.$$$reportNull$$$0(20);
            }
            return list;
        }
        List selectedNodes = GraphSelectionService.getInstance().getSelectedModelNodes(builder.getGraphBuilder());
        List list = ContainerUtil.filter((Collection)selectedNodes, it -> !(it instanceof DiagramNoteNode));
        if (list == null) {
            DiagramAction.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public static Runnable createCallback(@NotNull DiagramBuilder builder, @NotNull PopupCallback callback) {
        if (builder == null) {
            DiagramAction.$$$reportNull$$$0(22);
        }
        if (callback == null) {
            DiagramAction.$$$reportNull$$$0(23);
        }
        Runnable runnable = () -> {
            DiagramFullSnapshot oldSnapshot = DiagramFullSnapshot.Factory.getInstance().makeSnapshot(builder);
            Project project = builder.getProject();
            WriteCommandAction.writeCommandAction((Project)project).withName(callback.getActionName()).withGroupId(callback.getGroupName()).run(() -> {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                PsiFile[] files = callback.getAffectedFiles();
                callback.run();
                DiagramActionsManager.getInstance(project).actionPerformed(builder, oldSnapshot, files);
            });
        };
        if (runnable == null) {
            DiagramAction.$$$reportNull$$$0(24);
        }
        return runnable;
    }

    @NotNull
    public static <T> Consumer<T> createCallback(@NotNull DiagramBuilder builder, @NotNull DiagramActionPopupConsumer<? super T> callback) {
        if (builder == null) {
            DiagramAction.$$$reportNull$$$0(25);
        }
        if (callback == null) {
            DiagramAction.$$$reportNull$$$0(26);
        }
        Consumer consumer = parameter -> {
            DiagramFullSnapshot oldSnapshot = DiagramFullSnapshot.Factory.getInstance().makeSnapshot(builder);
            Project project = builder.getProject();
            WriteCommandAction.writeCommandAction((Project)project).withName(callback.getActionName()).withGroupId(callback.getGroupName()).run(() -> {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                PsiFile[] files = callback.getAffectedFiles();
                callback.consume(parameter);
                DiagramActionsManager.getInstance(project).actionPerformed(builder, oldSnapshot, files);
            });
        };
        if (consumer == null) {
            DiagramAction.$$$reportNull$$$0(27);
        }
        return consumer;
    }

    public static <T> T performCommand(@NotNull DiagramBuilder builder, @NotNull Callable<T> call, @NotNull @Nls String commandName, @Nullable @NonNls String groupName, PsiElement ... elements) {
        if (builder == null) {
            DiagramAction.$$$reportNull$$$0(28);
        }
        if (call == null) {
            DiagramAction.$$$reportNull$$$0(29);
        }
        if (commandName == null) {
            DiagramAction.$$$reportNull$$$0(30);
        }
        if (elements == null) {
            DiagramAction.$$$reportNull$$$0(31);
        }
        PsiFile[] files = DiagramAction.getPsiFiles(elements);
        Project project = builder.getProject();
        CommandProcessor processor = CommandProcessor.getInstance();
        if (processor.getCurrentCommand() != null) {
            processor.setCurrentCommandName(commandName);
            processor.setCurrentCommandGroupId((Object)groupName);
        }
        try {
            return (T)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])files).withName(commandName).withGroupId(groupName).compute(() -> {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                DiagramFullSnapshot oldSnapshot = DiagramFullSnapshot.Factory.getInstance().makeSnapshot(builder);
                Object t = call.call();
                DiagramActionsManager.getInstance(project).actionPerformed(builder, oldSnapshot, files);
                builder.notifyOtherBuilders();
                return t;
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiFile @NotNull [] getPsiFiles(PsiElement @NotNull [] elements) {
        if (elements == null) {
            DiagramAction.$$$reportNull$$$0(32);
        }
        PsiFile[] psiFileArray = ContainerUtil.map2SetNotNull(Arrays.asList(elements), it -> it instanceof PsiFile ? (PsiFile)it : it.getContainingFile()).toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            DiagramAction.$$$reportNull$$$0(33);
        }
        return psiFileArray;
    }

    public static void performCommand(@NotNull DiagramBuilder builder, @NotNull Runnable run, @NotNull @Nls String commandName, @Nullable String groupName, PsiElement ... elements) {
        if (builder == null) {
            DiagramAction.$$$reportNull$$$0(34);
        }
        if (run == null) {
            DiagramAction.$$$reportNull$$$0(35);
        }
        if (commandName == null) {
            DiagramAction.$$$reportNull$$$0(36);
        }
        if (elements == null) {
            DiagramAction.$$$reportNull$$$0(37);
        }
        Callable<Object> call = () -> {
            run.run();
            return null;
        };
        DiagramAction.performCommand(builder, call, commandName, groupName, elements);
    }

    public static void showNotification(@NotNull @Nls String message, @NotNull DiagramBuilder builder) {
        if (message == null) {
            DiagramAction.$$$reportNull$$$0(38);
        }
        if (builder == null) {
            DiagramAction.$$$reportNull$$$0(39);
        }
        DiagramAction.showNotification(message, new RelativePoint(GraphCanvasLocationService.getInstance().getGraphCenterOnScreen(builder.getGraphBuilder())));
    }

    public static void showNotification(@NotNull @Nls String message, @NotNull DiagramNode<?> node, @NotNull DiagramBuilder builder) {
        if (message == null) {
            DiagramAction.$$$reportNull$$$0(40);
        }
        if (node == null) {
            DiagramAction.$$$reportNull$$$0(41);
        }
        if (builder == null) {
            DiagramAction.$$$reportNull$$$0(42);
        }
        Point point = GraphCanvasLocationService.getInstance().getNodeCoordinatesOnScreen(Objects.requireNonNull(builder.getNode(node)), builder.getGraphBuilder());
        DiagramAction.showNotification(message, new RelativePoint(point));
    }

    public static void showNotification(@NotNull @Nls String message, @NotNull RelativePoint point) {
        if (message == null) {
            DiagramAction.$$$reportNull$$$0(43);
        }
        if (point == null) {
            DiagramAction.$$$reportNull$$$0(44);
        }
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setFadeoutTime(2000L).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon().show(point, Balloon.Position.above);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 20, 21, 24, 27, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramAction";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 22: 
            case 25: 
            case 28: 
            case 34: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 31: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "run";
                break;
            }
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodesExceptNotes";
                break;
            }
            case 24: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallback";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 21: 
            case 24: 
            case 27: 
            case 33: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDataModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBuilderFromActionEvent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGraph";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getActionGroupId";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodesExceptNotes";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createCallback";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "performCommand";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFiles";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 20, 21, 24, 27, 33 -> new IllegalStateException(string);
        };
    }
}

