/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileType
extends LanguageFileType {
    public static final LanguageFileType INSTANCE = new PropertiesFileType();
    public static final String DEFAULT_EXTENSION = "properties";
    public static final String DOT_DEFAULT_EXTENSION = ".properties";
    private static final Logger log = Logger.getInstance(PropertiesFileType.class);

    private PropertiesFileType() {
        super((Language)PropertiesLanguage.INSTANCE);
    }

    protected PropertiesFileType(@NotNull Language language) {
        if (language == null) {
            PropertiesFileType.$$$reportNull$$$0(0);
        }
        super(language);
    }

    @NotNull
    public String getName() {
        return "Properties";
    }

    @NotNull
    public String getDescription() {
        String string = PropertiesBundle.message("filetype.properties.description", new Object[0]);
        if (string == null) {
            PropertiesFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.PropertiesFileType);
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        Charset charset;
        if (file == null) {
            PropertiesFileType.$$$reportNull$$$0(2);
        }
        if (content == null) {
            PropertiesFileType.$$$reportNull$$$0(3);
        }
        if ((charset = EncodingRegistry.getInstance().getDefaultCharsetForPropertiesFiles(file)) == null) {
            charset = this.getDefaultCharset();
            if (content.length > 0 && StandardCharsets.UTF_8.equals(charset)) {
                try (InputStream stream = file.getInputStream();){
                    content = stream.readAllBytes();
                    if (content.length > 0 && CharsetUtil.findUnmappableCharacters((ByteBuffer)ByteBuffer.wrap(content), (Charset)StandardCharsets.UTF_8) != null) {
                        charset = StandardCharsets.ISO_8859_1;
                    }
                }
                catch (IOException e) {
                    log.error("Failed to read content from file: " + file.getPath(), (Throwable)e);
                }
            }
        }
        if (EncodingRegistry.getInstance().isNative2Ascii(file)) {
            if (!(charset instanceof Native2AsciiCharset)) {
                charset = Native2AsciiCharset.wrap((Charset)charset);
            }
        } else {
            charset = Native2AsciiCharset.nativeToBaseCharset((Charset)charset);
        }
        return charset.name();
    }

    @NotNull
    public Charset getDefaultCharset() {
        if (Registry.is((String)"properties.file.encoding.legacy.support", (boolean)true)) {
            Charset charset = StandardCharsets.ISO_8859_1;
            if (charset == null) {
                PropertiesFileType.$$$reportNull$$$0(4);
            }
            return charset;
        }
        Charset charset = StandardCharsets.UTF_8;
        if (charset == null) {
            PropertiesFileType.$$$reportNull$$$0(5);
        }
        return charset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/PropertiesFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/PropertiesFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

