/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRemote
implements Comparable<GitRemote> {
    public static final GitRemote DOT = new GitRemote(".", Collections.singletonList("."), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    public static final String ORIGIN = "origin";
    @NotNull
    private final String myName;
    @NotNull
    private final List<String> myUrls;
    @NotNull
    private final Collection<String> myPushUrls;
    @NotNull
    private final List<String> myFetchRefSpecs;
    @NotNull
    private final List<String> myPushRefSpecs;

    public GitRemote(@NotNull String name, @NotNull List<String> urls, @NotNull Collection<String> pushUrls, @NotNull List<String> fetchRefSpecs, @NotNull List<String> pushRefSpecs) {
        if (name == null) {
            GitRemote.$$$reportNull$$$0(0);
        }
        if (urls == null) {
            GitRemote.$$$reportNull$$$0(1);
        }
        if (pushUrls == null) {
            GitRemote.$$$reportNull$$$0(2);
        }
        if (fetchRefSpecs == null) {
            GitRemote.$$$reportNull$$$0(3);
        }
        if (pushRefSpecs == null) {
            GitRemote.$$$reportNull$$$0(4);
        }
        this.myName = name;
        this.myUrls = urls;
        this.myPushUrls = pushUrls;
        this.myFetchRefSpecs = fetchRefSpecs;
        this.myPushRefSpecs = pushRefSpecs;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GitRemote.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public List<String> getUrls() {
        List<String> list = this.myUrls;
        if (list == null) {
            GitRemote.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public String getFirstUrl() {
        return this.myUrls.isEmpty() ? null : this.myUrls.get(0);
    }

    @NotNull
    public Collection<String> getPushUrls() {
        Collection<String> collection = this.myPushUrls;
        if (collection == null) {
            GitRemote.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public List<String> getFetchRefSpecs() {
        List<String> list = this.myFetchRefSpecs;
        if (list == null) {
            GitRemote.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<String> getPushRefSpecs() {
        List<String> list = this.myPushRefSpecs;
        if (list == null) {
            GitRemote.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRemote gitRemote = (GitRemote)o;
        return this.myName.equals(gitRemote.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @NonNls
    public String toString() {
        return String.format("GitRemote{myName='%s', myUrls=%s, myPushUrls=%s, myFetchRefSpec='%s', myPushRefSpec='%s'}", this.myName, this.myUrls, this.myPushUrls, this.myFetchRefSpecs, this.myPushRefSpecs);
    }

    @Override
    public int compareTo(@NotNull GitRemote o) {
        if (o == null) {
            GitRemote.$$$reportNull$$$0(10);
        }
        return this.getName().compareTo(o.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushUrls";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetchRefSpecs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushRefSpecs";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRemote";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRemote";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPushUrls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFetchRefSpecs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPushRefSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

