/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.core.impl.file.singleFile.JupyterSingleFileKeys;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBuilder;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesUtilsKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookIntervalPointersEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u001a\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener;", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerFactory$ChangeListener;", "document", "Lcom/intellij/openapi/editor/Document;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "getNotebook", "Lkotlin/Function0;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/notebooks/visualization/NotebookCellLines;Lkotlin/jvm/functions/Function0;)V", "onUpdated", "", "event", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointersEvent;", "onInserted", "notebook", "ordinals", "Lkotlin/ranges/IntRange;", "ordinal", "", "onEdited", "onRemoved", "onSwapped", "firstOrdinal", "secondOrdinal", "errorIfCellsNotMatchIntervals", "lastEvent", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterIntervalPointerChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterIntervalPointerChangeListener.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,132:1\n25#2:133\n25#2:134\n1557#3:135\n1628#3,2:136\n1630#3:141\n1104#4,3:138\n*S KotlinDebug\n*F\n+ 1 JupyterIntervalPointerChangeListener.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener\n*L\n119#1:133\n123#1:134\n126#1:135\n126#1:136,2\n126#1:141\n126#1:138,3\n*E\n"})
public final class JupyterIntervalPointerChangeListener
implements NotebookIntervalPointerFactory.ChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    @NotNull
    private final NotebookCellLines cellLines;
    @NotNull
    private final Function0<JupyterNotebook> getNotebook;

    private JupyterIntervalPointerChangeListener(Document document, NotebookCellLines cellLines, Function0<? extends JupyterNotebook> getNotebook) {
        this.document = document;
        this.cellLines = cellLines;
        this.getNotebook = getNotebook;
    }

    public void onUpdated(@NotNull NotebookIntervalPointersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ThreadingAssertions.assertWriteAccess();
        JupyterNotebook notebook = (JupyterNotebook)this.getNotebook.invoke();
        if (Intrinsics.areEqual((Object)this.document.getUserData(JupyterSingleFileKeys.INSTANCE.getIGNORE_JUPYTER_MODEL_CHANGES_ON_RELOAD()), (Object)true)) {
            return;
        }
        for (NotebookIntervalPointersEvent.Change c : event.getChanges()) {
            NotebookIntervalPointersEvent.Change change = c;
            if (change instanceof NotebookIntervalPointersEvent.OnEdited) {
                this.onEdited(notebook, ((NotebookIntervalPointersEvent.OnEdited)c).getOrdinal());
                continue;
            }
            if (change instanceof NotebookIntervalPointersEvent.OnInserted) {
                this.onInserted(notebook, ((NotebookIntervalPointersEvent.OnInserted)c).getOrdinals());
                continue;
            }
            if (change instanceof NotebookIntervalPointersEvent.OnRemoved) {
                this.onRemoved(notebook, ((NotebookIntervalPointersEvent.OnRemoved)c).getOrdinals());
                continue;
            }
            if (change instanceof NotebookIntervalPointersEvent.OnSwapped) {
                this.onSwapped(notebook, ((NotebookIntervalPointersEvent.OnSwapped)c).getFirstOrdinal(), ((NotebookIntervalPointersEvent.OnSwapped)c).getSecondOrdinal());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        this.errorIfCellsNotMatchIntervals(notebook, event);
    }

    private final void onInserted(JupyterNotebook notebook, IntRange ordinals) {
        int n;
        int ordinal = ordinals.getFirst();
        if (ordinal <= (n = ordinals.getLast())) {
            while (true) {
                this.onInserted(notebook, ordinal);
                if (ordinal == n) break;
                ++ordinal;
            }
        }
    }

    private final void onInserted(JupyterNotebook notebook, int ordinal) {
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)this.cellLines.getIntervals().get(ordinal);
        notebook.addCell(ordinal, (Function1<? super JupyterCellBuilder, Unit>)((Function1)arg_0 -> JupyterIntervalPointerChangeListener.onInserted$lambda$0(this, interval, arg_0)));
    }

    private final void onEdited(JupyterNotebook notebook, int ordinal) {
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)this.cellLines.getIntervals().get(ordinal);
        JupyterCell cell = notebook.getCell(ordinal);
        JupyterCellType jupyterCellType = JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(interval);
        Intrinsics.checkNotNull((Object)jupyterCellType);
        cell.setCellType(jupyterCellType);
        cell.setSource(((Object)NotebookCellLinesUtilsKt.getContentText((Document)this.document, (NotebookCellLines.Interval)interval)).toString());
    }

    private final void onRemoved(JupyterNotebook notebook, IntRange ordinals) {
        int ordinal;
        int n = ordinals.getFirst();
        if (n <= (ordinal = ordinals.getLast())) {
            while (true) {
                this.onRemoved(notebook, ordinal);
                if (ordinal == n) break;
                --ordinal;
            }
        }
    }

    private final void onRemoved(JupyterNotebook notebook, int ordinal) {
        notebook.removeCell(ordinal);
    }

    private final void onSwapped(JupyterNotebook notebook, int firstOrdinal, int secondOrdinal) {
        notebook.swapIdsAndOutputs(firstOrdinal, secondOrdinal);
    }

    /*
     * WARNING - void declaration
     */
    private final void errorIfCellsNotMatchIntervals(JupyterNotebook notebook, NotebookIntervalPointersEvent lastEvent) {
        List intervals = NotebookCellLines.Companion.get(this.document).getIntervals();
        if (this.getNotebook.invoke() != notebook) {
            JupyterIntervalPointerChangeListener $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterIntervalPointerChangeListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("race condition, notebook was changed by other code under write lock");
        }
        if (notebook.cellsCount() != intervals.size()) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<JupyterCell> cells = notebook.computeCells();
            Object $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterIntervalPointerChangeListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            $this$thisLogger$iv = cells;
            List list = intervals;
            NotebookIntervalPointersEvent notebookIntervalPointersEvent = lastEvent;
            int n = intervals.size();
            int n2 = cells.size();
            Logger logger2 = logger;
            boolean $i$f$map = false;
            void var7_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JupyterCell jupyterCell = (JupyterCell)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CharSequence $this$count$iv = it.getSource();
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it2 = element$iv = $this$count$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(it2 == '\n')) continue;
                    ++count$iv;
                }
                collection.add(count$iv + 1);
            }
            collection = (List)destination$iv$iv;
            logger2.error(StringsKt.trimMargin$default((String)("cells.size = " + n2 + ", but intervals.size = " + n + ", last event = " + notebookIntervalPointersEvent + "\n          |intervals = " + list + ",\n          |cells sizes = " + (List)collection + "\n        "), null, (int)1, null));
        }
    }

    private static final Unit onInserted$lambda$0(JupyterIntervalPointerChangeListener this$0, NotebookCellLines.Interval $interval, JupyterCellBuilder $this$addCell) {
        Intrinsics.checkNotNullParameter((Object)$this$addCell, (String)"$this$addCell");
        $this$addCell.setSource(((Object)NotebookCellLinesUtilsKt.getContentText((Document)this$0.document, (NotebookCellLines.Interval)$interval)).toString());
        JupyterCellType jupyterCellType = JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType($interval);
        Intrinsics.checkNotNull((Object)jupyterCellType);
        $this$addCell.setCellType(jupyterCellType);
        return Unit.INSTANCE;
    }

    public /* synthetic */ JupyterIntervalPointerChangeListener(Document document, NotebookCellLines cellLines, Function0 getNotebook, DefaultConstructorMarker $constructor_marker) {
        this(document, cellLines, (Function0<? extends JupyterNotebook>)getNotebook);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener$Companion;", "", "<init>", "()V", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterIntervalPointerChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterIntervalPointerChangeListener.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1755#2,3:133\n*S KotlinDebug\n*F\n+ 1 JupyterIntervalPointerChangeListener.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterIntervalPointerChangeListener$Companion\n*L\n37#1:133,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!JupyterEditorExtensionsKt.isJupyter((Editor)editor)) {
                return;
            }
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            DocumentEx documentEx = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx document = documentEx;
            BackedNotebookVirtualFile notebookVirtualFile2 = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor);
            NotebookCellLines cellLines = NotebookCellLines.Companion.get((Document)document);
            NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(project2, (Document)document);
            if (notebookIntervalPointerFactory == null) {
                return;
            }
            NotebookIntervalPointerFactory pointersFactory = notebookIntervalPointerFactory;
            WriteAction.run(() -> Companion.install$lambda$2(pointersFactory, document, cellLines, editor, notebookVirtualFile2));
        }

        private static final JupyterNotebook install$lambda$2$lambda$1(BackedNotebookVirtualFile $notebookVirtualFile) {
            return $notebookVirtualFile.getNotebook();
        }

        private static final void install$lambda$2(NotebookIntervalPointerFactory $pointersFactory, DocumentEx $document, NotebookCellLines $cellLines, EditorImpl $editor, BackedNotebookVirtualFile $notebookVirtualFile) {
            boolean isAlreadyInstalled;
            block7: {
                List list = $pointersFactory.getChangeListeners().getListeners();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getListeners(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        NotebookIntervalPointerFactory.ChangeListener it = (NotebookIntervalPointerFactory.ChangeListener)element$iv;
                        boolean bl = false;
                        if (!(it instanceof JupyterIntervalPointerChangeListener)) continue;
                        v1 = true;
                        break block7;
                    }
                    v1 = isAlreadyInstalled = false;
                }
            }
            if (isAlreadyInstalled) {
                return;
            }
            JupyterIntervalPointerChangeListener listener2 = new JupyterIntervalPointerChangeListener((Document)$document, $cellLines, () -> Companion.install$lambda$2$lambda$1($notebookVirtualFile), null);
            $pointersFactory.getChangeListeners().addListener((EventListener)((Object)listener2), $editor.getDisposable());
            JupyterNotebook notebook = $notebookVirtualFile.getNotebook();
            Iterator iterator = ((Iterable)$cellLines.getIntervals()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                NotebookCellLines.Interval interval = (NotebookCellLines.Interval)iterator.next();
                if (notebook.cellsCount() <= index) {
                    listener2.onInserted(notebook, index);
                    continue;
                }
                if (notebook.getCell(index).getCellType() == JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(interval)) {
                    listener2.onEdited(notebook, index);
                    continue;
                }
                listener2.onRemoved(notebook, index);
                listener2.onInserted(notebook, index);
            }
            listener2.errorIfCellsNotMatchIntervals(notebook, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

